package com.zurrtum.create.client.foundation.utility;

import com.zurrtum.create.catnip.data.Couple;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_1767;
import net.minecraft.class_1935;
import net.minecraft.class_2246;

public class DyeHelper {

    public static class_1935 getWoolOfDye(class_1767 color) {
        return WOOL_TABLE.getOrDefault(color, () -> class_2246.field_10446).get();
    }

    public static Couple<Integer> getDyeColors(class_1767 color) {
        return DYE_TABLE.getOrDefault(color, DYE_TABLE.get(class_1767.field_7952));
    }

    /**
     * Adds a dye color s.t. Create's blocks can use it instead of defaulting to white.
     *
     * @param color       Dye color to add
     * @param brightColor Front (bright) RGB color
     * @param darkColor   Back (dark) RGB color
     * @param wool        Supplier of wool item/block corresponding to the color
     */
    public static void addDye(class_1767 color, Integer brightColor, Integer darkColor, Supplier<class_1935> wool) {
        DYE_TABLE.put(color, Couple.create(brightColor, darkColor));
        WOOL_TABLE.put(color, wool);
    }

    private static void addDye(class_1767 color, Integer brightColor, Integer darkColor, class_1935 wool) {
        addDye(color, brightColor, darkColor, () -> wool);
    }

    private static final Map<class_1767, Supplier<class_1935>> WOOL_TABLE = new HashMap<>();

    private static final Map<class_1767, Couple<Integer>> DYE_TABLE = new HashMap<>();

    static {
        // DyeColor, ( Front RGB, Back RGB )
        addDye(class_1767.field_7963, 0x45403B, 0x21201F, class_2246.field_10146);
        addDye(class_1767.field_7964, 0xB13937, 0x632737, class_2246.field_10314);
        addDye(class_1767.field_7942, 0x208A46, 0x1D6045, class_2246.field_10170);
        addDye(class_1767.field_7957, 0xAC855C, 0x68533E, class_2246.field_10113);

        addDye(class_1767.field_7966, 0x5391E1, 0x504B90, class_2246.field_10514);
        addDye(class_1767.field_7944, 0x5D666F, 0x313538, class_2246.field_10423);
        addDye(class_1767.field_7967, 0x95969B, 0x707070, class_2246.field_10222);
        addDye(class_1767.field_7945, 0x9F54AE, 0x63366C, class_2246.field_10259);

        addDye(class_1767.field_7955, 0x3EABB4, 0x3C7872, class_2246.field_10619);
        addDye(class_1767.field_7954, 0xD5A8CB, 0xB86B95, class_2246.field_10459);
        addDye(class_1767.field_7961, 0xA3DF55, 0x4FB16F, class_2246.field_10028);
        addDye(class_1767.field_7947, 0xE6D756, 0xE9AC29, class_2246.field_10490);

        addDye(class_1767.field_7951, 0x69CED2, 0x508AA5, class_2246.field_10294);
        addDye(class_1767.field_7946, 0xEE9246, 0xD94927, class_2246.field_10095);
        addDye(class_1767.field_7958, 0xF062B0, 0xC04488, class_2246.field_10215);
        addDye(class_1767.field_7952, 0xEDEAE5, 0xBBB6B0, class_2246.field_10446);
    }
}
