package com.zurrtum.create.client.infrastructure.model;

import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.client.AllCTBehaviours;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.content.decoration.bracket.BracketedBlockEntityBehaviour;
import com.zurrtum.create.content.fluids.FluidTransportBehaviour;
import com.zurrtum.create.content.fluids.FluidTransportBehaviour.AttachmentTypes;
import com.zurrtum.create.content.fluids.FluidTransportBehaviour.AttachmentTypes.ComponentPartials;
import com.zurrtum.create.content.fluids.pipes.FluidPipeBlock;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_10889;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_5819;

public class PipeAttachmentModel extends WrapperBlockStateModel {
    public PipeAttachmentModel(class_2680 state, class_9979 unbaked) {
        super(state, unbaked);
    }

    public static class_9979 encased(class_2680 state, class_9979 unbaked) {
        return new PipeAttachmentModel(state, new CTModel(state, unbaked, AllCTBehaviours.COPPER_CASING));
    }

    @Override
    public void addPartsWithInfo(class_1920 world, class_2338 pos, class_2680 state, class_5819 random, List<class_10889> parts) {
        if (model instanceof WrapperBlockStateModel wrapper) {
            wrapper.addPartsWithInfo(world, pos, state, random, parts);
        } else {
            model.method_68513(random, parts);
        }
        Optional.ofNullable(BlockEntityBehaviour.get(world, pos, BracketedBlockEntityBehaviour.TYPE)).map(BracketedBlockEntityBehaviour::getBracket)
            .map(bracket -> class_310.method_1551().method_1541().method_3349(bracket))
            .ifPresent(model -> model.method_68513(random, parts));
        FluidTransportBehaviour transport = BlockEntityBehaviour.get(world, pos, FluidTransportBehaviour.TYPE);
        if (transport != null) {
            for (class_2350 direction : Iterate.directions) {
                AttachmentTypes type = transport.getRenderedRimAttachment(world, pos, state, direction);
                for (ComponentPartials partial : type.partials) {
                    parts.add(AllPartialModels.PIPE_ATTACHMENTS.get(partial).get(direction).get());
                }
            }
        }
        if (FluidPipeBlock.shouldDrawCasing(world, pos, state)) {
            parts.add(AllPartialModels.FLUID_PIPE_CASING.get());
        }
    }
}
