package com.zurrtum.create.client.infrastructure.particle;

import com.zurrtum.create.client.flywheel.lib.util.ShadersModHelper;
import net.minecraft.class_11944;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_4002;
import net.minecraft.class_4184;
import net.minecraft.class_638;
import net.minecraft.class_708;
import net.minecraft.class_765;
import net.minecraft.class_7833;
import net.minecraft.class_9848;
import org.joml.Quaternionf;

public class CustomRotationParticle extends class_708 {
    protected boolean mirror;
    protected int loopLength;

    public CustomRotationParticle(class_638 worldIn, double x, double y, double z, class_4002 spriteSet, float yAccel) {
        super(worldIn, x, y, z, spriteSet, yAccel);
    }

    public void selectSpriteLoopingWithAge(class_4002 sprite) {
        int loopFrame = field_3866 % loopLength;
        this.method_74307(sprite.method_18138(loopFrame, loopLength));
    }

    public Quaternionf getCustomRotation(class_4184 camera, float partialTicks) {
        Quaternionf quaternion = new Quaternionf(camera.method_23767());
        if (field_62637 != 0.0F) {
            float angle = class_3532.method_16439(partialTicks, field_62638, field_62637);
            quaternion.mul(class_7833.field_40718.rotation(angle));
        }
        return quaternion;
    }

    @Override
    public void method_3074(class_11944 submittable, class_4184 camera, float partialTicks) {
        class_243 cameraPos = camera.method_19326();
        float originX = (float) (class_3532.method_16436(partialTicks, field_3858, field_3874) - cameraPos.method_10216());
        float originY = (float) (class_3532.method_16436(partialTicks, field_3838, field_3854) - cameraPos.method_10214());
        float originZ = (float) (class_3532.method_16436(partialTicks, field_3856, field_3871) - cameraPos.method_10215());
        Quaternionf rotation = getCustomRotation(camera, partialTicks);
        submittable.method_74323(
            method_74255(),
            originX,
            originY,
            originZ,
            rotation.x,
            rotation.y,
            rotation.z,
            rotation.w,
            method_18132(partialTicks),
            mirror ? method_18134() : method_18133(),
            mirror ? method_18133() : method_18134(),
            method_18135(),
            method_18136(),
            class_9848.method_61318(field_62636, field_62633, field_62634, field_62635),
            ShadersModHelper.isShaderPackInUse() ? class_765.method_23687(12, 15) : method_3068(partialTicks)
        );
    }
}
