package com.zurrtum.create.client.infrastructure.ponder.scenes;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.catnip.math.Pointing;
import com.zurrtum.create.client.foundation.ponder.CreateSceneBuilder;
import com.zurrtum.create.client.ponder.api.ParticleEmitter;
import com.zurrtum.create.client.ponder.api.PonderPalette;
import com.zurrtum.create.client.ponder.api.element.ElementLink;
import com.zurrtum.create.client.ponder.api.element.EntityElement;
import com.zurrtum.create.client.ponder.api.element.MinecartElement;
import com.zurrtum.create.client.ponder.api.element.WorldSectionElement;
import com.zurrtum.create.client.ponder.api.scene.SceneBuilder;
import com.zurrtum.create.client.ponder.api.scene.SceneBuildingUtil;
import com.zurrtum.create.client.ponder.api.scene.Selection;
import com.zurrtum.create.content.contraptions.mounted.CartAssembleRailType;
import com.zurrtum.create.content.contraptions.mounted.CartAssemblerBlock;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2768;

public class CartAssemblerScenes {

    public static void anchor(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("cart_assembler", "Moving Structures using Cart Assemblers");
        scene.configureBasePlate(0, 0, 5);
        scene.scaleSceneView(.9f);
        scene.world().showSection(util.select().layer(0), class_2350.field_11036);
        scene.idle(5);

        class_2338 assemblerPos = util.grid().at(2, 1, 2);
        scene.world().setBlock(assemblerPos, class_2246.field_10167.method_9564(), false);
        for (int z = 0; z < 5; z++) {
            scene.world().showSection(util.select().position(2, 1, z), class_2350.field_11033);
            scene.idle(2);
        }

        class_2338 leverPos = util.grid().at(0, 1, 2);
        Selection toggle = util.select().fromTo(assemblerPos, leverPos);

        scene.idle(10);

        scene.overlay().showControls(util.vector().centerOf(assemblerPos), Pointing.DOWN, 30).rightClick()
            .withItem(AllItems.CART_ASSEMBLER.method_7854());
        scene.idle(7);
        scene.world().setBlock(
            assemblerPos,
            AllBlocks.CART_ASSEMBLER.method_9564().method_11657(CartAssemblerBlock.RAIL_SHAPE, class_2768.field_12665)
                .method_11657(CartAssemblerBlock.RAIL_TYPE, CartAssembleRailType.REGULAR),
            true
        );
        scene.idle(20);
        scene.world().showSection(util.select().fromTo(0, 1, 2, 1, 1, 2), class_2350.field_11034);
        scene.idle(20);
        scene.world().toggleRedstonePower(toggle);
        scene.effects().indicateRedstone(leverPos);
        scene.idle(10);

        scene.overlay().showText(70).text("Powered Cart Assemblers mount attached structures to passing Minecarts").attachKeyFrame()
            .pointAt(util.vector().topOf(assemblerPos)).placeNearTarget();
        scene.idle(80);

        ElementLink<MinecartElement> cart = scene.special().createCart(util.vector().topOf(2, 0, 4), 90, class_1299.field_6096::method_5883);
        scene.world().showSection(util.select().position(assemblerPos.method_10084()), class_2350.field_11033);
        scene.idle(10);
        scene.special().moveCart(cart, util.vector().of(0, 0, -2), 20);
        scene.idle(20);
        ElementLink<WorldSectionElement> plank = scene.world().makeSectionIndependent(util.select().position(assemblerPos.method_10084()));
        ElementLink<WorldSectionElement> anchor = scene.world().showIndependentSectionImmediately(util.select().position(assemblerPos.method_10078()));
        scene.world().moveSection(anchor, util.vector().of(-1, 0, 0), 0);
        scene.effects().indicateSuccess(assemblerPos);
        scene.idle(1);
        scene.world().moveSection(anchor, util.vector().of(0, 0, -2), 20);
        scene.world().moveSection(plank, util.vector().of(0, 0, -2), 20);
        scene.special().moveCart(cart, util.vector().of(0, 0, -2), 20);
        scene.idle(20);

        scene.world().toggleRedstonePower(toggle);
        scene.idle(10);

        scene.overlay().showText(70).text("Without a redstone signal, it disassembles passing cart contraptions back into blocks")
            .colored(PonderPalette.RED).attachKeyFrame().pointAt(util.vector().topOf(assemblerPos)).placeNearTarget();
        scene.idle(80);

        scene.world().rotateSection(anchor, 0, 180, 0, 6);
        scene.world().rotateSection(plank, 0, 180, 0, 6);
        scene.idle(3);

        scene.world().moveSection(anchor, util.vector().of(0, 0, 2), 20);
        scene.world().moveSection(plank, util.vector().of(0, 0, 2), 20);
        scene.special().moveCart(cart, util.vector().of(0, 0, 2), 20);
        scene.idle(21);
        scene.world().moveSection(anchor, util.vector().of(0, -2, 0), 0);
        scene.special().moveCart(cart, util.vector().of(0, 0, 2), 20);
        scene.idle(30);

        scene.world().destroyBlock(assemblerPos.method_10084());
        scene.idle(5);
        scene.world().replaceBlocks(util.select().fromTo(3, 3, 2, 1, 4, 2), class_2246.field_10161.method_9564(), false);
        ElementLink<WorldSectionElement> contraption = scene.world().showIndependentSection(util.select().fromTo(1, 4, 2, 3, 3, 2), class_2350.field_11033);
        scene.world().moveSection(contraption, util.vector().of(0, -1, 0), 0);
        scene.idle(10);
        scene.world().showSectionAndMerge(util.select().position(3, 3, 1), class_2350.field_11035, contraption);

        scene.idle(15);
        scene.overlay().showOutline(
            PonderPalette.GREEN,
            "glue",
            util.select().position(1, 3, 2).add(util.select().fromTo(3, 2, 2, 1, 2, 2)).add(util.select().position(3, 2, 1)),
            40
        );
        scene.overlay().showControls(util.vector().centerOf(util.grid().at(3, 2, 2)), Pointing.RIGHT, 40)
            .withItem(AllItems.SUPER_GLUE.method_7854());

        scene.effects().superGlue(util.grid().at(3, 2, 1), class_2350.field_11035, true);
        scene.overlay().showText(80).attachKeyFrame().sharedText("movement_anchors")
            .pointAt(util.vector().blockSurface(util.grid().at(1, 3, 2), class_2350.field_11043)).placeNearTarget();
        scene.idle(80);
        scene.world().toggleRedstonePower(toggle);
        scene.effects().indicateRedstone(leverPos);

        scene.special().moveCart(cart, util.vector().of(0, 0, -2), 20);
        scene.idle(20);
        scene.world().moveSection(anchor, util.vector().of(0, 2, 0), 0);
        scene.idle(1);
        scene.world().moveSection(anchor, util.vector().of(0, 0, -2), 20);
        scene.world().moveSection(contraption, util.vector().of(0, 0, -2), 20);
        scene.special().moveCart(cart, util.vector().of(0, 0, -2), 20);
        scene.idle(25);

        class_243 cartCenter = util.vector().centerOf(assemblerPos.method_10076(2));
        scene.overlay().showControls(cartCenter, Pointing.LEFT, 40).rightClick().withItem(AllItems.WRENCH.method_7854());
        scene.idle(7);
        scene.special().moveCart(cart, util.vector().of(0, -100, 4), 0);
        scene.world().moveSection(anchor, util.vector().of(0, -100, 4), 0);
        scene.world().moveSection(contraption, util.vector().of(0, -100, 4), 0);
        class_1799 asStack = AllItems.MINECART_CONTRAPTION.method_7854();
        ElementLink<EntityElement> itemEntity = scene.world().createItemEntity(cartCenter, util.vector().of(0, .1, 0), asStack);
        scene.idle(40);
        scene.overlay().showText(80).attachKeyFrame().text("Using a Wrench on the Minecart will let you carry the Contraption elsewhere")
            .pointAt(cartCenter).placeNearTarget();
        scene.idle(80);
        scene.world().modifyEntity(itemEntity, class_1297::method_31472);

        scene.overlay().showControls(cartCenter.method_1031(0, 0, 4), Pointing.DOWN, 20).rightClick().withItem(asStack);
        scene.idle(20);
        scene.special().moveCart(cart, util.vector().of(0, 100.5, 0), 0);
        scene.world().moveSection(anchor, util.vector().of(0, 100.5, 0), 0);
        scene.world().moveSection(contraption, util.vector().of(0, 100.5, 0), 0);
        scene.idle(1);
        scene.special().moveCart(cart, util.vector().of(0, -.5, 0), 5);
        scene.world().moveSection(anchor, util.vector().of(0, -.5, 0), 5);
        scene.world().moveSection(contraption, util.vector().of(0, -.5, 0), 5);
    }

    public static void modes(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("cart_assembler_modes", "Orientation Settings for Minecart Contraptions");
        scene.configureBasePlate(0, 0, 5);
        scene.world().showSection(util.select().layer(0), class_2350.field_11036);
        scene.idle(5);

        for (int z = 0; z < 4; z++) {
            scene.world().showSection(util.select().position(1, 1, z), class_2350.field_11033);
            scene.idle(2);
        }
        for (int x = 2; x < 5; x++) {
            scene.world().showSection(util.select().position(x, 1, 3), class_2350.field_11033);
            scene.idle(2);
        }

        class_2338 assemblerPos = util.grid().at(3, 1, 3);
        scene.idle(5);
        scene.world().setBlock(
            assemblerPos,
            AllBlocks.CART_ASSEMBLER.method_9564().method_11657(CartAssemblerBlock.RAIL_SHAPE, class_2768.field_12674)
                .method_11657(CartAssemblerBlock.RAIL_TYPE, CartAssembleRailType.REGULAR),
            true
        );
        scene.idle(5);
        scene.world().showSection(util.select().fromTo(3, 1, 1, 3, 1, 2), class_2350.field_11035);
        ElementLink<WorldSectionElement> contraption = scene.world().showIndependentSection(util.select().position(3, 2, 3), class_2350.field_11033);
        scene.idle(10);
        scene.world().glueBlockOnto(util.grid().at(2, 2, 3), class_2350.field_11034, contraption);
        scene.world().toggleRedstonePower(util.select().fromTo(3, 1, 1, 3, 1, 3));
        scene.effects().indicateRedstone(util.grid().at(3, 1, 1));
        scene.idle(10);

        ElementLink<MinecartElement> cart = scene.special().createCart(util.vector().topOf(util.grid().at(4, 0, 3)), 0, class_1299.field_6096::method_5883);
        scene.idle(20);
        scene.special().moveCart(cart, util.vector().of(-1, 0, 0), 10);
        scene.idle(10);
        ElementLink<WorldSectionElement> anchor = scene.world().showIndependentSectionImmediately(util.select().position(assemblerPos.method_10072()));
        scene.world().moveSection(anchor, util.vector().of(0, 0, -1), 0);
        scene.idle(1);

        scene.world().setKineticSpeed(util.select().position(2, 2, 3), 32);
        scene.special().moveCart(cart, util.vector().of(-1.5, 0, 0), 15);
        scene.world().moveSection(anchor, util.vector().of(-1.5, 0, 0), 15);
        scene.world().moveSection(contraption, util.vector().of(-1.5, 0, 0), 15);
        scene.idle(16);
        scene.special().rotateCart(cart, -45, 2);
        scene.special().moveCart(cart, util.vector().of(-.5, 0, -.5), 8);
        scene.world().moveSection(anchor, util.vector().of(-.5, 0, -.5), 8);
        scene.world().moveSection(contraption, util.vector().of(-.5, 0, -.5), 8);
        scene.world().rotateSection(anchor, 0, -90, 0, 12);
        scene.world().rotateSection(contraption, 0, -90, 0, 12);
        scene.idle(9);
        scene.special().rotateCart(cart, -45, 2);
        scene.special().moveCart(cart, util.vector().of(0, 0, -1.5), 15);
        scene.world().moveSection(anchor, util.vector().of(0, 0, -1.5), 15);
        scene.world().moveSection(contraption, util.vector().of(0, 0, -1.5), 15);
        scene.idle(15);
        scene.world().setKineticSpeed(util.select().position(2, 2, 3), 0);

        scene.overlay().showText(80).attachKeyFrame().text("Cart Contraptions will rotate to face towards their carts' motion")
            .pointAt(util.vector().of(1.5, 2.5, 0)).placeNearTarget();
        scene.idle(90);

        scene.overlay().showText(80).attachKeyFrame().text("This Arrow indicates which side of the Structure will be considered the front")
            .pointAt(util.vector().topOf(assemblerPos)).placeNearTarget();
        scene.idle(90);

        scene.world().hideIndependentSection(contraption, class_2350.field_11036);
        scene.world().hideIndependentSection(anchor, class_2350.field_11036);
        scene.special().hideElement(cart, class_2350.field_11036);
        scene.idle(25);

        class_243 blockSurface = util.vector().blockSurface(assemblerPos, class_2350.field_11043).method_1031(0, -1 / 16f, -2 / 16f);
        scene.overlay().showFilterSlotInput(blockSurface, class_2350.field_11043, 60);
        scene.overlay().showControls(blockSurface, Pointing.DOWN, 60).rightClick();
        scene.idle(10);
        scene.overlay().showText(60).pointAt(util.vector().of(3, 1.5, 3)).placeNearTarget().sharedText("behaviour_modify_value_panel");
        scene.idle(70);

        contraption = scene.world().showIndependentSection(util.select().fromTo(3, 2, 3, 2, 2, 3), class_2350.field_11033);
        cart = scene.special().createCart(util.vector().topOf(util.grid().at(4, 0, 3)), 0, class_1299.field_6096::method_5883);
        scene.idle(10);
        scene.special().moveCart(cart, util.vector().of(-1, 0, 0), 10);
        scene.idle(10);
        anchor = scene.world().showIndependentSectionImmediately(util.select().position(assemblerPos.method_10072()));
        scene.world().moveSection(anchor, util.vector().of(0, 0, -1), 0);
        scene.idle(1);

        scene.world().setKineticSpeed(util.select().position(2, 2, 3), 32);
        scene.special().moveCart(cart, util.vector().of(-1.5, 0, 0), 15);
        scene.world().moveSection(anchor, util.vector().of(-1.5, 0, 0), 15);
        scene.world().moveSection(contraption, util.vector().of(-1.5, 0, 0), 15);
        scene.idle(16);
        scene.special().rotateCart(cart, -45, 2);
        scene.special().moveCart(cart, util.vector().of(-.5, 0, -.5), 8);
        scene.world().moveSection(anchor, util.vector().of(-.5, 0, -.5), 8);
        scene.world().moveSection(contraption, util.vector().of(-.5, 0, -.5), 8);
        scene.idle(9);
        scene.special().rotateCart(cart, -45, 2);
        scene.special().moveCart(cart, util.vector().of(0, 0, -1.5), 15);
        scene.world().moveSection(anchor, util.vector().of(0, 0, -1.5), 15);
        scene.world().moveSection(contraption, util.vector().of(0, 0, -1.5), 15);
        scene.idle(15);
        scene.world().setKineticSpeed(util.select().position(2, 2, 3), 0);

        scene.overlay().showText(80).attachKeyFrame()
            .text("If the Assembler is set to Lock Rotation, the contraptions' orientation will never change").pointAt(util.vector().of(0, 2.5, 1.5))
            .placeNearTarget();
        scene.idle(90);
    }

    public static void dual(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("cart_assembler_dual", "Assembling Carriage Contraptions");
        scene.configureBasePlate(0, 0, 6);
        scene.scaleSceneView(.9f);
        scene.world().showSection(util.select().layer(0), class_2350.field_11036);
        scene.idle(5);

        for (int z = 0; z < 5; z++) {
            scene.world().showSection(util.select().position(1, 1, z), class_2350.field_11033);
            scene.idle(2);
        }
        for (int x = 2; x < 6; x++) {
            scene.world().showSection(util.select().position(x, 1, 4), class_2350.field_11033);
            scene.idle(2);
        }

        class_2338 assembler1 = util.grid().at(2, 1, 4);
        class_2338 assembler2 = util.grid().at(5, 1, 4);
        Selection chassis = util.select().fromTo(5, 2, 4, 2, 2, 4);

        scene.idle(5);
        scene.world().showSection(util.select().fromTo(2, 1, 3, 2, 1, 2), class_2350.field_11035);
        scene.idle(5);
        ElementLink<MinecartElement> cart = scene.special().createCart(util.vector().topOf(assembler1.method_10074()), 0, class_1299.field_6096::method_5883);
        ElementLink<MinecartElement> cart2 = scene.special().createCart(util.vector().topOf(assembler2.method_10074()), 0, class_1299.field_6126::method_5883);
        scene.idle(15);
        scene.world().setBlock(
            assembler1,
            AllBlocks.CART_ASSEMBLER.method_9564().method_11657(CartAssemblerBlock.RAIL_SHAPE, class_2768.field_12674)
                .method_11657(CartAssemblerBlock.RAIL_TYPE, CartAssembleRailType.CONTROLLER_RAIL),
            true
        );
        scene.idle(5);
        scene.world().setBlock(
            assembler2,
            AllBlocks.CART_ASSEMBLER.method_9564().method_11657(CartAssemblerBlock.RAIL_SHAPE, class_2768.field_12674)
                .method_11657(CartAssemblerBlock.RAIL_TYPE, CartAssembleRailType.REGULAR),
            true
        );
        scene.idle(5);

        ElementLink<WorldSectionElement> contraption = scene.world().showIndependentSection(chassis, class_2350.field_11033);
        scene.idle(15);
        scene.overlay().showOutline(PonderPalette.GREEN, new Object(), util.select().position(assembler2), 60);
        scene.overlay().showOutlineWithText(util.select().position(assembler1), 60).colored(PonderPalette.GREEN)
            .pointAt(util.vector().blockSurface(util.grid().at(2, 2, 4), class_2350.field_11043)).placeNearTarget()
            .text("Whenever two Cart Assembers share an attached structure...").attachKeyFrame();
        scene.idle(70);

        scene.overlay().showText(60).pointAt(util.vector().blockSurface(util.grid().at(2, 1, 4), class_2350.field_11043)).placeNearTarget()
            .text("Powering either of them will create a Carriage Contraption");
        scene.idle(70);

        scene.effects().indicateRedstone(util.grid().at(2, 1, 2));
        scene.world().toggleRedstonePower(util.select().fromTo(2, 1, 2, 2, 1, 4));
        ElementLink<WorldSectionElement> anchors = scene.world()
            .showIndependentSectionImmediately(util.select().fromTo(assembler1.method_10072(), assembler2.method_10072()));
        scene.world().moveSection(anchors, util.vector().of(0, 0, -1), 0);
        scene.world().configureCenterOfRotation(anchors, util.vector().centerOf(util.grid().at(2, 2, 5)));
        scene.world().configureCenterOfRotation(contraption, util.vector().centerOf(util.grid().at(2, 2, 4)));
        scene.idle(5);

        class_243 m = util.vector().of(-0.5, 0, 0);
        scene.special().moveCart(cart, m, 5);
        scene.special().moveCart(cart2, m, 5);
        scene.world().moveSection(contraption, m, 5);
        scene.world().moveSection(anchors, m, 5);
        scene.idle(5);
        scene.special().rotateCart(cart, -45, 2);
        scene.special().moveCart(cart2, util.vector().of(-.3, 0, 0), 8);
        m = util.vector().of(-.5, 0, -.5);
        scene.special().moveCart(cart, m, 8);
        scene.world().moveSection(anchors, m, 8);
        scene.world().moveSection(contraption, m, 8);
        scene.world().rotateSection(anchors, 0, -10, 0, 8);
        scene.world().rotateSection(contraption, 0, -10, 0, 8);
        scene.idle(8);
        scene.special().rotateCart(cart, -45, 2);
        scene.special().moveCart(cart2, util.vector().of(-.4, 0, 0), 5);
        m = util.vector().of(0, 0, -3.5);
        scene.special().moveCart(cart, m, 25);
        scene.world().moveSection(anchors, m, 25);
        scene.world().moveSection(contraption, m, 25);
        scene.world().rotateSection(anchors, 0, -33, 0, 10);
        scene.world().rotateSection(contraption, 0, -33, 0, 10);
        scene.idle(5);
        scene.special().moveCart(cart2, util.vector().of(-0.8, 0, 0), 5);
        scene.idle(5);
        scene.special().moveCart(cart2, util.vector().of(-1.5, 0, 0), 9);
        scene.world().rotateSection(anchors, 0, -42, 0, 9);
        scene.world().rotateSection(contraption, 0, -42, 0, 9);
        scene.idle(9);
        m = util.vector().of(-.5, 0, -.5);
        scene.special().moveCart(cart2, m, 2);
        scene.special().rotateCart(cart2, -45, 2);
        scene.world().rotateSection(anchors, 0, -5, 0, 5);
        scene.world().rotateSection(contraption, 0, -5, 0, 5);
        scene.idle(2);
        scene.special().moveCart(cart2, util.vector().of(0, 0, -.5), 5);
        scene.special().rotateCart(cart2, -45, 2);
        scene.idle(10);

        scene.overlay().showText(70).attachKeyFrame().pointAt(util.vector().blockSurface(util.grid().at(1, 1, 3), class_2350.field_11039)).placeNearTarget()
            .text("The carts will behave like those connected via Minecart Coupling");
        scene.idle(80);

    }

    public static void rails(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("cart_assembler_rails", "Other types of Minecarts and Rails");
        scene.configureBasePlate(0, 0, 6);
        scene.scaleSceneView(.9f);
        scene.world().showSection(util.select().layer(0), class_2350.field_11036);
        scene.idle(5);

        for (int x = 0; x < 6; x++) {
            scene.world().showSection(util.select().position(x, 1, 3), class_2350.field_11033);
            scene.idle(2);
        }

        class_2338 assembler = util.grid().at(3, 1, 3);

        Selection chassis = util.select().fromTo(4, 2, 3, 2, 2, 3);

        scene.idle(5);
        scene.overlay().showText(70).attachKeyFrame().pointAt(util.vector().blockSurface(assembler, class_2350.field_11033)).placeNearTarget()
            .text("Cart Assemblers on Regular Tracks will not affect the passing carts' motion");
        scene.idle(10);
        scene.world().setBlock(
            assembler,
            AllBlocks.CART_ASSEMBLER.method_9564().method_11657(CartAssemblerBlock.RAIL_SHAPE, class_2768.field_12674)
                .method_11657(CartAssemblerBlock.RAIL_TYPE, CartAssembleRailType.REGULAR),
            true
        );
        scene.idle(70);

        ElementLink<MinecartElement> cart = scene.special().createCart(util.vector().topOf(assembler.method_10089(2).method_10074()), 0, class_1299.field_6096::method_5883);
        ElementLink<WorldSectionElement> anchor = scene.world().showIndependentSection(util.select().position(assembler.method_10072()), class_2350.field_11033);
        ElementLink<WorldSectionElement> contraption = scene.world()
            .showIndependentSection(util.select().position(assembler.method_10072().method_10084()), class_2350.field_11033);
        scene.world().moveSection(contraption, util.vector().of(2, 0, -1), 0);
        scene.world().moveSection(anchor, util.vector().of(2, 0, -1), 0);
        scene.idle(10);
        scene.world().moveSection(contraption, util.vector().of(-2, 0, 0), 10);
        scene.world().moveSection(anchor, util.vector().of(-2, 0, 0), 10);
        scene.special().moveCart(cart, util.vector().of(-5, 0, 0), 25);
        scene.idle(30);
        scene.special().hideElement(cart, class_2350.field_11036);
        scene.world().hideIndependentSection(contraption, class_2350.field_11036);
        scene.world().moveSection(anchor, util.vector().of(0, -3, 0), 0);
        scene.idle(30);

        scene.overlay().showControls(util.vector().topOf(assembler), Pointing.DOWN, 50).withItem(new class_1799(class_1802.field_8848));
        scene.idle(7);
        scene.world().setBlock(
            assembler,
            AllBlocks.CART_ASSEMBLER.method_9564().method_11657(CartAssemblerBlock.RAIL_SHAPE, class_2768.field_12674)
                .method_11657(CartAssemblerBlock.RAIL_TYPE, CartAssembleRailType.POWERED_RAIL),
            true
        );
        scene.overlay().showText(100).attachKeyFrame().pointAt(util.vector().topOf(assembler)).placeNearTarget()
            .text("When on Powered or Controller Rail, the carts will be held in place until it's Powered");
        scene.idle(110);

        scene.world().hideIndependentSection(anchor, class_2350.field_11033);
        cart = scene.special().createCart(util.vector().topOf(assembler.method_10089(2).method_10074()), 0, class_1299.field_6096::method_5883);
        anchor = scene.world().showIndependentSection(util.select().position(assembler.method_10072()), class_2350.field_11033);
        contraption = scene.world().showIndependentSection(util.select().position(assembler.method_10072().method_10084()), class_2350.field_11033);
        scene.world().moveSection(contraption, util.vector().of(2, 0, -1), 0);
        scene.world().moveSection(anchor, util.vector().of(2, 0, -1), 0);
        scene.idle(10);
        scene.world().moveSection(contraption, util.vector().of(-2, 0, 0), 10);
        scene.world().moveSection(anchor, util.vector().of(-2, 0, 0), 10);
        scene.special().moveCart(cart, util.vector().of(-2, 0, 0), 10);
        scene.world().showSection(util.select().fromTo(3, 1, 1, 3, 1, 2), class_2350.field_11035);
        scene.idle(30);

        scene.world().toggleRedstonePower(util.select().fromTo(3, 1, 1, 3, 1, 3));
        scene.effects().indicateRedstone(util.grid().at(3, 1, 1));
        scene.idle(5);

        scene.world().moveSection(contraption, util.vector().of(-3, 0, 0), 15);
        scene.world().moveSection(anchor, util.vector().of(-3, 0, 0), 15);
        scene.special().moveCart(cart, util.vector().of(-3, 0, 0), 15);

        scene.idle(30);
        scene.special().hideElement(cart, class_2350.field_11036);
        scene.world().hideIndependentSection(anchor, class_2350.field_11036);
        scene.world().hideIndependentSection(contraption, class_2350.field_11036);
        scene.idle(20);

        cart = scene.special().createCart(util.vector().topOf(assembler.method_10089(2).method_10074()), 0, class_1299.field_6080::method_5883);
        scene.idle(10);
        scene.overlay().showText(50).attachKeyFrame().pointAt(util.vector().topOf(assembler.method_10089(2))).placeNearTarget()
            .text("Other types of Minecarts can be used as the anchor");
        scene.idle(50);
        contraption = scene.world().showIndependentSection(chassis, class_2350.field_11033);
        scene.idle(5);
        scene.world().glueBlockOnto(assembler.method_10086(2), class_2350.field_11033, contraption);
        scene.idle(15);

        scene.overlay().showControls(util.vector().topOf(assembler.method_10084()), Pointing.UP, 40).withItem(new class_1799(class_1802.field_8665));
        scene.idle(7);
        scene.overlay().showText(80).pointAt(util.vector().blockSurface(assembler.method_10086(2), class_2350.field_11039)).placeNearTarget()
            .text("Furnace Carts will keep themselves powered, pulling fuel from any attached inventories");
        scene.idle(85);

        ParticleEmitter smoke = scene.effects().simpleParticleEmitter(class_2398.field_11237, util.vector().of(0, 0, 0));

        scene.special().moveCart(cart, util.vector().of(-5, 0, 0), 50);
        scene.idle(20);
        anchor = scene.world().showIndependentSectionImmediately(util.select().position(assembler.method_10072()));
        scene.world().moveSection(anchor, util.vector().of(0, 0, -1), 0);
        scene.idle(1);
        scene.world().setKineticSpeed(util.select().position(2, 2, 3), 32);
        scene.world().moveSection(contraption, util.vector().of(-3, 0, 0), 30);
        scene.world().moveSection(anchor, util.vector().of(-3, 0, 0), 30);

        class_243 vec = util.vector().centerOf(assembler).method_1031(.25, .25, -0.5);
        for (int i = 0; i < 7; i++) {
            scene.effects().emitParticles(vec = vec.method_1031(-.5, 0, 0), smoke, 2, 1);
            scene.idle(5);
        }

        scene.world().setKineticSpeed(util.select().position(2, 2, 3), 0);
    }

}