/*
 * Copyright (c) NeoForged and contributors
 * SPDX-License-Identifier: LGPL-2.1-only
 */

package com.zurrtum.create.client.model;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.jetbrains.annotations.Nullable;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_10352;
import net.minecraft.class_1100;
import net.minecraft.class_11515;
import net.minecraft.class_169;
import net.minecraft.class_176;
import net.minecraft.class_1921;
import net.minecraft.class_3518;
import net.minecraft.class_4590;
import net.minecraft.class_793;

/**
 * Properties that NeoForge adds for {@link class_793}s and {@link class_1100}s.
 */
public final class NeoForgeModelProperties {
    private NeoForgeModelProperties() {
    }

    /**
     * Root transform. For block models, this can be specified under the {@code transform} JSON key.
     */
    public static final class_169<class_4590> TRANSFORM = class_169.method_64964("transform");

    /**
     * Render type to use. For block models, this can be specified under the {@code render_type} JSON key.
     */
    public static final class_169<class_1921> RENDER_TYPE = class_169.method_64964("render_type");

    /**
     * Part visibilities. For models with named parts (i.e. OBJ and composite), this can be specified under the {@code visibility} JSON key
     */
    public static final class_169<Map<String, Boolean>> PART_VISIBILITY = class_169.method_64964("part_visibility");

    public static final class_176 EMPTY_TYPE = new class_176.class_177().method_782();
    public static final class_176 TYPE = new class_176.class_177().method_780(TRANSFORM).method_780(RENDER_TYPE).method_780(PART_VISIBILITY).method_782();

    /**
     * {@return a {@link class_4590} if the {@code transform} key is present, otherwise {@code null}}
     */
    @Nullable
    public static class_4590 deserializeRootTransform(JsonObject jsonObject, JsonDeserializationContext context) {
        if (jsonObject.has("transform")) {
            JsonElement transform = jsonObject.get("transform");
            return context.deserialize(transform, class_4590.class);
        }
        return null;
    }

    @Nullable
    public static class_11515 deserializeRenderType(JsonObject jsonObject) {
        if (jsonObject.has("render_type")) {
            return NamedBlockRenderLayer.get(class_3518.method_15265(jsonObject, "render_type"));
        }
        return null;
    }

    /**
     * {@return a map of part visibilities if the {@code visibility} key is present, otherwise an empty map}
     */
    public static Map<String, Boolean> deserializePartVisibility(JsonObject jsonObject) {
        Map<String, Boolean> partVisibility = new HashMap<>();
        if (jsonObject.has("visibility")) {
            JsonObject visibility = class_3518.method_15296(jsonObject, "visibility");
            for (Map.Entry<String, JsonElement> part : visibility.entrySet()) {
                partVisibility.put(part.getKey(), part.getValue().getAsBoolean());
            }
        }
        return Map.copyOf(partVisibility);
    }

    /**
     * Puts the given {@linkplain class_4590 root transform} into the given builder if present, overwriting any value specified in a parent model
     */
    public static void fillRootTransformProperty(class_10352.class_10353 propertiesBuilder, @Nullable class_4590 rootTransform) {
        if (rootTransform != null) {
            propertiesBuilder.method_64970(NeoForgeModelProperties.TRANSFORM, rootTransform);
        }
    }

    /**
     * Puts the given part visibility into the given builder if present, merging the with values from parent models
     * on a per-key basis and overwriting existing keys
     */
    public static void fillPartVisibilityProperty(class_10352.class_10353 propertiesBuilder, Map<String, Boolean> partVisibility) {
        if (!partVisibility.isEmpty()) {
            Map<String, Boolean> visibility = propertiesBuilder.method_64972(NeoForgeModelProperties.PART_VISIBILITY);
            if (visibility != null) {
                visibility = new HashMap<>(visibility);
                visibility.putAll(partVisibility);
            } else {
                visibility = partVisibility;
            }
            visibility = Map.copyOf(visibility);
            propertiesBuilder.method_64970(NeoForgeModelProperties.PART_VISIBILITY, visibility);
        }
    }
}
