package com.zurrtum.create.client.ponder.foundation.instruction;

import com.zurrtum.create.client.ponder.foundation.PonderScene;
import com.zurrtum.create.client.ponder.foundation.element.AnimatedOverlayElementBase;
import com.zurrtum.create.client.ponder.foundation.element.AnimatedSceneElementBase;
import net.minecraft.class_2350;
import net.minecraft.class_243;

public class HideAllInstruction extends TickingInstruction {

    private final class_2350 fadeOutTo;

    public HideAllInstruction(int fadeOutTicks, class_2350 fadeOutTo) {
        super(false, fadeOutTicks);
        this.fadeOutTo = fadeOutTo;
    }

    @Override
    protected void firstTick(PonderScene scene) {
        super.firstTick(scene);
        scene.getElements().forEach(element -> {
            if (element instanceof AnimatedSceneElementBase animatedSceneElement) {
                animatedSceneElement.setFade(1);
                animatedSceneElement.setFadeVec(fadeOutTo == null ? null : class_243.method_24954(fadeOutTo.method_62675()).method_1021(.5f));
            } else if (element instanceof AnimatedOverlayElementBase animatedSceneElement) {
                animatedSceneElement.setFade(1);
            } else
                element.setVisible(false);
        });
    }

    @Override
    public void tick(PonderScene scene) {
        super.tick(scene);
        float fade = (remainingTicks / (float) totalTicks);

        scene.forEach(
            AnimatedSceneElementBase.class, ase -> {
                ase.setFade(fade * fade);
                if (remainingTicks == 0)
                    ase.setFade(0);
            }
        );

        scene.forEach(
            AnimatedOverlayElementBase.class, aoe -> {
                aoe.setFade(fade * fade);
                if (remainingTicks == 0)
                    aoe.setFade(0);
            }
        );
    }

}
