package com.zurrtum.create.client.ponder.foundation.instruction;

import com.zurrtum.create.client.ponder.api.PonderPalette;
import com.zurrtum.create.client.ponder.foundation.PonderScene;
import net.minecraft.class_243;

public class LineInstruction extends TickingInstruction {

    private PonderPalette color;
    private class_243 start;
    private class_243 end;
    private boolean big;

    public LineInstruction(PonderPalette color, class_243 start, class_243 end, int ticks, boolean big) {
        super(false, ticks);
        this.color = color;
        this.start = start;
        this.end = end;
        this.big = big;
    }

    @Override
    public void tick(PonderScene scene) {
        super.tick(scene);
        scene.getOutliner().showLine(start, start, end).lineWidth(big ? 1 / 8f : 1 / 16f).colored(color.getColor());
    }

}