package com.zurrtum.create.client.vanillin.visuals;

import com.zurrtum.create.client.flywheel.api.instance.Instance;
import com.zurrtum.create.client.flywheel.api.material.Material;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.material.CutoutShaders;
import com.zurrtum.create.client.flywheel.lib.material.SimpleMaterial;
import com.zurrtum.create.client.flywheel.lib.model.part.InstanceTree;
import com.zurrtum.create.client.flywheel.lib.model.part.ModelTrees;
import com.zurrtum.create.client.flywheel.lib.visual.AbstractBlockEntityVisual;
import com.zurrtum.create.client.flywheel.lib.visual.SimpleDynamicVisual;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import it.unimi.dsi.fastutil.longs.LongSet;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

import java.util.Calendar;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2618;
import net.minecraft.class_2745;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4076;
import net.minecraft.class_4722;
import net.minecraft.class_4730;
import net.minecraft.class_4732;
import net.minecraft.class_4739;
import net.minecraft.class_5601;
import net.minecraft.class_5602;
import net.minecraft.class_761;
import net.minecraft.class_765;
import net.minecraft.class_826;

public class ChestVisual<T extends class_2586 & class_2618> extends AbstractBlockEntityVisual<T> implements SimpleDynamicVisual {
    private static final Material MATERIAL = SimpleMaterial.builder().cutout(CutoutShaders.ONE_TENTH)
        .texture(class_4722.field_21709).mipmap(false).build();

    private static final Map<class_2745, class_5601> LAYER_LOCATIONS = new EnumMap<>(class_2745.class);

    static {
        LAYER_LOCATIONS.put(class_2745.field_12569, class_5602.field_27689);
        LAYER_LOCATIONS.put(class_2745.field_12574, class_5602.field_27551);
        LAYER_LOCATIONS.put(class_2745.field_12571, class_5602.field_27552);
    }

    @Nullable
    private final InstanceTree instances;
    @Nullable
    private final InstanceTree lid;
    @Nullable
    private final InstanceTree lock;

    @Nullable
    private final Matrix4fc initialPose;
    private final BrightnessCombiner brightnessCombiner = new BrightnessCombiner();
    @Nullable
    private final class_4732.class_4734<? extends class_2595> neighborCombineResult;
    @Nullable
    private final Float2FloatFunction lidProgress;

    private float lastProgress = Float.NaN;

    @SuppressWarnings("rawtypes")
    public ChestVisual(VisualizationContext ctx, T blockEntity, float partialTick) {
        super(ctx, blockEntity, partialTick);

        class_2248 block = blockState.method_26204();
        if (block instanceof class_4739<?> chestBlock) {
            class_2745 chestType = blockState.method_28498(class_2281.field_10770) ? blockState.method_11654(class_2281.field_10770) : class_2745.field_12569;
            class_826<?> renderer = (class_826) class_310.method_1551().method_31975()
                .method_3550(blockEntity);
            class_4730 texture = class_4722.method_24062(renderer.method_74366(blockEntity, isChristmas()), chestType);
            instances = InstanceTree.create(instancerProvider(), ModelTrees.of(LAYER_LOCATIONS.get(chestType), texture, MATERIAL));
            lid = instances.childOrThrow("lid");
            lock = instances.childOrThrow("lock");

            initialPose = createInitialPose();
            neighborCombineResult = chestBlock.method_24167(blockState, level, pos, true);
            lidProgress = neighborCombineResult.apply(class_2281.method_24166(blockEntity));

            lastProgress = lidProgress.get(partialTick);
            applyLidTransform(lastProgress);
        } else {
            instances = null;
            lid = null;
            lock = null;
            initialPose = null;
            neighborCombineResult = null;
            lidProgress = null;
        }
    }

    private static boolean isChristmas() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(Calendar.MONTH) + 1 == 12 && calendar.get(Calendar.DATE) >= 24 && calendar.get(Calendar.DATE) <= 26;
    }

    private Matrix4f createInitialPose() {
        class_2338 visualPos = getVisualPosition();
        float horizontalAngle = blockState.method_11654(class_2281.field_10768).method_10144();
        return new Matrix4f().translate(visualPos.method_10263(), visualPos.method_10264(), visualPos.method_10260()).translate(0.5F, 0.5F, 0.5F)
            .rotateY(-horizontalAngle * class_3532.field_29847).translate(-0.5F, -0.5F, -0.5F);
    }

    @Override
    public void setSectionCollector(SectionCollector sectionCollector) {
        this.lightSections = sectionCollector;

        if (neighborCombineResult != null) {
            lightSections.sections(neighborCombineResult.apply(new SectionPosCombiner()));
        } else {
            lightSections.sections(LongSet.of(class_4076.method_33706(pos)));
        }
    }

    @Override
    public void beginFrame(Context context) {
        if (instances == null) {
            return;
        }

        if (doDistanceLimitThisFrame(context) || !isVisible(context.frustum())) {
            return;
        }

        float progress = lidProgress.get(context.partialTick());
        if (lastProgress == progress) {
            return;
        }
        lastProgress = progress;

        applyLidTransform(progress);
    }

    private void applyLidTransform(float progress) {
        progress = 1.0F - progress;
        progress = 1.0F - progress * progress * progress;

        lid.xRot(-(progress * ((float) Math.PI / 2F)));
        lock.xRot(lid.xRot());
        instances.updateInstancesStatic(initialPose);
    }

    @Override
    public void updateLight(float partialTick) {
        if (instances != null) {
            int packedLight = neighborCombineResult.apply(brightnessCombiner);
            instances.traverse(instance -> {
                instance.light(packedLight).setChanged();
            });
        }
    }

    @Override
    public void collectCrumblingInstances(Consumer<Instance> consumer) {
        if (instances != null) {
            instances.traverse(consumer);
        }
    }

    @Override
    protected void _delete() {
        if (instances != null) {
            instances.delete();
        }
    }

    private class SectionPosCombiner implements class_4732.class_3923<class_2586, LongSet> {
        @Override
        public LongSet getFromBoth(class_2586 first, class_2586 second) {
            long firstSection = class_4076.method_33706(first.method_11016());
            long secondSection = class_4076.method_33706(second.method_11016());

            if (firstSection == secondSection) {
                return LongSet.of(firstSection);
            } else {
                return LongSet.of(firstSection, secondSection);
            }
        }

        @Override
        public LongSet getFrom(class_2586 single) {
            return LongSet.of(class_4076.method_33706(single.method_11016()));
        }

        @Override
        public LongSet method_24174() {
            return LongSet.of(class_4076.method_33706(pos));
        }
    }

    private class BrightnessCombiner implements class_4732.class_3923<class_2586, Integer> {
        @Override
        public Integer getFromBoth(class_2586 first, class_2586 second) {
            int firstLight = class_761.method_23794(first.method_10997(), first.method_11016());
            int secondLight = class_761.method_23794(second.method_10997(), second.method_11016());
            int firstBlockLight = class_765.method_24186(firstLight);
            int secondBlockLight = class_765.method_24186(secondLight);
            int firstSkyLight = class_765.method_24187(firstLight);
            int secondSkyLight = class_765.method_24187(secondLight);
            return class_765.method_23687(Math.max(firstBlockLight, secondBlockLight), Math.max(firstSkyLight, secondSkyLight));
        }

        @Override
        public Integer getFrom(class_2586 single) {
            return class_761.method_23794(single.method_10997(), single.method_11016());
        }

        @Override
        public Integer method_24174() {
            return class_761.method_23794(level, pos);
        }
    }
}
