package com.zurrtum.create.client.vanillin.visuals;

import com.zurrtum.create.client.flywheel.api.material.Material;
import com.zurrtum.create.client.flywheel.api.visual.DynamicVisual;
import com.zurrtum.create.client.flywheel.api.visual.TickableVisual;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.instance.FlatLit;
import com.zurrtum.create.client.flywheel.lib.instance.InstanceTypes;
import com.zurrtum.create.client.flywheel.lib.instance.TransformedInstance;
import com.zurrtum.create.client.flywheel.lib.material.SimpleMaterial;
import com.zurrtum.create.client.flywheel.lib.model.Models;
import com.zurrtum.create.client.flywheel.lib.model.part.InstanceTree;
import com.zurrtum.create.client.flywheel.lib.model.part.ModelTrees;
import com.zurrtum.create.client.flywheel.lib.visual.AbstractEntityVisual;
import com.zurrtum.create.client.flywheel.lib.visual.SimpleDynamicVisual;
import com.zurrtum.create.client.flywheel.lib.visual.SimpleTickableVisual;
import net.minecraft.class_1688;
import net.minecraft.class_2248;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_5601;
import net.minecraft.class_9879;
import net.minecraft.class_9883;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;

public class MinecartVisual<T extends class_1688> extends AbstractEntityVisual<T> implements SimpleTickableVisual, SimpleDynamicVisual {
    private static final class_2960 TEXTURE = class_2960.method_60656("textures/entity/minecart.png");
    private static final Material MATERIAL = SimpleMaterial.builder().texture(TEXTURE).mipmap(false).build();

    private final InstanceTree instances;
    @Nullable
    private TransformedInstance contents;

    private final Matrix4fStack stack = new Matrix4fStack(2);

    private class_2680 blockState;

    public MinecartVisual(VisualizationContext ctx, T entity, float partialTick, class_5601 layerLocation) {
        super(ctx, entity, partialTick);

        instances = InstanceTree.create(instancerProvider(), ModelTrees.of(layerLocation, MATERIAL));
        blockState = entity.method_7519();
        contents = createContentsInstance();

        updateInstances(partialTick);
        updateLight(partialTick);
    }

    @Nullable
    private TransformedInstance createContentsInstance() {
        class_2464 shape = blockState.method_26217();

        if (shape == class_2464.field_11455) {
            return null;
        }

        class_2248 block = blockState.method_26204();
        if (class_310.method_1551().method_1554().method_65756().get().field_55270.containsKey(block)) {
            instances.visible(false);
            return null;
        }

        return instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.block(blockState)).createInstance();
    }

    @Override
    public void tick(TickableVisual.Context context) {
        class_2680 displayBlockState = entity.method_7519();

        if (displayBlockState != blockState) {
            blockState = displayBlockState;
            if (contents != null) {
                contents.delete();
            }
            contents = createContentsInstance();
        }
    }

    @Override
    public void beginFrame(DynamicVisual.Context context) {
        if (!isVisible(context.frustum())) {
            return;
        }

        if (!instances.visible()) {
            return;
        }

        updateInstances(context.partialTick());
    }

    private void updateInstances(float partialTick) {
        stack.identity();

        double posX = class_3532.method_16436(partialTick, entity.field_6038, entity.method_23317());
        double posY = class_3532.method_16436(partialTick, entity.field_5971, entity.method_23318());
        double posZ = class_3532.method_16436(partialTick, entity.field_5989, entity.method_23321());

        var renderOrigin = renderOrigin();
        stack.translate((float) (posX - renderOrigin.method_10263()), (float) (posY - renderOrigin.method_10264()), (float) (posZ - renderOrigin.method_10260()));
        float yaw = class_3532.method_16439(partialTick, entity.field_5982, entity.method_36454());

        long randomBits = entity.method_5628() * 493286711L;
        randomBits = randomBits * randomBits * 4392167121L + randomBits * 98761L;
        float nudgeX = (((float) (randomBits >> 16 & 7L) + 0.5f) / 8.0f - 0.5F) * 0.004f;
        float nudgeY = (((float) (randomBits >> 20 & 7L) + 0.5f) / 8.0f - 0.5F) * 0.004f;
        float nudgeZ = (((float) (randomBits >> 24 & 7L) + 0.5f) / 8.0f - 0.5F) * 0.004f;
        stack.translate(nudgeX, nudgeY, nudgeZ);

        float pitch = class_3532.method_16439(partialTick, entity.field_6004, entity.method_36455());
        if (entity.method_61569() instanceof class_9883 controller) {
            class_243 pos = controller.method_61620(posX, posY, posZ);
            if (pos != null) {
                class_243 offset1 = controller.method_61619(posX, posY, posZ, 0.3F);
                class_243 offset2 = controller.method_61619(posX, posY, posZ, -0.3F);

                if (offset1 == null) {
                    offset1 = pos;
                }

                if (offset2 == null) {
                    offset2 = pos;
                }

                stack.translate((float) (pos.field_1352 - posX), (float) ((offset1.field_1351 + offset2.field_1351) / 2.0D - posY), (float) (pos.field_1350 - posZ));
                class_243 vec = offset2.method_1031(-offset1.field_1352, -offset1.field_1351, -offset1.field_1350);
                if (vec.method_1033() != 0.0D) {
                    vec = vec.method_1029();
                    yaw = (float) (Math.atan2(vec.field_1350, vec.field_1352) * 180.0D / Math.PI);
                    pitch = (float) (Math.atan(vec.field_1351) * 73.0D);
                }
            }
        }

        stack.translate(0.0F, 0.375F, 0.0F);
        stack.rotateY((180 - yaw) * class_3532.field_29847);
        stack.rotateZ(-pitch * class_3532.field_29847);

        float hurtTime = entity.method_54295() - partialTick;
        float damage = entity.method_54294() - partialTick;

        if (damage < 0) {
            damage = 0;
        }

        if (hurtTime > 0) {
            stack.rotateX((class_3532.method_15374(hurtTime) * hurtTime * damage / 10.0F * (float) entity.method_54296()) * class_3532.field_29847);
        }

        if (contents != null) {
            int displayOffset = entity.method_7514();
            stack.pushMatrix();
            stack.scale(0.75F, 0.75F, 0.75F);
            stack.translate(-0.5F, (float) (displayOffset - 8) / 16, 0.5F);
            stack.rotateY(90 * class_3532.field_29847);
            updateContents(contents, stack, partialTick);
            stack.popMatrix();
        }

        stack.scale(-1.0F, -1.0F, 1.0F);
        instances.updateInstances(stack);

        // TODO: Use LightUpdatedVisual/ShaderLightVisual if possible.
        updateLight(partialTick);
    }

    protected void updateContents(TransformedInstance contents, Matrix4f pose, float partialTick) {
        contents.setTransform(pose).setChanged();
    }

    public void updateLight(float partialTick) {
        int packedLight = computePackedLight(partialTick);
        instances.traverse(instance -> {
            instance.light(packedLight).setChanged();
        });
        FlatLit.relight(packedLight, contents);
    }

    @Override
    protected void _delete() {
        instances.delete();
        if (contents != null) {
            contents.delete();
        }
    }

    public static boolean shouldSkipRender(class_1688 minecart) {
        if (minecart.method_61569() instanceof class_9879) {
            return true;
        }
        class_2248 block = minecart.method_7519().method_26204();
        return !class_310.method_1551().method_1554().method_65756().get().field_55270.containsKey(block);
    }
}
