package com.zurrtum.create.compat.rei.display;

import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.compat.rei.ReiCommonPlugin;
import com.zurrtum.create.content.kinetics.crusher.CrushingRecipe;
import com.zurrtum.create.content.kinetics.millstone.MillingRecipe;
import com.zurrtum.create.content.processing.recipe.ChanceOutput;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializer;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.class_1860;
import net.minecraft.class_2960;
import net.minecraft.class_8786;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public record CrushingDisplay(EntryIngredient input, List<ChanceOutput> outputs, Optional<class_2960> location) implements Display {
    public static final DisplaySerializer<CrushingDisplay> SERIALIZER = DisplaySerializer.of(
        RecordCodecBuilder.mapCodec(instance -> instance.group(
            EntryIngredient.codec().fieldOf("input").forGetter(CrushingDisplay::input),
            ChanceOutput.CODEC.listOf().fieldOf("outputs").forGetter(CrushingDisplay::outputs),
            class_2960.field_25139.optionalFieldOf("location").forGetter(CrushingDisplay::location)
        ).apply(instance, CrushingDisplay::new)), class_9139.method_56436(
            EntryIngredient.streamCodec(),
            CrushingDisplay::input,
            ChanceOutput.PACKET_CODEC.method_56433(class_9135.method_56363()),
            CrushingDisplay::outputs,
            class_9135.method_56382(class_2960.field_48267),
            CrushingDisplay::location,
            CrushingDisplay::new
        )
    );

    public static CrushingDisplay of(class_8786<?> entry) {
        class_2960 id = entry.comp_1932().method_29177();
        class_1860<?> recipe = entry.comp_1933();
        if (recipe instanceof CrushingRecipe crushingRecipe) {
            return new CrushingDisplay(id, crushingRecipe);
        } else if (recipe instanceof MillingRecipe millingRecipe) {
            return new CrushingDisplay(id, millingRecipe);
        }
        return null;
    }

    public CrushingDisplay(class_2960 id, CrushingRecipe recipe) {
        this(EntryIngredients.ofIngredient(recipe.ingredient()), recipe.results(), Optional.of(id));
    }

    public CrushingDisplay(class_2960 id, MillingRecipe recipe) {
        this(EntryIngredients.ofIngredient(recipe.ingredient()), recipe.results(), Optional.of(id));
    }

    @Override
    public List<EntryIngredient> getInputEntries() {
        return List.of(input);
    }

    @Override
    public List<EntryIngredient> getOutputEntries() {
        List<EntryIngredient> list = new ArrayList<>();
        for (ChanceOutput output : outputs) {
            list.add(EntryIngredients.of(output.stack()));
        }
        return list;
    }

    @Override
    public CategoryIdentifier<?> getCategoryIdentifier() {
        return ReiCommonPlugin.CRUSHING;
    }

    @Override
    public Optional<class_2960> getDisplayLocation() {
        return location;
    }

    @Override
    public DisplaySerializer<? extends Display> getSerializer() {
        return SERIALIZER;
    }
}
