package com.zurrtum.create.content.contraptions;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import java.util.Optional;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_5244;
import net.minecraft.class_8824;

public class AssemblyException extends Exception {
    public static final Codec<AssemblyException> CODEC = RecordCodecBuilder.create(instance -> instance.group(
        class_8824.field_46597.fieldOf("Component").forGetter(i -> i.component),
        class_2338.field_25064.optionalFieldOf("Position").forGetter(i -> Optional.ofNullable(i.getPosition()))
    ).apply(instance, AssemblyException::new));

    private static final long serialVersionUID = 1L;
    public final class_2561 component;
    private class_2338 position = null;

    public static void write(class_11372 view, AssemblyException exception) {
        if (exception == null)
            return;

        class_11372 lastException = view.method_71461("LastException");
        lastException.method_71468("Component", class_8824.field_46597, exception.component);
        if (exception.hasPosition())
            lastException.method_71468("Position", class_2338.field_25064, exception.getPosition());
    }

    public static AssemblyException read(class_11368 view) {
        return view.method_71420("LastException").map(lastException -> {
            class_2561 component = lastException.method_71426("Component", class_8824.field_46597).orElse(class_5244.field_39003);
            AssemblyException exception = new AssemblyException(component);
            lastException.method_71426("Position", class_2338.field_25064).ifPresent(position -> {
                exception.position = position;
            });
            return exception;
        }).orElse(null);
    }

    public AssemblyException(class_2561 component) {
        this.component = component;
    }

    public AssemblyException(String langKey, Object... objects) {
        this(class_2561.method_43469("create.gui.assembly.exception." + langKey, objects));
    }

    @SuppressWarnings("OptionalUsedAsFieldOrParameterType")
    private AssemblyException(class_2561 component, Optional<class_2338> position) {
        this.component = component;
        this.position = position.orElse(null);
    }

    public static AssemblyException unmovableBlock(class_2338 pos, class_2680 state) {
        AssemblyException e = new AssemblyException("unmovableBlock", pos.method_10263(), pos.method_10264(), pos.method_10260(), state.method_26204().method_9518());
        e.position = pos;
        return e;
    }

    public static AssemblyException unloadedChunk(class_2338 pos) {
        AssemblyException e = new AssemblyException("chunkNotLoaded", pos.method_10263(), pos.method_10264(), pos.method_10260());
        e.position = pos;
        return e;
    }

    public static AssemblyException structureTooLarge() {
        return new AssemblyException("structureTooLarge", AllConfigs.server().kinetics.maxBlocksMoved.get());
    }

    public static AssemblyException tooManyPistonPoles() {
        return new AssemblyException("tooManyPistonPoles", AllConfigs.server().kinetics.maxPistonPoles.get());
    }

    public static AssemblyException noPistonPoles() {
        return new AssemblyException("noPistonPoles");
    }

    public static AssemblyException notEnoughSails(int sails) {
        return new AssemblyException("not_enough_sails", sails, AllConfigs.server().kinetics.minimumWindmillSails.get());
    }

    public boolean hasPosition() {
        return position != null;
    }

    public class_2338 getPosition() {
        return position;
    }
}
