package com.zurrtum.create.content.contraptions.actors.psi;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import java.util.List;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3532;

public abstract class PortableStorageInterfaceBlockEntity extends SmartBlockEntity {

    public static final int ANIMATION = 4;
    protected int transferTimer;
    protected float distance;
    protected LerpedFloat connectionAnimation;
    protected boolean powered;
    protected class_1297 connectedEntity;

    public int keepAlive = 0;

    public PortableStorageInterfaceBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        transferTimer = 0;
        connectionAnimation = LerpedFloat.linear().startWithValue(0);
        powered = false;
    }

    public void startTransferringTo(Contraption contraption, float distance) {
        if (connectedEntity == contraption.entity)
            return;
        this.distance = Math.min(2, distance);
        connectedEntity = contraption.entity;
        startConnecting();
        notifyUpdate();
    }

    protected void stopTransferring() {
        connectedEntity = null;
        field_11863.method_8452(field_11867, method_11010().method_26204(), null);
    }

    public boolean canTransfer() {
        if (connectedEntity != null && !connectedEntity.method_5805())
            stopTransferring();
        return connectedEntity != null && isConnected();
    }

    @Override
    public void initialize() {
        super.initialize();
        powered = field_11863.method_49803(field_11867);
        if (!powered)
            notifyContraptions();
    }

    @Override
    public void tick() {
        super.tick();
        boolean wasConnected = isConnected();
        int timeUnit = getTransferTimeout();
        int animation = ANIMATION;

        if (keepAlive > 0) {
            keepAlive--;
            if (keepAlive == 0 && !field_11863.method_8608()) {
                stopTransferring();
                transferTimer = ANIMATION - 1;
                sendData();
                return;
            }
        }

        transferTimer = Math.min(transferTimer, ANIMATION * 2 + timeUnit);

        boolean timerCanDecrement = transferTimer > ANIMATION || transferTimer > 0 && keepAlive == 0 && (isVirtual() || !field_11863.method_8608() || transferTimer != ANIMATION);

        if (timerCanDecrement && (!isVirtual() || transferTimer != ANIMATION)) {
            transferTimer--;
            if (transferTimer == ANIMATION - 1)
                sendData();
            if (transferTimer <= 0 || powered)
                stopTransferring();
        }

        boolean isConnected = isConnected();
        if (wasConnected != isConnected && !field_11863.method_8608())
            method_5431();

        float progress = 0;
        if (isConnected)
            progress = 1;
        else if (transferTimer >= timeUnit + animation)
            progress = class_3532.method_48781((transferTimer - timeUnit - animation) / (float) animation, 1, 0);
        else if (transferTimer < animation)
            progress = class_3532.method_48781(transferTimer / (float) animation, 0, 1);
        connectionAnimation.setValue(progress);
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);
        transferTimer = view.method_71424("Timer", 0);
        distance = view.method_71423("Distance", 0);
        boolean poweredPreviously = powered;
        powered = view.method_71433("Powered", false);
        if (clientPacket && powered != poweredPreviously && !powered)
            notifyContraptions();
    }

    @Override
    protected void write(class_11372 view, boolean clientPacket) {
        super.write(view, clientPacket);
        view.method_71465("Timer", transferTimer);
        view.method_71464("Distance", distance);
        view.method_71472("Powered", powered);
    }

    public void neighbourChanged() {
        boolean isBlockPowered = field_11863.method_49803(field_11867);
        if (isBlockPowered == powered)
            return;
        powered = isBlockPowered;
        if (!powered)
            notifyContraptions();
        if (powered)
            stopTransferring();
        sendData();
    }

    private void notifyContraptions() {
        field_11863.method_18467(AbstractContraptionEntity.class, new class_238(field_11867).method_1014(3)).forEach(AbstractContraptionEntity::refreshPSIs);
    }

    public boolean isPowered() {
        return powered;
    }

    @Override
    protected class_238 createRenderBoundingBox() {
        return super.createRenderBoundingBox().method_1014(2);
    }

    public boolean isTransferring() {
        return transferTimer > ANIMATION;
    }

    public boolean isConnected() {
        int timeUnit = getTransferTimeout();
        return transferTimer >= ANIMATION && transferTimer <= timeUnit + ANIMATION;
    }

    public float getExtensionDistance(float partialTicks) {
        return (float) (Math.pow(connectionAnimation.getValue(partialTicks), 2) * distance / 2);
    }

    float getConnectionDistance() {
        return distance;
    }

    public void startConnecting() {
        transferTimer = 6 + ANIMATION * 2;
    }

    public void onContentTransferred() {
        int timeUnit = getTransferTimeout();
        transferTimer = timeUnit + ANIMATION;
        award(AllAdvancements.PSI);
        sendData();
    }

    protected Integer getTransferTimeout() {
        return AllConfigs.server().logistics.psiTimeout.get();
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
    }

    @Override
    public List<CreateTrigger> getAwardables() {
        return List.of(AllAdvancements.PSI);
    }

}
