package com.zurrtum.create.content.contraptions.chassis;

import com.zurrtum.create.AllBlocks;
import net.minecraft.class_10225;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2352;
import net.minecraft.class_2680;
import net.minecraft.class_2689.class_2690;
import net.minecraft.class_2746;
import net.minecraft.class_4538;
import net.minecraft.class_5819;

public class LinearChassisBlock extends AbstractChassisBlock {

    public static final class_2746 STICKY_TOP = class_2746.method_11825("sticky_top");
    public static final class_2746 STICKY_BOTTOM = class_2746.method_11825("sticky_bottom");

    public LinearChassisBlock(class_2251 properties) {
        super(properties);
        method_9590(method_9564().method_11657(STICKY_TOP, false).method_11657(STICKY_BOTTOM, false));
    }

    @Override
    protected void method_9515(class_2690<class_2248, class_2680> builder) {
        builder.method_11667(STICKY_TOP, STICKY_BOTTOM);
        super.method_9515(builder);
    }

    @Override
    public class_2680 method_9605(class_1750 context) {
        class_2338 placedOnPos = context.method_8037().method_10093(context.method_8038().method_10153());
        class_2680 blockState = context.method_8045().method_8320(placedOnPos);

        if (context.method_8036() == null || !context.method_8036().method_5715()) {
            if (isChassis(blockState))
                return method_9564().method_11657(field_11459, blockState.method_11654(field_11459));
            return method_9564().method_11657(field_11459, context.method_7715().method_10166());
        }
        return super.method_9605(context);
    }

    @Override
    public class_2680 method_9559(
        class_2680 state,
        class_4538 p_196271_4_,
        class_10225 tickView,
        class_2338 p_196271_5_,
        class_2350 side,
        class_2338 p_196271_6_,
        class_2680 other,
        class_5819 random
    ) {
        class_2746 property = getGlueableSide(state, side);
        if (property == null || !sameKind(state, other) || state.method_11654(field_11459) != other.method_11654(field_11459))
            return state;
        return state.method_11657(property, false);
    }

    @Override
    public class_2746 getGlueableSide(class_2680 state, class_2350 face) {
        if (face.method_10166() != state.method_11654(field_11459))
            return null;
        return face.method_10171() == class_2352.field_11056 ? STICKY_TOP : STICKY_BOTTOM;
    }

    @Override
    protected boolean glueAllowedOnSide(class_1922 world, class_2338 pos, class_2680 state, class_2350 side) {
        class_2680 other = world.method_8320(pos.method_10093(side));
        return !sameKind(other, state) || state.method_11654(field_11459) != other.method_11654(field_11459);
    }

    public static boolean isChassis(class_2680 state) {
        return state.method_27852(AllBlocks.LINEAR_CHASSIS) || state.method_27852(AllBlocks.SECONDARY_LINEAR_CHASSIS);
    }

    public static boolean sameKind(class_2680 state1, class_2680 state2) {
        return state1.method_26204() == state2.method_26204();
    }
}
