package com.zurrtum.create.content.contraptions.data;

import io.netty.buffer.Unpooled;
import net.minecraft.class_156;
import net.minecraft.class_2505;
import net.minecraft.class_2520;
import net.minecraft.class_2540;

public class ContraptionPickupLimiting {
    /// The default NBT limit, defined by {@link PacketByteBuf#readNbt()}.
    public static final int NBT_LIMIT = 2_097_152;

    // increased nbt limits provided by other mods.
    public static final int PACKET_FIXER_LIMIT = NBT_LIMIT * 100;
    public static final int XL_PACKETS_LIMIT = Integer.MAX_VALUE;

    // leave some space for the rest of the packet.
    public static final int BUFFER = 20_000;

    // the actual limit to be used
    public static final int LIMIT = class_156.method_656(() -> {
        // the smallest limit needs to be used, as we can't guarantee that all mixins are applied if multiple are present.
        //TODO
        //        if (Mods.PACKETFIXER.isLoaded()) {
        //            return PACKET_FIXER_LIMIT;
        //        } else if (Mods.XLPACKETS.isLoaded()) {
        //            return XL_PACKETS_LIMIT;
        //        }

        // none are present, use vanilla default
        return NBT_LIMIT;
    }) - BUFFER;

    /**
     * @return true if the given NBT is too large for a contraption to be picked up with a wrench.
     */
    public static boolean isTooLargeForPickup(class_2520 data) {
        return nbtSize(data) > LIMIT;
    }

    /**
     * @return the size of the given NBT when read by the client according to {@link class_2505}
     */
    private static long nbtSize(class_2520 data) {
        class_2540 test = new class_2540(Unpooled.buffer());
        test.method_10794(data);
        class_2505 sizeTracker = class_2505.method_53898();
        test.method_30616(sizeTracker);
        long size = sizeTracker.method_47987();
        test.release();
        return size;
    }
}
