package com.zurrtum.create.content.contraptions.pulley;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllShapes;
import com.zurrtum.create.content.kinetics.base.HorizontalAxisKineticBlock;
import com.zurrtum.create.foundation.block.IBE;
import net.minecraft.class_10;
import net.minecraft.class_10225;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689.class_2690;
import net.minecraft.class_2741;
import net.minecraft.class_3218;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_5819;

public class PulleyBlock extends HorizontalAxisKineticBlock implements IBE<PulleyBlockEntity> {

    public PulleyBlock(class_2251 properties) {
        super(properties);
    }

    private static void onRopeBroken(class_1937 world, class_2338 pulleyPos) {
        class_2586 be = world.method_8321(pulleyPos);
        if (be instanceof PulleyBlockEntity pulley) {
            pulley.initialOffset = 0;
            pulley.onLengthBroken();
        }
    }

    @Override
    public void method_66388(class_2680 state, class_3218 worldIn, class_2338 pos, boolean isMoving) {
        super.method_66388(state, worldIn, pos, isMoving);
        if (worldIn.method_8608())
            return;
        class_2680 below = worldIn.method_8320(pos.method_10074());
        if (below.method_26204() instanceof RopeBlockBase)
            worldIn.method_22352(pos.method_10074(), true);
    }

    @Override
    protected class_1269 method_55765(
        class_1799 stack,
        class_2680 state,
        class_1937 level,
        class_2338 pos,
        class_1657 player,
        class_1268 hand,
        class_3965 hitResult
    ) {
        if (!player.method_7294())
            return class_1269.field_52423;
        if (player.method_5715())
            return class_1269.field_52423;
        if (stack.method_7960()) {
            withBlockEntityDo(level, pos, be -> be.assembleNextTick = true);
            return class_1269.field_5812;
        }
        return class_1269.field_52423;
    }

    @Override
    public Class<PulleyBlockEntity> getBlockEntityClass() {
        return PulleyBlockEntity.class;
    }

    @Override
    public class_2591<? extends PulleyBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.ROPE_PULLEY;
    }

    private static class RopeBlockBase extends class_2248 implements class_3737 {

        public RopeBlockBase(class_2251 properties) {
            super(properties);
            method_9590(method_9564().method_11657(class_2741.field_12508, false));
        }

        @Override
        protected boolean method_9516(class_2680 state, class_10 pathComputationType) {
            return false;
        }

        @Override
        protected class_1799 method_9574(class_4538 world, class_2338 pos, class_2680 state, boolean includeData) {
            return AllItems.ROPE_PULLEY.method_7854();
        }

        @Override
        public void method_66388(class_2680 state, class_3218 worldIn, class_2338 pos, boolean isMoving) {
            if (isMoving) {
                return;
            }
            boolean onBroken = !state.method_28498(class_2741.field_12508);
            if (!onBroken) {
                class_2680 newState = worldIn.method_8320(pos);
                onBroken = !newState.method_28498(class_2741.field_12508) || state.method_11654(class_2741.field_12508) == newState.method_11654(class_2741.field_12508);
            }
            if (onBroken) {
                onRopeBroken(worldIn, pos.method_10084());
                if (!worldIn.method_8608()) {
                    class_2680 above = worldIn.method_8320(pos.method_10084());
                    class_2680 below = worldIn.method_8320(pos.method_10074());
                    if (above.method_26204() instanceof RopeBlockBase)
                        worldIn.method_22352(pos.method_10084(), true);
                    if (below.method_26204() instanceof RopeBlockBase)
                        worldIn.method_22352(pos.method_10074(), true);
                }
            }
        }


        @Override
        public class_3610 method_9545(class_2680 state) {
            return state.method_11654(class_2741.field_12508) ? class_3612.field_15910.method_15729(false) : class_3612.field_15906.method_15785();
        }

        @Override
        protected void method_9515(class_2690<class_2248, class_2680> builder) {
            builder.method_11667(class_2741.field_12508);
            super.method_9515(builder);
        }

        @Override
        public class_2680 method_9559(
            class_2680 state,
            class_4538 world,
            class_10225 tickView,
            class_2338 pos,
            class_2350 direction,
            class_2338 neighbourPos,
            class_2680 neighbourState,
            class_5819 random
        ) {
            if (state.method_11654(class_2741.field_12508))
                tickView.method_64312(pos, class_3612.field_15910, class_3612.field_15910.method_15789(world));
            return state;
        }

        @Override
        public class_2680 method_9605(class_1750 context) {
            class_3610 FluidState = context.method_8045().method_8316(context.method_8037());
            return super.method_9605(context).method_11657(class_2741.field_12508, Boolean.valueOf(FluidState.method_15772() == class_3612.field_15910));
        }

    }

    public static class MagnetBlock extends RopeBlockBase {

        public MagnetBlock(class_2251 properties) {
            super(properties);
        }

        @Override
        public class_265 method_9530(class_2680 state, class_1922 worldIn, class_2338 pos, class_3726 context) {
            return AllShapes.PULLEY_MAGNET;
        }

    }

    public static class RopeBlock extends RopeBlockBase {

        public RopeBlock(class_2251 properties) {
            super(properties);
        }

        @Override
        public class_265 method_9530(class_2680 state, class_1922 worldIn, class_2338 pos, class_3726 context) {
            return AllShapes.FOUR_VOXEL_POLE.get(class_2350.field_11036);
        }
    }

}
