package com.zurrtum.create.content.equipment;

import com.zurrtum.create.catnip.levelWrappers.PlacementSimulationServerLevel;
import net.minecraft.class_1269;
import net.minecraft.class_1752;
import net.minecraft.class_1792;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2256;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_3218;
import net.minecraft.class_3481;

public class TreeFertilizerItem extends class_1792 {

    public TreeFertilizerItem(class_1793 properties) {
        super(properties);
    }

    @Override
    public class_1269 method_7884(class_1838 context) {
        class_1937 world = context.method_8045();
        class_2680 state = world.method_8320(context.method_8037());
        class_2248 block = state.method_26204();
        if (block instanceof class_2256 bonemealableBlock && state.method_26164(class_3481.field_15462)) {

            if (state.method_61767(class_2741.field_16561, false))
                return class_1269.field_5811;

            if (world.method_8608()) {
                class_1752.method_7721(world, context.method_8037(), 100);
                return class_1269.field_5812;
            }

            class_2338 saplingPos = context.method_8037();
            TreesDreamWorld treesDreamWorld = new TreesDreamWorld((class_3218) world, saplingPos);

            for (class_2338 pos : class_2338.method_10094(-1, 0, -1, 1, 0, 1)) {
                if (world.method_8320(saplingPos.method_10081(pos)).method_26204() == block)
                    treesDreamWorld.method_8501(pos.method_10086(10), withStage(state, 1));
            }

            bonemealableBlock.method_9652(treesDreamWorld, treesDreamWorld.method_8409(), class_2338.field_10980.method_10086(10), withStage(state, 1));

            for (class_2338 pos : treesDreamWorld.blocksAdded.keySet()) {
                class_2338 actualPos = pos.method_10081(saplingPos).method_10087(10);
                class_2680 newState = treesDreamWorld.blocksAdded.get(pos);

                // Don't replace Bedrock
                if (world.method_8320(actualPos).method_26214(world, actualPos) == -1)
                    continue;
                // Don't replace solid blocks with leaves
                if (!newState.method_26212(treesDreamWorld, pos) && !world.method_8320(actualPos).method_26220(world, actualPos).method_1110())
                    continue;

                world.method_8501(actualPos, newState);
            }

            if (context.method_8036() != null && !context.method_8036().method_68878())
                context.method_8041().method_7934(1);
            return class_1269.field_5812;

        }

        return super.method_7884(context);
    }

    private class_2680 withStage(class_2680 original, int stage) {
        if (!original.method_28498(class_2741.field_12549))
            return original;
        return original.method_11657(class_2741.field_12549, stage);
    }

    private static class TreesDreamWorld extends PlacementSimulationServerLevel {
        private final class_2680 soil;

        protected TreesDreamWorld(class_3218 wrapped, class_2338 saplingPos) {
            super(wrapped);
            class_2680 stateUnderSapling = wrapped.method_8320(saplingPos.method_10074());

            // Tree features don't seem to succeed with mud as soil
            if (stateUnderSapling.method_26164(class_3481.field_29822))
                stateUnderSapling = class_2246.field_10566.method_9564();

            soil = stateUnderSapling;
        }

        @Override
        public class_2680 method_8320(class_2338 pos) {
            if (pos.method_10264() <= 9)
                return soil;
            return super.method_8320(pos);
        }

        @Override
        public boolean method_8652(class_2338 pos, class_2680 newState, int flags) {
            if (newState.method_26204() == class_2246.field_10520)
                return true;
            return super.method_8652(pos, newState, flags);
        }
    }

}
