package com.zurrtum.create.content.equipment.armor;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllEnchantments;
import com.zurrtum.create.AllShapes;
import com.zurrtum.create.api.entity.FakePlayerHandler;
import com.zurrtum.create.api.schematic.requirement.SpecialBlockItemRequirement;
import com.zurrtum.create.content.kinetics.base.HorizontalKineticBlock;
import com.zurrtum.create.content.schematics.requirement.ItemRequirement;
import com.zurrtum.create.content.schematics.requirement.ItemRequirement.ItemUseType;
import com.zurrtum.create.foundation.block.IBE;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_10;
import net.minecraft.class_10225;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689.class_2690;
import net.minecraft.class_2741;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import net.minecraft.class_8567;
import net.minecraft.class_9326;
import net.minecraft.class_9334;

public class BacktankBlock extends HorizontalKineticBlock implements IBE<BacktankBlockEntity>, class_3737, SpecialBlockItemRequirement {

    public BacktankBlock(class_2251 properties) {
        super(properties);
        method_9590(method_9564().method_11657(class_2741.field_12508, false));
    }

    @Override
    public class_3610 method_9545(class_2680 state) {
        return state.method_11654(class_2741.field_12508) ? class_3612.field_15910.method_15729(false) : class_3612.field_15906.method_15785();
    }

    @Override
    protected void method_9515(class_2690<class_2248, class_2680> builder) {
        builder.method_11667(class_2741.field_12508);
        super.method_9515(builder);
    }

    @Override
    public boolean method_9498(class_2680 p_149740_1_) {
        return true;
    }

    @Override
    public int method_9572(class_2680 state, class_1937 world, class_2338 pos, class_2350 direction) {
        return getBlockEntityOptional(world, pos).map(BacktankBlockEntity::getComparatorOutput).orElse(0);
    }

    @Override
    public class_2680 method_9559(
        class_2680 state,
        class_4538 world,
        class_10225 tickView,
        class_2338 pos,
        class_2350 direction,
        class_2338 neighbourPos,
        class_2680 neighbourState,
        class_5819 random
    ) {
        if (state.method_11654(class_2741.field_12508))
            tickView.method_64312(pos, class_3612.field_15910, class_3612.field_15910.method_15789(world));
        return state;
    }

    @Override
    public class_2680 method_9605(class_1750 context) {
        class_3610 fluidState = context.method_8045().method_8316(context.method_8037());
        return super.method_9605(context).method_11657(class_2741.field_12508, fluidState.method_15772() == class_3612.field_15910);
    }

    @Override
    public boolean hasShaftTowards(class_4538 world, class_2338 pos, class_2680 state, class_2350 face) {
        return face == class_2350.field_11036;
    }

    @Override
    public class_2351 getRotationAxis(class_2680 state) {
        return class_2351.field_11052;
    }

    @Override
    public void method_9567(class_1937 worldIn, class_2338 pos, class_2680 state, class_1309 placer, class_1799 stack) {
        super.method_9567(worldIn, pos, state, placer, stack);
        if (worldIn.method_8608())
            return;
        if (stack == null)
            return;
        withBlockEntityDo(
            worldIn, pos, be -> {
                be.setCapacityEnchantLevel(stack.method_58657().method_57536(worldIn.method_30349().method_66874(AllEnchantments.CAPACITY)));
                be.setAirLevel(stack.method_58695(AllDataComponents.BACKTANK_AIR, 0));
                if (stack.method_57826(class_9334.field_49631))
                    be.setCustomName(stack.method_65130());

                be.setComponentPatch(stack.method_57380());
            }
        );
    }

    @Override
    public List<class_1799> method_9560(class_2680 pState, class_8567.class_8568 pBuilder) {
        List<class_1799> lootDrops = super.method_9560(pState, pBuilder);

        class_2586 blockEntity = pBuilder.method_51876(class_181.field_1228);
        if (!(blockEntity instanceof BacktankBlockEntity bbe))
            return lootDrops;

        class_9326 components = bbe.getComponentPatch().method_58757(c -> c.equals(AllDataComponents.BACKTANK_AIR));
        if (components.method_57848())
            return lootDrops;

        return lootDrops.stream().peek(stack -> {
            if (stack.method_7909() instanceof BacktankItem)
                stack.method_57366(components);
        }).toList();
    }

    @Override
    protected class_1269 method_55765(
        class_1799 stack,
        class_2680 state,
        class_1937 level,
        class_2338 pos,
        class_1657 player,
        class_1268 hand,
        class_3965 hitResult
    ) {
        if (player == null)
            return class_1269.field_52423;
        if (FakePlayerHandler.has(player))
            return class_1269.field_52423;
        if (player.method_5715())
            return class_1269.field_52423;
        if (player.method_6047().method_7909() instanceof class_1747)
            return class_1269.field_52423;
        if (!player.method_6118(class_1304.field_6174).method_7960())
            return class_1269.field_52423;
        if (!level.method_8608()) {
            level.method_8396(null, pos, class_3417.field_15197, class_3419.field_15248, .75f, 1);
            player.method_5673(class_1304.field_6174, method_9574(level, pos, state, true));
            level.method_22352(pos, false);
        }
        return class_1269.field_5812;
    }

    @SuppressWarnings("deprecation")
    public class_1799 method_9574(class_4538 pLevel, class_2338 pos, class_2680 state, boolean includeData) {
        class_1792 item = method_8389();
        //        if (item instanceof BacktankItem.BacktankBlockItem placeable)
        //            item = placeable.getActualItem();

        Optional<BacktankBlockEntity> blockEntityOptional = getBlockEntityOptional(pLevel, pos);

        class_9326 components = blockEntityOptional.map(BacktankBlockEntity::getComponentPatch).orElse(class_9326.field_49588);
        int air = blockEntityOptional.map(BacktankBlockEntity::getAirLevel).orElse(0);

        class_1799 stack = new class_1799(item.method_40131(), 1, components);
        stack.method_57379(AllDataComponents.BACKTANK_AIR, air);
        return stack;
    }

    @Override
    public class_265 method_9530(class_2680 p_220053_1_, class_1922 p_220053_2_, class_2338 p_220053_3_, class_3726 p_220053_4_) {
        return AllShapes.BACKTANK;
    }

    @Override
    public Class<BacktankBlockEntity> getBlockEntityClass() {
        return BacktankBlockEntity.class;
    }

    @Override
    public class_2591<? extends BacktankBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.BACKTANK;
    }

    @Override
    protected boolean method_9516(class_2680 state, class_10 pathComputationType) {
        return false;
    }

    @Override
    public ItemRequirement getRequiredItems(class_2680 state, class_2586 blockEntity) {
        class_1792 item = method_8389();
        //        if (item instanceof BacktankItem.BacktankBlockItem placeable)
        //            item = placeable.getActualItem();
        return new ItemRequirement(ItemUseType.CONSUME, item);
    }

}
