package com.zurrtum.create.content.equipment.toolbox;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.catnip.codecs.stream.CatnipStreamCodecBuilders;
import com.zurrtum.create.foundation.codec.CreateCodecs;
import com.zurrtum.create.foundation.item.ItemSlots;
import com.zurrtum.create.infrastructure.items.ItemInventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public class ToolboxInventory implements ItemInventory {
    public static final int STACKS_PER_COMPARTMENT = 4;
    public static final int SIZE = 8 * STACKS_PER_COMPARTMENT;
    public static final Codec<ToolboxInventory> CODEC = RecordCodecBuilder.create(instance -> instance.group(
        ItemSlots.maxSizeCodec(8 * STACKS_PER_COMPARTMENT).fieldOf("items").forGetter(ItemSlots::fromHandler),
        class_1799.field_49266.listOf().fieldOf("filters").forGetter(toolbox -> toolbox.filters)
    ).apply(instance, ToolboxInventory::deserialize));

    public static final class_9139<class_9129, ToolboxInventory> STREAM_CODEC = class_9139.method_56435(
        ItemSlots.STREAM_CODEC,
        ItemSlots::fromHandler,
        CatnipStreamCodecBuilders.list(class_1799.field_49268),
        toolbox -> toolbox.filters,
        ToolboxInventory::deserialize
    );

    public class_2371<class_1799> filters;
    class_2371<class_1799> stacks;
    @Nullable
    private final ToolboxBlockEntity blockEntity;
    private boolean limitedMode;

    public ToolboxInventory(@Nullable ToolboxBlockEntity be) {
        filters = class_2371.method_10213(8, class_1799.field_8037);
        stacks = class_2371.method_10213(SIZE, class_1799.field_8037);
        blockEntity = be;
        limitedMode = false;
    }

    public void inLimitedMode(Consumer<ToolboxInventory> action) {
        limitedMode = true;
        action.accept(this);
        limitedMode = false;
    }

    @Override
    public int method_5439() {
        return SIZE;
    }

    @Override
    public class_1799 method_5438(int slot) {
        if (slot >= SIZE) {
            return class_1799.field_8037;
        }
        return stacks.get(slot);
    }

    @Override
    public boolean method_5437(int slot, class_1799 stack) {
        if (!stack.method_7909().method_31568()) {
            return false;
        }
        if (slot >= SIZE) {
            return false;
        }
        class_1799 filter = filters.get(slot / STACKS_PER_COMPARTMENT);
        boolean empty = filter.method_7960();
        if (limitedMode && empty) {
            return false;
        }
        return empty || canItemsShareCompartment(filter, stack);
    }

    @Override
    public void method_5447(int slot, class_1799 stack) {
        if (slot >= SIZE) {
            return;
        }
        stacks.set(slot, stack);
        if (!stack.method_7960()) {
            int compartment = slot / STACKS_PER_COMPARTMENT;
            if (filters.get(compartment).method_7960()) {
                filters.set(compartment, stack.method_46651(1));
            }
        }
    }

    public int distributeToCompartment(@NotNull class_1799 stack, int compartment, boolean simulate) {
        if (stack.method_7960() || !stack.method_7909().method_31568()) {
            return 0;
        }
        class_1799 filter = filters.get(compartment);
        if (filter.method_7960() || !canItemsShareCompartment(filter, stack)) {
            return 0;
        }
        int maxAmount = stack.method_7947();
        int stackSize = stack.method_7914();
        if (simulate) {
            int count = 0;
            for (int i = compartment * STACKS_PER_COMPARTMENT, end = i + STACKS_PER_COMPARTMENT; i < end; i++) {
                class_1799 target = method_5438(i);
                if (target.method_7960()) {
                    return maxAmount;
                } else {
                    count += stackSize - target.method_7947();
                    if (count >= maxAmount) {
                        return maxAmount;
                    }
                }
            }
            return count;
        } else {
            int remaining = maxAmount;
            for (int i = compartment * STACKS_PER_COMPARTMENT, end = i + STACKS_PER_COMPARTMENT; i < end; i++) {
                class_1799 target = method_5438(i);
                if (target.method_7960()) {
                    method_5447(i, directCopy(stack, remaining));
                    method_5431();
                    return maxAmount;
                } else {
                    int count = target.method_7947();
                    if (count != stackSize) {
                        int insert = Math.min(remaining, stackSize - count);
                        target.method_7939(count + insert);
                        if (remaining == insert) {
                            method_5431();
                            return maxAmount;
                        }
                        remaining -= insert;
                    }
                }
            }
            if (remaining == maxAmount) {
                return 0;
            }
            method_5431();
            return maxAmount - remaining;
        }
    }

    public class_1799 takeFromCompartment(int maxAmount, int compartment, boolean simulate) {
        if (maxAmount == 0) {
            return class_1799.field_8037;
        }
        int index = compartment * STACKS_PER_COMPARTMENT;
        if (simulate) {
            for (int i = index + STACKS_PER_COMPARTMENT - 1; i >= index; i--) {
                class_1799 findStack = stacks.get(i);
                if (findStack.method_7960()) {
                    continue;
                }
                int count = findStack.method_7947();
                if (count >= maxAmount) {
                    return directCopy(findStack, maxAmount);
                }
                for (int j = i - 1; j >= index; j--) {
                    class_1799 stack = method_5438(i);
                    if (stack.method_7960()) {
                        continue;
                    }
                    count += stack.method_7947();
                    if (count < maxAmount) {
                        continue;
                    }
                    return directCopy(findStack, maxAmount);
                }
                return directCopy(findStack, count);
            }
            return class_1799.field_8037;
        } else {
            class_1799 stack = takeFromCompartment(maxAmount, index, index + STACKS_PER_COMPARTMENT - 1);
            if (stack == class_1799.field_8037) {
                return stack;
            }
            method_5431();
            return stack;
        }
    }

    protected class_1799 takeFromCompartment(int maxAmount, int start, int end) {
        for (int i = end; i >= start; i--) {
            class_1799 findStack = stacks.get(i);
            if (findStack.method_7960()) {
                continue;
            }
            int count = findStack.method_7947();
            if (count > maxAmount) {
                findStack.method_7939(count - maxAmount);
                return directCopy(findStack, maxAmount);
            }
            method_5447(i, class_1799.field_8037);
            if (count == maxAmount) {
                return findStack;
            }
            int remaining = maxAmount - count;
            for (int j = i - 1; j >= start; j--) {
                class_1799 stack = stacks.get(j);
                if (stack.method_7960()) {
                    continue;
                }
                count = stack.method_7947();
                if (count < remaining) {
                    method_5447(i, class_1799.field_8037);
                    remaining -= count;
                    continue;
                }
                if (count == remaining) {
                    method_5447(i, class_1799.field_8037);
                } else {
                    stack.method_7939(count - remaining);
                }
                findStack.method_7939(maxAmount);
                return findStack;
            }
            findStack.method_7939(maxAmount - remaining);
            return findStack;
        }
        return class_1799.field_8037;
    }

    @Override
    public void method_5431() {
        if (blockEntity != null) {
            blockEntity.notifyUpdate();
        }
    }

    public static class_1799 cleanItemNBT(class_1799 stack) {
        if (stack.method_31574(AllItems.BELT_CONNECTOR))
            stack.method_57381(AllDataComponents.BELT_FIRST_SHAFT);
        return stack;
    }

    public static boolean canItemsShareCompartment(class_1799 stack1, class_1799 stack2) {
        if (!stack1.method_7946() && !stack2.method_7946() && stack1.method_7963() && stack2.method_7963())
            return stack1.method_7909() == stack2.method_7909();
        if (stack1.method_31574(AllItems.BELT_CONNECTOR) && stack2.method_31574(AllItems.BELT_CONNECTOR))
            return true;
        return class_1799.method_31577(stack1, stack2);
    }

    public void write(class_11372 view) {
        view.method_71468("Items", ItemSlots.CODEC, ItemSlots.fromHandler(this));
        view.method_71468("Compartments", CreateCodecs.ITEM_LIST_CODEC, filters);
    }

    public void read(class_11368 view) {
        view.method_71426("Items", ItemSlots.CODEC).ifPresentOrElse(
            slots -> {
                boolean[] fill = new boolean[SIZE];
                slots.forEach((slot, stack) -> {
                    stacks.set(slot, stack);
                    fill[slot] = true;
                });
                for (int i = 0; i < SIZE; i++) {
                    if (!fill[i]) {
                        stacks.set(i, class_1799.field_8037);
                    }
                }
            }, stacks::clear
        );
        view.method_71426("Compartments", CreateCodecs.ITEM_LIST_CODEC).ifPresentOrElse(
            list -> {
                for (int i = 0, size = Math.min(list.size(), SIZE); i < size; i++) {
                    filters.set(i, list.get(i));
                }
            }, filters::clear
        );
    }

    private static ToolboxInventory deserialize(ItemSlots slots, List<class_1799> filters) {
        ToolboxInventory inventory = new ToolboxInventory(null);
        slots.forEach(inventory.stacks::set);
        for (int i = 0, size = Math.min(filters.size(), SIZE); i < size; i++) {
            inventory.filters.set(i, filters.get(i));
        }
        return inventory;
    }

    @Override
    public final boolean equals(Object o) {
        if (!(o instanceof ToolboxInventory that))
            return false;

        return limitedMode == that.limitedMode && filters.equals(that.filters) && Objects.equals(blockEntity, that.blockEntity);
    }

    @Override
    public int hashCode() {
        int result = filters.hashCode();
        result = 31 * result + Objects.hashCode(blockEntity);
        result = 31 * result + Boolean.hashCode(limitedMode);
        return result;
    }
}
