package com.zurrtum.create.content.fluids.transfer;

import com.zurrtum.create.AllFluids;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.content.fluids.potion.PotionFluidHandler;
import com.zurrtum.create.foundation.fluid.FluidHelper;
import com.zurrtum.create.infrastructure.fluids.FluidItemInventory;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1937;
import net.minecraft.class_3611;
import net.minecraft.class_3612;

public class GenericItemFilling {
    public static boolean canItemBeFilled(class_1937 world, class_1799 stack) {
        if (stack.method_7909() == class_1802.field_8469)
            return true;
        if (stack.method_7909() == class_1802.field_8103)
            return false;

        try (FluidItemInventory capability = FluidHelper.getFluidInventory(stack)) {
            if (capability == null) {
                return false;
            }
            for (int i = 0, size = capability.size(); i < size; i++) {
                FluidStack fluidStack = capability.getStack(i);
                if (fluidStack.getAmount() < capability.getMaxAmount(fluidStack)) {
                    return true;
                }
            }
            return false;
        }
    }

    public static int getRequiredAmountForItem(class_1937 world, class_1799 stack, FluidStack availableFluid) {
        if (stack.method_7909() == class_1802.field_8469 && canFillGlassBottleInternally(availableFluid))
            return PotionFluidHandler.getRequiredAmountForFilledBottle(stack, availableFluid);

        try (FluidItemInventory capability = FluidHelper.getFluidInventory(stack)) {
            if (capability == null) {
                return -1;
            }
            return capability.countSpace(availableFluid);
        }
    }

    private static boolean canFillGlassBottleInternally(FluidStack availableFluid) {
        class_3611 fluid = availableFluid.getFluid();
        if (fluid.method_15780(class_3612.field_15910))
            return true;
        if (fluid.method_15780(AllFluids.POTION))
            return true;
        return fluid.method_15780(AllFluids.TEA);
    }

    public static class_1799 fillItem(class_1937 world, int requiredAmount, class_1799 stack, FluidStack availableFluid) {
        FluidStack toFill = availableFluid.copy();
        toFill.setAmount(requiredAmount);

        if (stack.method_7909() == class_1802.field_8469 && canFillGlassBottleInternally(toFill)) {
            class_1799 fillBottle;
            class_3611 fluid = toFill.getFluid();
            if (FluidHelper.isWater(fluid))
                fillBottle = class_1844.method_57400(class_1802.field_8574, class_1847.field_8991);
            else if (fluid.method_15780(AllFluids.TEA))
                fillBottle = AllItems.BUILDERS_TEA.method_7854();
            else
                fillBottle = PotionFluidHandler.fillBottle(stack, toFill);
            availableFluid.decrement(requiredAmount);
            stack.method_7934(1);
            return fillBottle;
        }

        try (FluidItemInventory capability = FluidHelper.getFluidInventory(stack.method_46651(1))) {
            if (capability == null) {
                return class_1799.field_8037;
            }
            int insert = capability.insert(toFill);
            if (insert == 0) {
                return class_1799.field_8037;
            }
            availableFluid.decrement(insert);
            stack.method_7934(1);
            return capability.getContainer();
        }
    }

}
