package com.zurrtum.create.content.kinetics.crank;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllShapes;
import com.zurrtum.create.content.kinetics.base.DirectionalKineticBlock;
import com.zurrtum.create.foundation.block.IBE;
import com.zurrtum.create.foundation.block.NeighborUpdateListeningBlock;
import com.zurrtum.create.foundation.block.ProperWaterloggedBlock;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import net.minecraft.class_10;
import net.minecraft.class_10225;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689.class_2690;
import net.minecraft.class_3222;
import net.minecraft.class_3610;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_5819;

public class HandCrankBlock extends DirectionalKineticBlock implements IBE<HandCrankBlockEntity>, ProperWaterloggedBlock, NeighborUpdateListeningBlock {

    public HandCrankBlock(class_2251 properties) {
        super(properties);
        method_9590(method_9564().method_11657(WATERLOGGED, false));
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 worldIn, class_2338 pos, class_3726 context) {
        return AllShapes.CRANK.get(state.method_11654(FACING));
    }

    @Override
    protected void method_9515(class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder.method_11667(WATERLOGGED));
    }

    public int getRotationSpeed() {
        return 32;
    }

    public static boolean onBlockActivated(class_1268 hand, class_2680 state, class_1799 stack) {
        if (hand == class_1268.field_5810 || stack.method_31574(AllItems.WRENCH)) {
            return false;
        }
        return state.method_26204() instanceof HandCrankBlock;
    }

    @Override
    protected class_1269 method_55765(
        class_1799 stack,
        class_2680 state,
        class_1937 level,
        class_2338 pos,
        class_1657 player,
        class_1268 hand,
        class_3965 hitResult
    ) {
        if (player.method_7325())
            return class_1269.field_52423;

        withBlockEntityDo(level, pos, be -> be.turn(player.method_5715()));
        if (!stack.method_31574(AllItems.EXTENDO_GRIP))
            player.method_7322(getRotationSpeed() * AllConfigs.server().kinetics.crankHungerMultiplier.getF());

        if (player.method_7344().method_7586() == 0 && player instanceof class_3222 serverPlayer)
            AllAdvancements.HAND_CRANK.trigger(serverPlayer);

        return class_1269.field_5812;
    }

    @Override
    public class_2680 method_9605(class_1750 context) {
        class_2350 preferred = getPreferredFacing(context);
        class_2680 defaultBlockState = withWater(method_9564(), context);
        if (preferred == null || (context.method_8036() != null && context.method_8036().method_5715()))
            return defaultBlockState.method_11657(FACING, context.method_8038());
        return defaultBlockState.method_11657(FACING, preferred.method_10153());
    }

    @Override
    public boolean method_9558(class_2680 state, class_4538 worldIn, class_2338 pos) {
        class_2350 facing = state.method_11654(FACING).method_10153();
        class_2338 neighbourPos = pos.method_10093(facing);
        class_2680 neighbour = worldIn.method_8320(neighbourPos);
        return !neighbour.method_26220(worldIn, neighbourPos).method_1110();
    }

    @Override
    public void neighborUpdate(class_2680 state, class_1937 worldIn, class_2338 pos, class_2248 sourceBlock, class_2338 fromPos, boolean isMoving) {
        if (worldIn.method_8608())
            return;

        class_2350 blockFacing = state.method_11654(FACING);
        if (fromPos.equals(pos.method_10093(blockFacing.method_10153()))) {
            if (!method_9558(state, worldIn, pos)) {
                worldIn.method_22352(pos, true);
            }
        }
    }

    @Override
    public class_2680 method_9559(
        class_2680 pState,
        class_4538 pLevel,
        class_10225 tickView,
        class_2338 pCurrentPos,
        class_2350 pDirection,
        class_2338 pNeighborPos,
        class_2680 pNeighborState,
        class_5819 random
    ) {
        updateWater(pLevel, tickView, pState, pCurrentPos);
        return pState;
    }

    @Override
    public class_3610 method_9545(class_2680 pState) {
        return fluidState(pState);
    }

    @Override
    public boolean hasShaftTowards(class_4538 world, class_2338 pos, class_2680 state, class_2350 face) {
        return face == state.method_11654(FACING).method_10153();
    }

    @Override
    public class_2351 getRotationAxis(class_2680 state) {
        return state.method_11654(FACING).method_10166();
    }

    @Override
    public Class<HandCrankBlockEntity> getBlockEntityClass() {
        return HandCrankBlockEntity.class;
    }

    @Override
    public class_2591<? extends HandCrankBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.HAND_CRANK;
    }

    @Override
    protected boolean method_9516(class_2680 state, class_10 pathComputationType) {
        return false;
    }
}
