package com.zurrtum.create.content.kinetics.deployer;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllShapes;
import com.zurrtum.create.catnip.placement.IPlacementHelper;
import com.zurrtum.create.catnip.placement.PlacementHelpers;
import com.zurrtum.create.catnip.placement.PlacementOffset;
import com.zurrtum.create.content.kinetics.base.DirectionalAxisKineticBlock;
import com.zurrtum.create.content.processing.AssemblyOperatorUseContext;
import com.zurrtum.create.foundation.block.IBE;
import com.zurrtum.create.infrastructure.items.ItemInventoryProvider;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_10;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_9904;

public class DeployerBlock extends DirectionalAxisKineticBlock implements IBE<DeployerBlockEntity>, ItemInventoryProvider<DeployerBlockEntity> {

    private static final int placementHelperId = PlacementHelpers.register(new PlacementHelper());

    public DeployerBlock(class_2251 properties) {
        super(properties);
    }

    @Override
    public class_1263 getInventory(class_1936 world, class_2338 pos, class_2680 state, DeployerBlockEntity blockEntity, class_2350 context) {
        if (blockEntity.invHandler == null)
            blockEntity.initHandler();
        return blockEntity.invHandler;
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 worldIn, class_2338 pos, class_3726 context) {
        return AllShapes.DEPLOYER_INTERACTION.get(state.method_11654(FACING));
    }

    @Override
    public class_265 method_9549(class_2680 state, class_1922 worldIn, class_2338 pos, class_3726 context) {
        return AllShapes.CASING_12PX.get(state.method_11654(FACING));
    }

    @Override
    public class_1269 onWrenched(class_2680 state, class_1838 context) {
        class_243 normal = class_243.method_24954(state.method_11654(FACING).method_62675());
        class_243 location = context.method_17698().method_1020(class_243.method_24953(context.method_8037()).method_1020(normal.method_1021(.5))).method_18806(normal);
        if (location.method_1033() > .75f) {
            if (!context.method_8045().method_8608())
                withBlockEntityDo(context.method_8045(), context.method_8037(), DeployerBlockEntity::changeMode);
            return class_1269.field_5812;
        }
        return super.onWrenched(state, context);
    }

    @Override
    public void method_9567(class_1937 worldIn, class_2338 pos, class_2680 state, class_1309 placer, class_1799 stack) {
        super.method_9567(worldIn, pos, state, placer, stack);
        if (placer instanceof class_3222 serverPlayer) {
            withBlockEntityDo(
                worldIn, pos, dbe -> {
                    dbe.owner = serverPlayer.method_5667();
                    dbe.ownerName = serverPlayer.method_7334().name();
                }
            );
        }
    }

    @Override
    protected class_1269 method_55765(
        class_1799 stack,
        class_2680 state,
        class_1937 level,
        class_2338 pos,
        class_1657 player,
        class_1268 hand,
        class_3965 hitResult
    ) {
        class_1799 heldByPlayer = stack.method_7972();

        IPlacementHelper placementHelper = PlacementHelpers.get(placementHelperId);
        if (!player.method_5715() && player.method_7294()) {
            if (placementHelper.matchesItem(heldByPlayer) && placementHelper.getOffset(player, level, state, pos, hitResult)
                .placeInWorld(level, (class_1747) heldByPlayer.method_7909(), player, hand).method_23665())
                return class_1269.field_5812;
        }

        if (heldByPlayer.method_31574(AllItems.WRENCH))
            return class_1269.field_52423;

        class_243 normal = class_243.method_24954(state.method_11654(FACING).method_62675());
        class_243 location = hitResult.method_17784().method_1020(class_243.method_24953(pos).method_1020(normal.method_1021(.5))).method_18806(normal);
        if (location.method_1033() < .75f)
            return class_1269.field_52423;
        if (level.method_8608())
            return class_1269.field_5812;

        withBlockEntityDo(
            level, pos, be -> {
                class_3222 serverPlayer = be.player.cast();
                class_1799 heldByDeployer = serverPlayer.method_6047().method_7972();
                if (heldByDeployer.method_7960() && heldByPlayer.method_7960())
                    return;

                player.method_6122(hand, heldByDeployer);
                serverPlayer.method_6122(class_1268.field_5808, heldByPlayer);
                be.notifyUpdate();
            }
        );

        return class_1269.field_5812;
    }

    @Override
    public Class<DeployerBlockEntity> getBlockEntityClass() {
        return DeployerBlockEntity.class;
    }

    @Override
    public class_2591<? extends DeployerBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.DEPLOYER;
    }

    @Override
    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean isMoving) {
        super.method_9615(state, world, pos, oldState, isMoving);
        withBlockEntityDo(world, pos, DeployerBlockEntity::redstoneUpdate);
    }

    @Override
    public void method_9612(
        class_2680 state,
        class_1937 world,
        class_2338 pos,
        class_2248 p_220069_4_,
        @Nullable class_9904 wireOrientation,
        boolean p_220069_6_
    ) {
        withBlockEntityDo(world, pos, DeployerBlockEntity::redstoneUpdate);
    }

    @Override
    protected boolean method_9516(class_2680 state, class_10 pathComputationType) {
        return false;
    }

    @Override
    protected class_2350 getFacingForPlacement(class_1750 context) {
        if (context instanceof AssemblyOperatorUseContext)
            return class_2350.field_11033;
        else
            return super.getFacingForPlacement(context);
    }

    private static class PlacementHelper implements IPlacementHelper {

        @Override
        public Predicate<class_1799> getItemPredicate() {
            return stack -> stack.method_31574(AllItems.DEPLOYER);
        }

        @Override
        public Predicate<class_2680> getStatePredicate() {
            return state -> state.method_27852(AllBlocks.DEPLOYER);
        }

        @Override
        public PlacementOffset getOffset(class_1657 player, class_1937 world, class_2680 state, class_2338 pos, class_3965 ray) {
            List<class_2350> directions = IPlacementHelper.orderedByDistanceExceptAxis(
                pos,
                ray.method_17784(),
                state.method_11654(FACING).method_10166(),
                dir -> world.method_8320(pos.method_10093(dir)).method_45474()
            );

            if (directions.isEmpty())
                return PlacementOffset.fail();
            else {
                return PlacementOffset.success(
                    pos.method_10093(directions.getFirst()),
                    s -> s.method_11657(FACING, state.method_11654(FACING)).method_11657(AXIS_ALONG_FIRST_COORDINATE, state.method_11654(AXIS_ALONG_FIRST_COORDINATE))
                );
            }
        }

    }

}
