package com.zurrtum.create.content.kinetics.millstone;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllShapes;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.content.kinetics.base.KineticBlock;
import com.zurrtum.create.content.kinetics.simpleRelays.ICogWheel;
import com.zurrtum.create.foundation.block.IBE;
import com.zurrtum.create.foundation.item.ItemHelper;
import com.zurrtum.create.infrastructure.items.ItemInventoryProvider;
import net.minecraft.class_10;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;

public class MillstoneBlock extends KineticBlock implements IBE<MillstoneBlockEntity>, ICogWheel, ItemInventoryProvider<MillstoneBlockEntity> {

    public MillstoneBlock(class_2251 properties) {
        super(properties);
    }

    @Override
    public class_1263 getInventory(class_1936 world, class_2338 pos, class_2680 state, MillstoneBlockEntity blockEntity, class_2350 context) {
        return blockEntity.capability;
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 worldIn, class_2338 pos, class_3726 context) {
        return AllShapes.MILLSTONE;
    }

    @Override
    public boolean hasShaftTowards(class_4538 world, class_2338 pos, class_2680 state, class_2350 face) {
        return face == class_2350.field_11033;
    }

    @Override
    protected class_1269 method_55765(
        class_1799 stack,
        class_2680 state,
        class_1937 level,
        class_2338 pos,
        class_1657 player,
        class_1268 hand,
        class_3965 hitResult
    ) {
        if (!stack.method_7960())
            return class_1269.field_52423;
        if (level.method_8608())
            return class_1269.field_5812;

        withBlockEntityDo(
            level, pos, millstone -> {
                boolean emptyOutput = true;
                class_1263 inv = millstone.capability;
                for (int slot = 1, size = inv.method_5439(); slot < size; slot++) {
                    class_1799 stackInSlot = inv.method_5438(slot);
                    if (stackInSlot.method_7960()) {
                        continue;
                    }
                    emptyOutput = false;
                    player.method_31548().method_7398(stackInSlot);
                    inv.method_5447(slot, class_1799.field_8037);
                }

                if (emptyOutput) {
                    player.method_31548().method_7398(inv.method_5438(0));
                    inv.method_5447(0, class_1799.field_8037);
                }

                millstone.method_5431();
                millstone.sendData();
            }
        );

        return class_1269.field_5812;
    }

    @Override
    public void method_9502(class_1922 worldIn, class_1297 entityIn) {
        super.method_9502(worldIn, entityIn);

        if (entityIn.method_73183().method_8608())
            return;
        if (!(entityIn instanceof class_1542 itemEntity))
            return;
        if (!entityIn.method_5805())
            return;

        MillstoneBlockEntity millstone = null;
        for (class_2338 pos : Iterate.hereAndBelow(entityIn.method_24515()))
            if (millstone == null)
                millstone = getBlockEntity(worldIn, pos);

        if (millstone == null)
            return;

        class_1263 capability = ItemHelper.getInventory(millstone.method_10997(), millstone.method_11016(), millstone.method_11010(), millstone, null);
        if (capability == null)
            return;

        class_1799 stack = itemEntity.method_6983();
        int insert = capability.insert(stack);
        if (insert == stack.method_7947()) {
            itemEntity.method_31472();
        } else if (insert != 0) {
            stack.method_7934(insert);
            itemEntity.method_6979(stack);
        }
    }

    @Override
    public class_2351 getRotationAxis(class_2680 state) {
        return class_2351.field_11052;
    }

    @Override
    public Class<MillstoneBlockEntity> getBlockEntityClass() {
        return MillstoneBlockEntity.class;
    }

    @Override
    public class_2591<? extends MillstoneBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.MILLSTONE;
    }

    @Override
    protected boolean method_9516(class_2680 state, class_10 pathComputationType) {
        return false;
    }

}