package com.zurrtum.create.content.kinetics.speedController;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllShapes;
import com.zurrtum.create.catnip.placement.IPlacementHelper;
import com.zurrtum.create.catnip.placement.PlacementHelpers;
import com.zurrtum.create.catnip.placement.PlacementOffset;
import com.zurrtum.create.content.kinetics.base.HorizontalAxisKineticBlock;
import com.zurrtum.create.content.kinetics.simpleRelays.CogWheelBlock;
import com.zurrtum.create.content.kinetics.simpleRelays.ICogWheel;
import com.zurrtum.create.foundation.block.IBE;
import com.zurrtum.create.foundation.block.NeighborUpdateListeningBlock;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3726;
import net.minecraft.class_3965;

public class SpeedControllerBlock extends HorizontalAxisKineticBlock implements IBE<SpeedControllerBlockEntity>, NeighborUpdateListeningBlock {

    private static final int placementHelperId = PlacementHelpers.register(new PlacementHelper());

    public SpeedControllerBlock(class_2251 properties) {
        super(properties);
    }

    @Override
    public class_2680 method_9605(class_1750 context) {
        class_2680 above = context.method_8045().method_8320(context.method_8037().method_10084());
        if (ICogWheel.isLargeCog(above) && above.method_11654(CogWheelBlock.AXIS).method_10179())
            return method_9564().method_11657(HORIZONTAL_AXIS, above.method_11654(CogWheelBlock.AXIS) == class_2351.field_11048 ? class_2351.field_11051 : class_2351.field_11048);
        return super.method_9605(context);
    }

    @Override
    public void neighborUpdate(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, class_2338 neighborPos, boolean isMoving) {
        if (neighborPos.equals(pos.method_10084()))
            withBlockEntityDo(world, pos, SpeedControllerBlockEntity::updateBracket);
    }

    @Override
    protected class_1269 method_55765(
        class_1799 stack,
        class_2680 state,
        class_1937 level,
        class_2338 pos,
        class_1657 player,
        class_1268 hand,
        class_3965 hitResult
    ) {
        IPlacementHelper helper = PlacementHelpers.get(placementHelperId);
        if (helper.matchesItem(stack))
            return helper.getOffset(player, level, state, pos, hitResult).placeInWorld(level, (class_1747) stack.method_7909(), player, hand);

        return class_1269.field_52423;
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 worldIn, class_2338 pos, class_3726 context) {
        return AllShapes.SPEED_CONTROLLER;
    }

    private static class PlacementHelper implements IPlacementHelper {
        @Override
        public Predicate<class_1799> getItemPredicate() {
            return ((Predicate<class_1799>) ICogWheel::isLargeCogItem).and(ICogWheel::isDedicatedCogItem);
        }

        @Override
        public Predicate<class_2680> getStatePredicate() {
            return state -> state.method_27852(AllBlocks.ROTATION_SPEED_CONTROLLER);
        }

        @Override
        public PlacementOffset getOffset(class_1657 player, class_1937 world, class_2680 state, class_2338 pos, class_3965 ray) {
            class_2338 newPos = pos.method_10084();
            if (!world.method_8320(newPos).method_45474())
                return PlacementOffset.fail();

            class_2351 newAxis = state.method_11654(HORIZONTAL_AXIS) == class_2351.field_11048 ? class_2351.field_11051 : class_2351.field_11048;

            if (!CogWheelBlock.isValidCogwheelPosition(true, world, newPos, newAxis))
                return PlacementOffset.fail();

            return PlacementOffset.success(newPos, s -> s.method_11657(CogWheelBlock.AXIS, newAxis));
        }
    }

    @Override
    public Class<SpeedControllerBlockEntity> getBlockEntityClass() {
        return SpeedControllerBlockEntity.class;
    }

    @Override
    public class_2591<? extends SpeedControllerBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.ROTATION_SPEED_CONTROLLER;
    }
}
