package com.zurrtum.create.content.kinetics.steamEngine;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.content.contraptions.bearing.WindmillBearingBlockEntity.RotationDirection;
import com.zurrtum.create.content.fluids.tank.FluidTankBlockEntity;
import com.zurrtum.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.zurrtum.create.content.kinetics.base.IRotate;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.scrollValue.ServerScrollOptionBehaviour;
import java.lang.ref.WeakReference;
import java.util.List;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_238;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3532;

public class SteamEngineBlockEntity extends SmartBlockEntity {

    protected ServerScrollOptionBehaviour<RotationDirection> movementDirection;

    public WeakReference<PoweredShaftBlockEntity> target;
    public WeakReference<FluidTankBlockEntity> source;

    public float prevAngle = 0;

    public SteamEngineBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.STEAM_ENGINE, pos, state);
        source = new WeakReference<>(null);
        target = new WeakReference<>(null);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        movementDirection = new ServerScrollOptionBehaviour<>(RotationDirection.class, this);
        movementDirection.withCallback($ -> onDirectionChanged());
        behaviours.add(movementDirection);
    }

    @Override
    public List<CreateTrigger> getAwardables() {
        return List.of(AllAdvancements.STEAM_ENGINE);
    }

    private void onDirectionChanged() {
    }

    @Override
    public void tick() {
        super.tick();
        FluidTankBlockEntity tank = getTank();
        PoweredShaftBlockEntity shaft = getShaft();

        if (tank == null || shaft == null || !isValid()) {
            if (field_11863.method_8608())
                return;
            if (shaft == null)
                return;
            if (!shaft.method_11016().method_10059(field_11867).equals(shaft.enginePos))
                return;
            if (shaft.engineEfficiency == 0)
                return;
            class_2350 facing = SteamEngineBlock.getFacing(method_11010());
            if (field_11863.method_8477(field_11867.method_10093(facing.method_10153())))
                shaft.update(field_11867, 0, 0);
            return;
        }

        class_2680 shaftState = shaft.method_11010();
        class_2351 targetAxis = class_2351.field_11048;
        if (shaftState.method_26204() instanceof IRotate ir)
            targetAxis = ir.getRotationAxis(shaftState);
        boolean verticalTarget = targetAxis == class_2351.field_11052;

        class_2680 blockState = method_11010();
        if (!blockState.method_27852(AllBlocks.STEAM_ENGINE))
            return;
        class_2350 facing = SteamEngineBlock.getFacing(blockState);
        if (facing.method_10166() == class_2351.field_11052)
            facing = blockState.method_11654(SteamEngineBlock.field_11177);

        float efficiency = class_3532.method_15363(tank.boiler.getEngineEfficiency(tank.getTotalTankSize()), 0, 1);
        if (efficiency > 0)
            award(AllAdvancements.STEAM_ENGINE);

        int conveyedSpeedLevel = efficiency == 0 ? 1 : verticalTarget ? 1 : (int) GeneratingKineticBlockEntity.convertToDirection(1, facing);
        if (targetAxis == class_2351.field_11051)
            conveyedSpeedLevel *= -1;
        if (movementDirection.get() == RotationDirection.COUNTER_CLOCKWISE)
            conveyedSpeedLevel *= -1;

        float shaftSpeed = shaft.getTheoreticalSpeed();
        if (shaft.hasSource() && shaftSpeed != 0 && conveyedSpeedLevel != 0 && (shaftSpeed > 0) != (conveyedSpeedLevel > 0)) {
            movementDirection.setValue(1 - movementDirection.get().ordinal());
            conveyedSpeedLevel *= -1;
        }

        shaft.update(field_11867, conveyedSpeedLevel, efficiency);

        if (!field_11863.method_8608())
            return;

        AllClientHandle.INSTANCE.spawnSteamEngineParticles(this);
    }

    @Override
    public void remove() {
        PoweredShaftBlockEntity shaft = getShaft();
        if (shaft != null)
            shaft.remove(field_11867);
        super.remove();
    }

    @Override
    protected class_238 createRenderBoundingBox() {
        return super.createRenderBoundingBox().method_1014(2);
    }

    public PoweredShaftBlockEntity getShaft() {
        PoweredShaftBlockEntity shaft = target.get();
        if (shaft == null || shaft.method_11015() || !shaft.canBePoweredBy(field_11867)) {
            if (shaft != null)
                target = new WeakReference<>(null);
            class_2350 facing = SteamEngineBlock.getFacing(method_11010());
            class_2586 anyShaftAt = field_11863.method_8321(field_11867.method_10079(facing, 2));
            if (anyShaftAt instanceof PoweredShaftBlockEntity ps && ps.canBePoweredBy(field_11867))
                target = new WeakReference<>(shaft = ps);
        }
        return shaft;
    }

    public FluidTankBlockEntity getTank() {
        FluidTankBlockEntity tank = source.get();
        if (tank == null || tank.method_11015()) {
            if (tank != null)
                source = new WeakReference<>(null);
            class_2350 facing = SteamEngineBlock.getFacing(method_11010());
            class_2586 be = field_11863.method_8321(field_11867.method_10093(facing.method_10153()));
            if (be instanceof FluidTankBlockEntity tankBe)
                source = new WeakReference<>(tank = tankBe);
        }
        if (tank == null)
            return null;
        return tank.getControllerBE();
    }

    public boolean isValid() {
        class_2350 dir = SteamEngineBlock.getConnectedDirection(method_11010()).method_10153();

        class_1937 level = method_10997();
        if (level == null)
            return false;

        return level.method_8320(method_11016().method_10093(dir)).method_27852(AllBlocks.FLUID_TANK);
    }
}
