package com.zurrtum.create.content.logistics.packagePort.frogport;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllShapes;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.equipment.wrench.IWrenchable;
import com.zurrtum.create.content.logistics.packagePort.PackagePortBlockEntity;
import com.zurrtum.create.foundation.advancement.AdvancementBehaviour;
import com.zurrtum.create.foundation.block.IBE;
import com.zurrtum.create.infrastructure.items.ItemInventoryProvider;
import net.minecraft.class_10;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_3726;
import net.minecraft.class_3965;

public class FrogportBlock extends class_2248 implements IBE<FrogportBlockEntity>, IWrenchable, ItemInventoryProvider<FrogportBlockEntity> {

    public FrogportBlock(class_2251 pProperties) {
        super(pProperties);
    }

    @Override
    public class_1263 getInventory(class_1936 world, class_2338 pos, class_2680 state, FrogportBlockEntity blockEntity, class_2350 context) {
        return blockEntity.inventory;
    }

    @Override
    public class_265 method_9530(class_2680 pState, class_1922 pLevel, class_2338 pPos, class_3726 pContext) {
        return AllShapes.PACKAGE_PORT;
    }

    @Override
    public void method_9567(class_1937 pLevel, class_2338 pPos, class_2680 pState, class_1309 pPlacer, class_1799 pStack) {
        super.method_9567(pLevel, pPos, pState, pPlacer, pStack);
        if (pPlacer == null)
            return;
        AdvancementBehaviour.setPlacedBy(pLevel, pPos, pPlacer);
        withBlockEntityDo(
            pLevel, pPos, be -> {
                class_243 diff = VecHelper.getCenterOf(pPos).method_1020(pPlacer.method_73189());
                be.passiveYaw = (float) (class_3532.method_15349(diff.field_1352, diff.field_1350) * class_3532.field_29848);
                be.passiveYaw = Math.round(be.passiveYaw / 11.25f) * 11.25f;
                be.notifyUpdate();
            }
        );
    }

    @Override
    protected class_1269 method_55765(
        class_1799 stack,
        class_2680 state,
        class_1937 level,
        class_2338 pos,
        class_1657 player,
        class_1268 hand,
        class_3965 hitResult
    ) {
        return onBlockEntityUseItemOn(level, pos, be -> be.use(player));
    }

    @Override
    public Class<FrogportBlockEntity> getBlockEntityClass() {
        return FrogportBlockEntity.class;
    }

    @Override
    public class_2591<? extends FrogportBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.PACKAGE_FROGPORT;
    }

    @Override
    protected boolean method_9516(class_2680 state, class_10 pathComputationType) {
        return false;
    }

    @Override
    public boolean method_9498(class_2680 pState) {
        return true;
    }

    @Override
    public int method_9572(class_2680 pState, class_1937 pLevel, class_2338 pPos, class_2350 direction) {
        return getBlockEntityOptional(pLevel, pPos).map(PackagePortBlockEntity::getComparatorOutput).orElse(0);
    }

}
