package com.zurrtum.create.content.logistics.packagePort.postbox;

import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllShapes;
import com.zurrtum.create.content.equipment.wrench.IWrenchable;
import com.zurrtum.create.content.logistics.packagePort.PackagePortBlockEntity;
import com.zurrtum.create.foundation.block.IBE;
import com.zurrtum.create.foundation.block.ProperWaterloggedBlock;
import com.zurrtum.create.infrastructure.items.ItemInventoryProvider;
import org.jetbrains.annotations.NotNull;

import java.util.function.Function;
import net.minecraft.class_10;
import net.minecraft.class_10225;
import net.minecraft.class_1263;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1767;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_3610;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_5819;

public class PostboxBlock extends class_2383 implements IBE<PostboxBlockEntity>, IWrenchable, ProperWaterloggedBlock, ItemInventoryProvider<PostboxBlockEntity> {
    public static MapCodec<PostboxBlock> field_46280 = RecordCodecBuilder.mapCodec(instance -> instance.group(
        method_54096(),
        class_1767.field_41600.fieldOf("color").forGetter(PostboxBlock::getColor)
    ).apply(instance, PostboxBlock::new));

    public static final class_2746 OPEN = class_2741.field_12537;

    protected final class_1767 color;

    public PostboxBlock(class_2251 properties, class_1767 color) {
        super(properties);
        this.color = color;
        method_9590(method_9564().method_11657(OPEN, false).method_11657(WATERLOGGED, false));
    }

    @Override
    public class_1263 getInventory(class_1936 world, class_2338 pos, class_2680 state, PostboxBlockEntity blockEntity, class_2350 context) {
        return blockEntity.inventory;
    }

    public static Function<class_2251, PostboxBlock> dyed(class_1767 color) {
        return settings -> new PostboxBlock(settings, color);
    }

    public static PostboxBlock getColorBlock(class_1767 color) {
        return switch (color) {
            case field_7952 -> AllBlocks.WHITE_POSTBOX;
            case field_7946 -> AllBlocks.ORANGE_POSTBOX;
            case field_7958 -> AllBlocks.MAGENTA_POSTBOX;
            case field_7951 -> AllBlocks.LIGHT_BLUE_POSTBOX;
            case field_7947 -> AllBlocks.YELLOW_POSTBOX;
            case field_7961 -> AllBlocks.LIME_POSTBOX;
            case field_7954 -> AllBlocks.PINK_POSTBOX;
            case field_7944 -> AllBlocks.GRAY_POSTBOX;
            case field_7967 -> AllBlocks.LIGHT_GRAY_POSTBOX;
            case field_7955 -> AllBlocks.CYAN_POSTBOX;
            case field_7945 -> AllBlocks.PURPLE_POSTBOX;
            case field_7966 -> AllBlocks.BLUE_POSTBOX;
            case field_7957 -> AllBlocks.BROWN_POSTBOX;
            case field_7942 -> AllBlocks.GREEN_POSTBOX;
            case field_7964 -> AllBlocks.RED_POSTBOX;
            case field_7963 -> AllBlocks.BLACK_POSTBOX;
        };
    }

    public class_1767 getColor() {
        return color;
    }

    @Override
    public class_2680 method_9605(class_1750 pContext) {
        class_2350 facing = pContext.method_8042().method_10153();
        return withWater(super.method_9605(pContext).method_11657(field_11177, facing), pContext);
    }

    @Override
    public class_3610 method_9545(class_2680 pState) {
        return fluidState(pState);
    }

    @Override
    public class_2680 method_9559(
        class_2680 pState,
        class_4538 pLevel,
        class_10225 tickView,
        class_2338 pPos,
        class_2350 pDirection,
        class_2338 pNeighborPos,
        class_2680 pNeighborState,
        class_5819 random
    ) {
        updateWater(pLevel, tickView, pState, pPos);
        return pState;
    }

    @Override
    public class_265 method_9530(class_2680 pState, class_1922 pLevel, class_2338 pPos, class_3726 pContext) {
        return AllShapes.POSTBOX.get(pState.method_11654(field_11177));
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> pBuilder) {
        super.method_9515(pBuilder.method_11667(field_11177, OPEN, WATERLOGGED));
    }

    @Override
    protected class_1269 method_55766(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_3965 hitResult) {
        return onBlockEntityUse(level, pos, be -> be.use(player));
    }

    @Override
    public Class<PostboxBlockEntity> getBlockEntityClass() {
        return PostboxBlockEntity.class;
    }

    @Override
    public class_2591<? extends PostboxBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.PACKAGE_POSTBOX;
    }

    @Override
    protected boolean method_9516(class_2680 state, class_10 pathComputationType) {
        return false;
    }

    @Override
    public boolean method_9498(class_2680 pState) {
        return true;
    }

    @Override
    public int method_9572(class_2680 pState, class_1937 pLevel, class_2338 pPos, class_2350 direction) {
        return getBlockEntityOptional(pLevel, pPos).map(PackagePortBlockEntity::getComparatorOutput).orElse(0);
    }

    @Override
    protected @NotNull MapCodec<? extends class_2383> method_53969() {
        return field_46280;
    }
}