package com.zurrtum.create.content.logistics.stockTicker;

import com.zurrtum.create.AllMenuTypes;
import com.zurrtum.create.content.logistics.filter.FilterItem;
import com.zurrtum.create.foundation.gui.menu.MenuBase;
import com.zurrtum.create.infrastructure.items.ItemStackHandler;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_5134;
import org.jetbrains.annotations.NotNull;

public class StockKeeperCategoryMenu extends MenuBase<StockTickerBlockEntity> {

    public boolean slotsActive = true;
    public ItemStackHandler proxyInventory;

    public StockKeeperCategoryMenu(int id, class_1661 inv, StockTickerBlockEntity contentHolder) {
        super(AllMenuTypes.STOCK_KEEPER_CATEGORY, id, inv, contentHolder);
    }

    @Override
    protected void initAndReadInventory(StockTickerBlockEntity contentHolder) {
        proxyInventory = new ItemStackHandler(1);
    }

    @Override
    protected void addSlots() {
        method_7621(new InactiveItemHandlerSlot(proxyInventory, 0, 16, 24));
        addPlayerSlots(18, 106);
    }

    @Override
    protected class_1735 createPlayerSlot(class_1661 inventory, int index, int x, int y) {
        return new InactiveSlot(inventory, index, x, y);
    }

    @Override
    protected void saveData(StockTickerBlockEntity contentHolder) {
    }

    @Override
    public boolean method_7597(class_1657 player) {
        return !contentHolder.method_11015() && player.method_73189()
            .method_24802(class_243.method_24953(contentHolder.method_11016()), player.method_45325(class_5134.field_47758) + 4);
    }

    class InactiveSlot extends class_1735 {
        public InactiveSlot(class_1263 inventory, int index, int x, int y) {
            super(inventory, index, x, y);
        }

        @Override
        public boolean method_7682() {
            return slotsActive;
        }
    }

    class InactiveItemHandlerSlot extends class_1735 {
        public InactiveItemHandlerSlot(class_1263 inventory, int index, int x, int y) {
            super(inventory, index, x, y);
        }

        @Override
        public boolean method_7680(@NotNull class_1799 stack) {
            return super.method_7680(stack) && (stack.method_7960() || stack.method_7909() instanceof FilterItem);
        }

        @Override
        public boolean method_7682() {
            return slotsActive;
        }
    }

    @Override
    public class_1799 method_7601(class_1657 pPlayer, int index) {
        class_1735 clickedSlot = method_7611(index);
        if (!clickedSlot.method_7681())
            return class_1799.field_8037;

        class_1799 stack = clickedSlot.method_7677();
        int size = 1;
        boolean success;
        if (index < size) {
            success = !method_7616(stack, size, field_7761.size(), true);
        } else
            success = !method_7616(stack, 0, size, false);

        return success ? class_1799.field_8037 : stack;
    }

}
