package com.zurrtum.create.content.logistics.tunnel;

import com.zurrtum.create.AllBlockEntityTypes;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3965;

public class BrassTunnelBlock extends BeltTunnelBlock {

    public BrassTunnelBlock(class_2251 properties) {
        super(properties);
    }

    @Override
    public class_1263 getInventory(class_1936 world, class_2338 pos, class_2680 state, BeltTunnelBlockEntity blockEntity, class_2350 context) {
        if (blockEntity instanceof BrassTunnelBlockEntity brassTunnelBlockEntity) {
            return brassTunnelBlockEntity.tunnelCapability;
        }
        return super.getInventory(world, pos, state, blockEntity, context);
    }

    @Override
    protected class_1269 method_55766(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_3965 hitResult) {
        return onBlockEntityUse(
            level, pos, be -> {
                if (!(be instanceof BrassTunnelBlockEntity bte))
                    return class_1269.field_5811;
                List<class_1799> stacksOfGroup = bte.grabAllStacksOfGroup(level.method_8608());
                if (stacksOfGroup.isEmpty())
                    return class_1269.field_5811;
                if (level.method_8608())
                    return class_1269.field_5812;
                for (class_1799 itemStack : stacksOfGroup)
                    player.method_31548().method_7398(itemStack.method_7972());
                level.method_8396(null, pos, class_3417.field_15197, class_3419.field_15248, .2f, 1f + level.field_9229.method_43057());
                return class_1269.field_5812;
            }
        );
    }

    @Override
    public class_2591<? extends BeltTunnelBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.BRASS_TUNNEL;
    }
}
