package com.zurrtum.create.content.logistics.vault;

import com.mojang.serialization.MapCodec;
import com.zurrtum.create.AllMountedStorageTypes;
import com.zurrtum.create.api.contraption.storage.item.MountedItemStorageType;
import com.zurrtum.create.api.contraption.storage.item.WrapperMountedItemStorage;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.foundation.codec.CreateCodecs;
import com.zurrtum.create.infrastructure.items.ItemStackHandler;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3499.class_3501;
import org.jetbrains.annotations.Nullable;

public class ItemVaultMountedStorage extends WrapperMountedItemStorage<ItemStackHandler> {
    public static final MapCodec<ItemVaultMountedStorage> CODEC = CreateCodecs.ITEM_STACK_HANDLER.xmap(
        ItemVaultMountedStorage::new,
        storage -> storage.wrapped
    ).fieldOf("value");

    protected ItemVaultMountedStorage(MountedItemStorageType<?> type, ItemStackHandler handler) {
        super(type, handler);
    }

    protected ItemVaultMountedStorage(ItemStackHandler handler) {
        this(AllMountedStorageTypes.VAULT, handler);
    }

    @Override
    public void unmount(class_1937 level, class_2680 state, class_2338 pos, @Nullable class_2586 be) {
        if (be instanceof ItemVaultBlockEntity vault) {
            vault.applyInventoryToBlock(this.wrapped);
        }
    }

    @Override
    public boolean handleInteraction(class_3222 player, Contraption contraption, class_3501 info) {
        // vaults should never be opened.
        return false;
    }

    public static ItemVaultMountedStorage fromVault(ItemVaultBlockEntity vault) {
        // Vault inventories have a world-affecting onContentsChanged, copy to a safe one
        return new ItemVaultMountedStorage(copyToItemStackHandler(vault.getInventoryOfBlock()));
    }
}
