package com.zurrtum.create.content.redstone.link;

import com.zurrtum.create.Create;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.content.equipment.clipboard.ClipboardCloneable;
import com.zurrtum.create.content.redstone.link.RedstoneLinkNetworkHandler.Frequency;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BehaviourType;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.Optional;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;

public class ServerLinkBehaviour extends BlockEntityBehaviour<SmartBlockEntity> implements IRedstoneLinkable, ClipboardCloneable {
    public static final BehaviourType<ServerLinkBehaviour> TYPE = new BehaviourType<>();

    enum Mode {
        TRANSMIT,
        RECEIVE
    }

    public Frequency frequencyFirst;
    public Frequency frequencyLast;
    class_243 textShift;

    public boolean newPosition;
    private Mode mode;
    private IntSupplier transmission;
    private IntConsumer signalCallback;

    protected ServerLinkBehaviour(SmartBlockEntity be) {
        super(be);
        frequencyFirst = Frequency.EMPTY;
        frequencyLast = Frequency.EMPTY;
        textShift = class_243.field_1353;
        newPosition = true;
    }

    public static ServerLinkBehaviour receiver(SmartBlockEntity be, IntConsumer signalCallback) {
        ServerLinkBehaviour behaviour = new ServerLinkBehaviour(be);
        behaviour.signalCallback = signalCallback;
        behaviour.mode = Mode.RECEIVE;
        return behaviour;
    }

    public static ServerLinkBehaviour transmitter(SmartBlockEntity be, IntSupplier transmission) {
        ServerLinkBehaviour behaviour = new ServerLinkBehaviour(be);
        behaviour.transmission = transmission;
        behaviour.mode = Mode.TRANSMIT;
        return behaviour;
    }

    public ServerLinkBehaviour moveText(class_243 shift) {
        textShift = shift;
        return this;
    }

    public void copyItemsFrom(ServerLinkBehaviour behaviour) {
        if (behaviour == null)
            return;
        frequencyFirst = behaviour.frequencyFirst;
        frequencyLast = behaviour.frequencyLast;
    }

    @Override
    public boolean isListening() {
        return mode == Mode.RECEIVE;
    }

    @Override
    public int getTransmittedStrength() {
        return mode == Mode.TRANSMIT ? transmission.getAsInt() : 0;
    }

    @Override
    public void setReceivedStrength(int networkPower) {
        if (!newPosition)
            return;
        signalCallback.accept(networkPower);
    }

    public void notifySignalChange() {
        Create.REDSTONE_LINK_NETWORK_HANDLER.updateNetworkOf(getWorld(), this);
    }

    @Override
    public void initialize() {
        super.initialize();
        if (getWorld().method_8608())
            return;
        getHandler().addToNetwork(getWorld(), this);
        newPosition = true;
    }

    @Override
    public Couple<Frequency> getNetworkKey() {
        return Couple.create(frequencyFirst, frequencyLast);
    }

    @Override
    public void unload() {
        super.unload();
        if (getWorld().method_8608())
            return;
        getHandler().removeFromNetwork(getWorld(), this);
    }

    @Override
    public boolean isSafeNBT() {
        return true;
    }

    @Override
    public void write(class_11372 view, boolean clientPacket) {
        super.write(view, clientPacket);
        view.method_71468("FrequencyFirst", Frequency.CODEC, frequencyFirst);
        view.method_71468("FrequencyLast", Frequency.CODEC, frequencyLast);
        view.method_71468("LastKnownPosition", class_2338.field_25064, blockEntity.method_11016());
    }

    @Override
    public void read(class_11368 view, boolean clientPacket) {
        newPosition = view.method_71426("LastKnownPosition", class_2338.field_25064).map(pos -> !blockEntity.method_11016().equals(pos)).orElse(true);

        super.read(view, clientPacket);
        frequencyFirst = view.method_71426("FrequencyFirst", Frequency.CODEC).orElse(Frequency.EMPTY);
        frequencyLast = view.method_71426("FrequencyLast", Frequency.CODEC).orElse(Frequency.EMPTY);
    }

    public void setFrequency(boolean first, class_1799 stack) {
        stack = stack.method_7972();
        stack.method_7939(1);
        class_1799 toCompare = first ? frequencyFirst.getStack() : frequencyLast.getStack();
        boolean changed = !class_1799.method_31577(stack, toCompare);

        if (changed)
            getHandler().removeFromNetwork(getWorld(), this);

        if (first)
            frequencyFirst = Frequency.of(stack);
        else
            frequencyLast = Frequency.of(stack);

        if (!changed)
            return;

        blockEntity.sendData();
        getHandler().addToNetwork(getWorld(), this);
    }

    @Override
    public BehaviourType<?> getType() {
        return TYPE;
    }

    private RedstoneLinkNetworkHandler getHandler() {
        return Create.REDSTONE_LINK_NETWORK_HANDLER;
    }

    @Override
    public boolean isAlive() {
        class_1937 level = getWorld();
        class_2338 pos = getPos();
        if (blockEntity.isChunkUnloaded())
            return false;
        if (blockEntity.method_11015())
            return false;
        if (!level.method_8477(pos))
            return false;
        return level.method_8321(pos) == blockEntity;
    }

    @Override
    public class_2338 getLocation() {
        return getPos();
    }

    @Override
    public String getClipboardKey() {
        return "Frequencies";
    }

    @Override
    public boolean writeToClipboard(class_11372 view, class_2350 side) {
        view.method_71468("First", class_1799.field_49266, frequencyFirst.getStack());
        view.method_71468("Last", class_1799.field_49266, frequencyLast.getStack());
        return true;
    }

    @Override
    public boolean readFromClipboard(class_11368 view, class_1657 player, class_2350 side, boolean simulate) {
        Optional<class_1799> first = view.method_71426("First", class_1799.field_49266);
        if (first.isEmpty()) {
            return false;
        }
        Optional<class_1799> last = view.method_71426("Last", class_1799.field_49266);
        if (last.isEmpty()) {
            return false;
        }
        if (simulate)
            return true;
        setFrequency(true, first.get());
        setFrequency(false, last.get());
        return true;
    }
}
