package com.zurrtum.create.content.redstone.nixieTube;

import com.zurrtum.create.*;
import com.zurrtum.create.api.schematic.requirement.SpecialBlockItemRequirement;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.compat.Mods;
import com.zurrtum.create.content.equipment.wrench.IWrenchable;
import com.zurrtum.create.content.schematics.requirement.ItemRequirement;
import com.zurrtum.create.content.schematics.requirement.ItemRequirement.ItemUseType;
import com.zurrtum.create.foundation.block.IBE;
import com.zurrtum.create.foundation.block.RedStoneConnectBlock;
import com.zurrtum.create.infrastructure.component.ClipboardEntry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.class_10;
import net.minecraft.class_10225;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689.class_2690;
import net.minecraft.class_3218;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_5244;
import net.minecraft.class_5819;
import net.minecraft.class_9334;
import net.minecraft.class_9904;

import static net.minecraft.class_2741.field_12508;

public class NixieTubeBlock extends DoubleFaceAttachedBlock implements IBE<NixieTubeBlockEntity>, IWrenchable, class_3737, SpecialBlockItemRequirement, RedStoneConnectBlock {
    protected final class_1767 color;

    public NixieTubeBlock(class_2251 properties, class_1767 color) {
        super(properties);
        this.color = color;
        method_9590(method_9564().method_11657(FACE, DoubleAttachFace.FLOOR).method_11657(field_12508, false));
    }

    public NixieTubeBlock(class_2251 properties) {
        this(properties, class_1767.field_7946);
    }

    public static Function<class_2251, NixieTubeBlock> dyed(class_1767 color) {
        return properties -> new NixieTubeBlock(properties, color);
    }

    @Override
    protected class_1269 method_55765(
        class_1799 stack,
        class_2680 state,
        class_1937 level,
        class_2338 pos,
        class_1657 player,
        class_1268 hand,
        class_3965 hitResult
    ) {
        if (player.method_5715())
            return class_1269.field_52423;

        NixieTubeBlockEntity nixie = getBlockEntity(level, pos);

        if (nixie == null) {
            return class_1269.field_52423;
        }
        // Refuse interaction if nixie tube is in a computer-controlled row
        if (isInComputerControlledRow(level, pos)) {
            return class_1269.field_52423;
        }
        if (stack.method_7960()) {
            if (nixie.reactsToRedstone())
                return class_1269.field_52423;
            nixie.clearCustomText();
            updateDisplayedRedstoneValue(state, level, pos);
            return class_1269.field_5812;
        }

        boolean display = stack.method_7909() == class_1802.field_8448 && stack.method_57826(class_9334.field_49631) || stack.method_31574(AllItems.CLIPBOARD);
        class_1767 dye = AllItemTags.getDyeColor(stack);

        if (!display && dye == null)
            return class_1269.field_52423;

        class_2561 component;

        if (stack.method_31574(AllItems.CLIPBOARD)) {
            List<ClipboardEntry> entries = ClipboardEntry.getLastViewedEntries(stack);
            component = entries.isEmpty() ? stack.method_58695(class_9334.field_49631, class_5244.field_39003) : entries.getFirst().text;
        } else {
            component = stack.method_58695(class_9334.field_49631, class_5244.field_39003);
        }

        if (level.method_8608())
            return class_1269.field_5812;

        // Skip computer check in this walk since it was already performed at the start.
        walkNixies(
            level, pos, true, (currentPos, rowPosition) -> {
                if (display)
                    withBlockEntityDo(level, currentPos, be -> be.displayCustomText(component, rowPosition));
                if (dye != null)
                    level.method_8501(currentPos, withColor(state, dye));
            }
        );

        return class_1269.field_5812;
    }

    public static class_2350 getLeftNixieDirection(@NotNull class_2680 state) {
        class_2350 left = state.method_11654(field_11177).method_10153();

        if (state.method_11654(FACE) == DoubleAttachFace.WALL)
            left = class_2350.field_11036;
        if (state.method_11654(FACE) == DoubleAttachFace.WALL_REVERSED)
            left = class_2350.field_11033;
        return left;
    }

    public static class_2350 getRightNixieDirection(@NotNull class_2680 state) {
        return getLeftNixieDirection(state).method_10153();
    }

    public static boolean isInComputerControlledRow(@NotNull class_1936 world, @NotNull class_2338 pos) {
        return Mods.COMPUTERCRAFT.isLoaded() && !walkNixies(world, pos, false, null);
    }

    /**
     * Walk down a nixie tube row and execute a callback on each tube in said row.
     *
     * @param world                   The world the tubes are in.
     * @param start                   Start position for the walk.
     * @param allowComputerControlled Allow or disallow running callbacks if the row is computer-controlled.
     * @param callback                Callback to run for each tube.
     * @return True if the row was walked, false if the walk was aborted because it is computer-controlled.
     */
    public static boolean walkNixies(
        @NotNull class_1936 world,
        @NotNull class_2338 start,
        boolean allowComputerControlled,
        @Nullable BiConsumer<class_2338, Integer> callback
    ) {
        class_2680 state = world.method_8320(start);
        if (!(state.method_26204() instanceof NixieTubeBlock))
            return false;

        // If ComputerCraft is not installed, ignore allowComputerControlled since
        // nixies can't be computer-controlled
        if (!Mods.COMPUTERCRAFT.isLoaded())
            allowComputerControlled = true;

        class_2338 currentPos = start;
        class_2350 left = getLeftNixieDirection(state);
        class_2350 right = left.method_10153();

        while (true) {
            class_2338 nextPos = currentPos.method_10093(left);
            if (!areNixieBlocksEqual(world.method_8320(nextPos), state))
                break;
            // If computer-controlled nixie walking is disallowed, presence of any (same-color)
            // controlled nixies aborts the entire nixie walk.
            //TODO
            //            if (!allowComputerControlled && world.getBlockEntity(nextPos) instanceof NixieTubeBlockEntity ntbe &&
            //                ntbe.computerBehaviour.hasAttachedComputer()) {
            //                return false;
            //            }
            currentPos = nextPos;
        }

        // As explained above, a controlled nixie in the row aborts the walk if they are disallowed,
        // and that includes those down the chain too.
        if (!allowComputerControlled) {
            // Check the start block itself
            //TODO
            //            if (world.getBlockEntity(start) instanceof NixieTubeBlockEntity ntbe && ntbe.computerBehaviour.hasAttachedComputer()) {
            //                return false;
            //            }
            class_2338 leftmostPos = currentPos;
            // No need to iterate over the nixies to the left again
            currentPos = start;
            while (true) {
                class_2338 nextPos = currentPos.method_10093(right);
                if (!areNixieBlocksEqual(world.method_8320(nextPos), state))
                    break;
                //TODO
                //                if (world.getBlockEntity(nextPos) instanceof NixieTubeBlockEntity ntbe && ntbe.computerBehaviour.hasAttachedComputer()) {
                //                    return false;
                //                }
                currentPos = nextPos;
            }
            currentPos = leftmostPos;
        }

        int index = 0;

        while (true) {
            final int rowPosition = index;
            if (callback != null)
                callback.accept(currentPos, rowPosition);
            class_2338 nextPos = currentPos.method_10093(right);
            if (!areNixieBlocksEqual(world.method_8320(nextPos), state))
                break;
            currentPos = nextPos;
            index++;
        }

        return true;
    }

    @Override
    protected void method_9515(class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder.method_11667(FACE, field_11177, field_12508));
    }

    @Override
    protected class_1799 method_9574(class_4538 world, class_2338 pos, class_2680 state, boolean includeData) {
        return AllItems.ORANGE_NIXIE_TUBE.method_7854();
    }

    @Override
    public ItemRequirement getRequiredItems(class_2680 state, class_2586 be) {
        return new ItemRequirement(ItemUseType.CONSUME, AllItems.ORANGE_NIXIE_TUBE);
    }

    @Override
    public class_265 method_9530(class_2680 pState, class_1922 pLevel, class_2338 pPos, class_3726 pContext) {
        class_2350 facing = pState.method_11654(field_11177);
        return switch (pState.method_11654(FACE)) {
            case CEILING -> AllShapes.NIXIE_TUBE_CEILING.get(facing.method_10170().method_10166());
            case FLOOR -> AllShapes.NIXIE_TUBE.get(facing.method_10170().method_10166());
            default -> AllShapes.NIXIE_TUBE_WALL.get(facing);
        };
    }

    @Override
    public class_3610 method_9545(class_2680 state) {
        return state.method_11654(field_12508) ? class_3612.field_15910.method_15729(false) : class_3612.field_15906.method_15785();
    }

    @Override
    public class_2680 method_9559(
        class_2680 state,
        class_4538 world,
        class_10225 tickView,
        class_2338 pos,
        class_2350 direction,
        class_2338 neighbourPos,
        class_2680 neighbourState,
        class_5819 random
    ) {
        if (state.method_11654(field_12508))
            tickView.method_64312(pos, class_3612.field_15910, class_3612.field_15910.method_15789(world));
        return state;
    }

    @Override
    public class_2680 method_9605(class_1750 context) {
        class_2680 state = super.method_9605(context);
        if (state == null)
            return null;
        if (state.method_11654(FACE) != DoubleAttachFace.WALL && state.method_11654(FACE) != DoubleAttachFace.WALL_REVERSED)
            state = state.method_11657(field_11177, state.method_11654(field_11177).method_10170());
        return state.method_11657(field_12508, context.method_8045().method_8316(context.method_8037()).method_15772() == class_3612.field_15910);
    }

    @Override
    public void method_9612(
        class_2680 state,
        class_1937 level,
        class_2338 pos,
        class_2248 block,
        @Nullable class_9904 wireOrientation,
        boolean isMoving
    ) {
        if (level.method_8608())
            return;
        if (!level.method_8397().method_8677(pos, this))
            level.method_64310(pos, this, 1);
    }

    @Override
    public void method_9588(class_2680 state, class_3218 worldIn, class_2338 pos, class_5819 r) {
        updateDisplayedRedstoneValue(state, worldIn, pos);
    }

    @Override
    public void method_9615(class_2680 state, class_1937 worldIn, class_2338 pos, class_2680 oldState, boolean isMoving) {
        if (state.method_26204() == oldState.method_26204() || isMoving || oldState.method_26204() instanceof NixieTubeBlock)
            return;
        if (Mods.COMPUTERCRAFT.isLoaded() && isInComputerControlledRow(worldIn, pos)) {
            // The nixie tube has been placed in a computer-controlled row.
            walkNixies(
                worldIn, pos, true, (currentPos, rowPosition) -> {
                    if (worldIn.method_8321(currentPos) instanceof NixieTubeBlockEntity ntbe)
                        ntbe.displayEmptyText(rowPosition);
                }
            );
            return;
        }
        updateDisplayedRedstoneValue(state, worldIn, pos);
    }

    public static void updateDisplayedRedstoneValue(NixieTubeBlockEntity be, class_2680 state, boolean force) {
        if (be.method_10997() == null || be.method_10997().method_8608())
            return;
        if (be.reactsToRedstone() || force)
            be.updateRedstoneStrength(getPower(be.method_10997(), state, be.method_11016()));
    }

    private void updateDisplayedRedstoneValue(class_2680 state, class_1937 level, class_2338 pos) {
        if (level.method_8608())
            return;
        withBlockEntityDo(level, pos, be -> NixieTubeBlock.updateDisplayedRedstoneValue(be, state, false));
    }

    static boolean isValidBlock(class_1922 world, class_2338 pos, boolean above) {
        class_2680 state = world.method_8320(pos.method_10086(above ? 1 : -1));
        return !state.method_26218(world, pos).method_1110();
    }

    private static int getPower(class_1937 worldIn, class_2680 state, class_2338 pos) {
        int power = 0;
        for (class_2350 direction : Iterate.directions)
            power = Math.max(worldIn.method_49808(pos.method_10093(direction), direction), power);
        for (class_2350 direction : Iterate.directions) {
            if (state.method_11654(field_11177).method_10153() != direction)
                power = Math.max(worldIn.method_49808(pos.method_10093(direction), class_2350.field_11036), power);
        }
        return power;
    }

    @Override
    protected boolean method_9516(class_2680 state, class_10 pathComputationType) {
        return false;
    }

    @Override
    public boolean canConnectRedstone(class_2680 state, @Nullable class_2350 side) {
        return side != null;
    }

    @Override
    public Class<NixieTubeBlockEntity> getBlockEntityClass() {
        return NixieTubeBlockEntity.class;
    }

    @Override
    public class_2591<? extends NixieTubeBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.NIXIE_TUBE;
    }

    public class_1767 getColor() {
        return color;
    }

    public static NixieTubeBlock getColorBlock(class_1767 color) {
        return switch (color) {
            case field_7952 -> AllBlocks.WHITE_NIXIE_TUBE;
            case field_7946 -> AllBlocks.ORANGE_NIXIE_TUBE;
            case field_7958 -> AllBlocks.MAGENTA_NIXIE_TUBE;
            case field_7951 -> AllBlocks.LIGHT_BLUE_NIXIE_TUBE;
            case field_7947 -> AllBlocks.YELLOW_NIXIE_TUBE;
            case field_7961 -> AllBlocks.LIME_NIXIE_TUBE;
            case field_7954 -> AllBlocks.PINK_NIXIE_TUBE;
            case field_7944 -> AllBlocks.GRAY_NIXIE_TUBE;
            case field_7967 -> AllBlocks.LIGHT_GRAY_NIXIE_TUBE;
            case field_7955 -> AllBlocks.CYAN_NIXIE_TUBE;
            case field_7945 -> AllBlocks.PURPLE_NIXIE_TUBE;
            case field_7966 -> AllBlocks.BLUE_NIXIE_TUBE;
            case field_7957 -> AllBlocks.BROWN_NIXIE_TUBE;
            case field_7942 -> AllBlocks.GREEN_NIXIE_TUBE;
            case field_7964 -> AllBlocks.RED_NIXIE_TUBE;
            case field_7963 -> AllBlocks.BLACK_NIXIE_TUBE;
        };
    }

    public static boolean areNixieBlocksEqual(class_2680 blockState, class_2680 otherState) {
        if (!(blockState.method_26204() instanceof NixieTubeBlock))
            return false;
        if (!(otherState.method_26204() instanceof NixieTubeBlock))
            return false;
        return withColor(blockState, class_1767.field_7952) == withColor(otherState, class_1767.field_7952);
    }

    public static class_2680 withColor(class_2680 state, class_1767 color) {
        return (color == class_1767.field_7946 ? AllBlocks.ORANGE_NIXIE_TUBE : getColorBlock(color)).method_9564().method_11657(field_11177, state.method_11654(field_11177))
            .method_11657(field_12508, state.method_11654(field_12508)).method_11657(FACE, state.method_11654(FACE));
    }

    public static class_1767 colorOf(class_2680 blockState) {
        return blockState.method_26204() instanceof NixieTubeBlock ? ((NixieTubeBlock) blockState.method_26204()).color : class_1767.field_7946;
    }

    public static class_2350 getFacing(class_2680 sideState) {
        return getConnectedDirection(sideState);
    }
}
