package com.zurrtum.create.content.schematics.cannon;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.foundation.codec.CreateCodecs;
import com.zurrtum.create.infrastructure.items.ItemInventory;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2371;

public class SchematicannonInventory implements ItemInventory {
    private final SchematicannonBlockEntity blockEntity;
    private final class_2371<class_1799> stacks;

    public SchematicannonInventory(SchematicannonBlockEntity blockEntity) {
        this.blockEntity = blockEntity;
        this.stacks = class_2371.method_10213(5, class_1799.field_8037);
    }

    @Override
    public boolean method_5437(int slot, class_1799 stack) {
        return switch (slot) {
            // Blueprint Slot
            case 0 -> stack.method_31574(AllItems.SCHEMATIC);
            // Blueprint output
            case 1 -> false;
            // Book input
            case 2 -> stack.method_31574(AllItems.CLIPBOARD) || stack.method_31574(class_1802.field_8529) || stack.method_31574(class_1802.field_8360);
            // Material List output
            case 3 -> false;
            // Gunpowder
            case 4 -> stack.method_31574(class_1802.field_8054);
            default -> true;
        };
    }

    @Override
    public int method_5439() {
        return 5;
    }

    @Override
    public class_1799 method_5438(int slot) {
        if (slot >= 5) {
            return class_1799.field_8037;
        }
        return stacks.get(slot);
    }

    @Override
    public void method_5447(int slot, class_1799 stack) {
        if (slot >= 5) {
            return;
        }
        stacks.set(slot, stack);
    }

    @Override
    public void method_5431() {
        blockEntity.method_5431();
    }

    public void read(class_11368 view) {
        view.method_71426("Inventory", CreateCodecs.ITEM_LIST_CODEC).ifPresentOrElse(
            list -> {
                for (int i = 0, size = list.size(); i < size; i++) {
                    stacks.set(i, list.get(i));
                }
            }, stacks::clear
        );
    }

    public void write(class_11372 view) {
        view.method_71468("Inventory", CreateCodecs.ITEM_LIST_CODEC, stacks);
    }
}
