package com.zurrtum.create.content.trains.display;

import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import net.minecraft.class_8824;

public class FlapDisplaySection {
    static final Map<String, String[]> LOADED_FLAP_CYCLES = new HashMap<>();

    public static final float MONOSPACE = 7;
    public static final float WIDE_MONOSPACE = 9;

    float size;
    boolean singleFlap;
    public boolean hasGap;
    boolean rightAligned;
    public boolean wideFlaps;
    boolean sendTransition;
    String cycle;
    class_2561 component;

    // Client
    public String[] cyclingOptions;
    public boolean[] spinning;
    public int spinningTicks;
    public String text;

    public FlapDisplaySection(float width, String cycle, boolean singleFlap, boolean hasGap) {
        this.size = width;
        this.cycle = cycle;
        this.hasGap = hasGap;
        this.singleFlap = singleFlap;
        this.spinning = new boolean[singleFlap ? 1 : Math.max(0, (int) (width / FlapDisplaySection.MONOSPACE))];
        this.text = Strings.repeat(" ", spinning.length);
        this.component = null;
    }

    public FlapDisplaySection rightAligned() {
        rightAligned = true;
        return this;
    }

    public FlapDisplaySection wideFlaps() {
        wideFlaps = true;
        return this;
    }

    public void setText(class_2561 component) {
        this.component = component;
        sendTransition = true;
    }

    public void refresh(boolean transition) {
        if (component == null)
            return;

        String newText = component.getString();

        if (!singleFlap) {
            if (rightAligned)
                newText = newText.trim();
            newText = newText.toUpperCase(Locale.ROOT);
            newText = newText.substring(0, Math.min(spinning.length, newText.length()));
            String whitespace = Strings.repeat(" ", spinning.length - newText.length());
            newText = rightAligned ? whitespace + newText : newText + whitespace;
            if (!text.isEmpty())
                for (int i = 0; i < spinning.length; i++)
                    spinning[i] |= transition && text.charAt(i) != newText.charAt(i);
        } else if (!text.isEmpty())
            spinning[0] |= transition && !newText.equals(text);

        text = newText;
        spinningTicks = 0;
    }

    public int tick(boolean instant, class_5819 random) {
        if (cyclingOptions == null)
            return 0;
        int max = Math.max(4, (int) (cyclingOptions.length * 1.75f));
        if (spinningTicks > max)
            return 0;

        spinningTicks++;
        if (spinningTicks <= max && spinningTicks < 2)
            return spinningTicks == 1 ? 0 : spinning.length;

        int spinningFlaps = 0;
        for (int i = 0; i < spinning.length; i++) {
            int increasingChance = class_3532.method_15340(8 - spinningTicks, 1, 10);
            boolean continueSpin = !instant && random.method_43048(increasingChance * max / 4) != 0;
            continueSpin &= max > 5 || spinningTicks < 2;
            spinning[i] &= continueSpin;

            if (i > 0 && random.method_43048(3) > 0)
                spinning[i - 1] &= continueSpin;
            if (i < spinning.length - 1 && random.method_43048(3) > 0)
                spinning[i + 1] &= continueSpin;
            if (spinningTicks > max)
                spinning[i] = false;

            if (spinning[i])
                spinningFlaps++;
        }

        return spinningFlaps;
    }

    public float getSize() {
        return size;
    }

    public void write(class_11372 view) {
        view.method_71464("Width", size);
        view.method_71469("Cycle", cycle);
        if (rightAligned)
            view.method_71472("RightAligned", true);
        if (singleFlap)
            view.method_71472("SingleFlap", true);
        if (hasGap)
            view.method_71472("Gap", true);
        if (wideFlaps)
            view.method_71472("Wide", true);
        if (component != null)
            view.method_71468("Text", class_8824.field_46597, component);
        if (sendTransition)
            view.method_71472("Transition", true);
        sendTransition = false;
    }

    public static FlapDisplaySection load(class_11368 view) {
        float width = view.method_71423("Width", 0);
        String cycle = view.method_71428("Cycle", "");
        boolean singleFlap = view.method_71433("SingleFlap", false);
        boolean hasGap = view.method_71433("Gap", false);

        FlapDisplaySection section = new FlapDisplaySection(width, cycle, singleFlap, hasGap);
        section.cyclingOptions = getFlapCycle(cycle);
        section.rightAligned = view.method_71433("RightAligned", false);
        section.wideFlaps = view.method_71433("Wide", false);

        view.method_71426("Text", class_8824.field_46597).ifPresent(text -> {
            section.component = text;
            section.refresh(view.method_71433("Transition", false));
        });
        return section;
    }

    public void update(class_11368 view) {
        view.method_71426("Text", class_8824.field_46597).ifPresent(text -> component = text);
        if (cyclingOptions == null)
            cyclingOptions = getFlapCycle(cycle);
        refresh(view.method_71433("Transition", false));
    }

    public boolean renderCharsIndividually() {
        return !singleFlap;
    }

    public class_2561 getText() {
        return component;
    }

    public static String[] getFlapCycle(String key) {
        return LOADED_FLAP_CYCLES.computeIfAbsent(key, k -> class_2561.method_43471("create.flap_display.cycles." + key).getString().split(";"));
    }

}
