package com.zurrtum.create.content.trains.entity;

import com.mojang.serialization.*;
import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.AllSynchedDatas;
import com.zurrtum.create.Create;
import com.zurrtum.create.catnip.codecs.stream.CatnipStreamCodecBuilders;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.contraptions.minecart.TrainCargoManager;
import com.zurrtum.create.content.trains.entity.TravellingPoint.IEdgePointListener;
import com.zurrtum.create.content.trains.entity.TravellingPoint.ITrackSelector;
import com.zurrtum.create.content.trains.graph.DimensionPalette;
import com.zurrtum.create.content.trains.graph.TrackGraph;
import com.zurrtum.create.content.trains.graph.TrackNodeLocation;
import net.minecraft.class_11352;
import net.minecraft.class_11362;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4844;
import net.minecraft.class_5321;
import net.minecraft.class_8942;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.jetbrains.annotations.Nullable;

import java.lang.ref.WeakReference;
import java.util.*;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;

public class Carriage {
    public static final class_9139<class_9129, Carriage> STREAM_CODEC = class_9139.method_56436(
        CarriageBogey.STREAM_CODEC,
        carriage -> carriage.bogeys.getFirst(),
        CatnipStreamCodecBuilders.nullable(CarriageBogey.STREAM_CODEC),
        carriage -> carriage.bogeys.getSecond(),
        class_9135.field_48550,
        carriage -> carriage.bogeySpacing,
        Carriage::new
    );

    public static final AtomicInteger netIdGenerator = new AtomicInteger();

    public Train train;
    public int id;
    public boolean blocked;
    public boolean stalled;
    public Couple<Boolean> presentConductors;

    public int bogeySpacing;
    public Couple<CarriageBogey> bogeys;
    public TrainCargoManager storage;

    class_2487 serialisedEntity;
    Map<Integer, class_2487> serialisedPassengers;

    private Map<class_5321<class_1937>, DimensionalCarriageEntity> entities;

    static final int FIRST = 0, MIDDLE = 1, LAST = 2, BOTH = 3;

    public Carriage(CarriageBogey bogey1, @Nullable CarriageBogey bogey2, int bogeySpacing) {
        this.bogeySpacing = bogeySpacing;
        this.bogeys = Couple.create(bogey1, bogey2);
        this.id = netIdGenerator.incrementAndGet();
        this.serialisedEntity = new class_2487();
        this.presentConductors = Couple.create(false, false);
        this.serialisedPassengers = new HashMap<>();
        this.entities = new HashMap<>();
        this.storage = new TrainCargoManager();

        bogey1.setLeading();
        bogey1.carriage = this;
        if (bogey2 != null)
            bogey2.carriage = this;
    }

    public boolean isOnIncompatibleTrack() {
        return leadingBogey().type.isOnIncompatibleTrack(this, true) || trailingBogey().type.isOnIncompatibleTrack(this, false);
    }

    public void setTrain(Train train) {
        this.train = train;
    }

    public boolean presentInMultipleDimensions() {
        return entities.size() > 1;
    }

    public List<class_5321<class_1937>> getPresentDimensions() {
        return entities.keySet().stream().distinct().toList();
    }

    public Optional<class_2338> getPositionInDimension(class_5321<class_1937> dimension) {
        return Optional.ofNullable(entities.get(dimension)).map(carriage -> class_2338.method_49638(carriage.positionAnchor));
    }

    public void setContraption(class_1937 level, CarriageContraption contraption) {
        this.storage = null;
        CarriageContraptionEntity entity = CarriageContraptionEntity.create(level, contraption);
        entity.setCarriage(this);
        contraption.startMoving(level);
        contraption.onEntityInitialize(level, entity);
        updateContraptionAnchors();

        DimensionalCarriageEntity dimensional = getDimensional(level);
        dimensional.alignEntity(entity);
        dimensional.removeAndSaveEntity(entity, true);
    }

    public DimensionalCarriageEntity getDimensional(class_1937 level) {
        return getDimensional(level.method_27983());
    }

    public DimensionalCarriageEntity getDimensional(class_5321<class_1937> dimension) {
        return entities.computeIfAbsent(dimension, $ -> new DimensionalCarriageEntity());
    }

    @Nullable
    public DimensionalCarriageEntity getDimensionalIfPresent(class_5321<class_1937> dimension) {
        return entities.get(dimension);
    }

    public double travel(
        class_1937 level,
        TrackGraph graph,
        double distance,
        TravellingPoint toFollowForward,
        TravellingPoint toFollowBackward,
        int type
    ) {

        Function<TravellingPoint, ITrackSelector> forwardControl = toFollowForward == null ? train.navigation::control : mp -> mp.follow(
            toFollowForward);
        Function<TravellingPoint, ITrackSelector> backwardControl = toFollowBackward == null ? train.navigation::control : mp -> mp.follow(
            toFollowBackward);

        boolean onTwoBogeys = isOnTwoBogeys();
        double stress = train.derailed ? 0 : onTwoBogeys ? bogeySpacing - getAnchorDiff() : 0;
        blocked = false;

        MutableDouble distanceMoved = new MutableDouble(distance);
        boolean iterateFromBack = distance < 0;

        for (boolean firstBogey : Iterate.trueAndFalse) {
            if (!firstBogey && !onTwoBogeys)
                continue;

            boolean actuallyFirstBogey = !onTwoBogeys || (firstBogey ^ iterateFromBack);
            CarriageBogey bogey = bogeys.get(actuallyFirstBogey);
            double bogeyCorrection = stress * (actuallyFirstBogey ? 0.5d : -0.5d);
            double bogeyStress = bogey.getStress();

            for (boolean firstWheel : Iterate.trueAndFalse) {
                boolean actuallyFirstWheel = firstWheel ^ iterateFromBack;
                TravellingPoint point = bogey.points.get(actuallyFirstWheel);
                TravellingPoint prevPoint = !actuallyFirstWheel ? bogey.points.getFirst() : !actuallyFirstBogey && onTwoBogeys ? bogeys.getFirst().points.getSecond() : null;
                TravellingPoint nextPoint = actuallyFirstWheel ? bogey.points.getSecond() : actuallyFirstBogey && onTwoBogeys ? bogeys.getSecond().points.getFirst() : null;

                double correction = bogeyStress * (actuallyFirstWheel ? 0.5d : -0.5d);
                double toMove = distanceMoved.getValue();

                ITrackSelector frontTrackSelector = prevPoint == null ? forwardControl.apply(point) : point.follow(prevPoint);
                ITrackSelector backTrackSelector = nextPoint == null ? backwardControl.apply(point) : point.follow(nextPoint);

                boolean atFront = (type == FIRST || type == BOTH) && actuallyFirstWheel && actuallyFirstBogey;
                boolean atBack = (type == LAST || type == BOTH) && !actuallyFirstWheel && (!actuallyFirstBogey || !onTwoBogeys);

                IEdgePointListener frontListener = train.frontSignalListener();
                IEdgePointListener backListener = train.backSignalListener();
                IEdgePointListener passiveListener = point.ignoreEdgePoints();

                toMove += correction + bogeyCorrection;

                ITrackSelector trackSelector = toMove > 0 ? frontTrackSelector : backTrackSelector;
                IEdgePointListener signalListener = toMove > 0 ? atFront ? frontListener : atBack ? backListener : passiveListener : atFront ? backListener : atBack ? frontListener : passiveListener;

                double moved = point.travel(
                    graph, toMove, trackSelector, signalListener, point.ignoreTurns(), c -> {
                        for (DimensionalCarriageEntity dce : entities.values())
                            if (c.either(tnl -> tnl.equalsIgnoreDim(dce.pivot)))
                                return false;
                        if (entities.size() > 1) {
                            train.status.doublePortal();
                            return true;
                        }
                        return false;
                    }
                );

                blocked |= point.blocked;

                distanceMoved.setValue(moved);
            }
        }

        updateContraptionAnchors();
        manageEntities(level);
        return distanceMoved.getValue();
    }

    public double getAnchorDiff() {
        double diff = 0;
        int entries = 0;

        TravellingPoint leadingPoint = getLeadingPoint();
        TravellingPoint trailingPoint = getTrailingPoint();
        if (leadingPoint.node1 != null && trailingPoint.node1 != null)
            if (!leadingPoint.node1.getLocation().dimension.equals(trailingPoint.node1.getLocation().dimension))
                return bogeySpacing;

        for (DimensionalCarriageEntity dce : entities.values())
            if (dce.leadingAnchor() != null && dce.trailingAnchor() != null) {
                entries++;
                diff += dce.leadingAnchor().method_1022(dce.trailingAnchor());
            }

        if (entries == 0)
            return bogeySpacing;
        return diff / entries;
    }

    public void updateConductors() {
        if (anyAvailableEntity() == null || entities.size() > 1 || serialisedPassengers.size() > 0)
            return;
        presentConductors.replace($ -> false);
        for (DimensionalCarriageEntity dimensionalCarriageEntity : entities.values()) {
            CarriageContraptionEntity entity = dimensionalCarriageEntity.entity.get();
            if (entity != null && entity.method_5805())
                presentConductors.replaceWithParams((current, checked) -> current || checked, entity.checkConductors());
        }
    }

    private Set<class_5321<class_1937>> currentlyTraversedDimensions = new HashSet<>();

    public void manageEntities(class_1937 level) {
        currentlyTraversedDimensions.clear();

        bogeys.forEach(cb -> {
            if (cb == null)
                return;
            cb.points.forEach(tp -> {
                if (tp.node1 == null)
                    return;
                currentlyTraversedDimensions.add(tp.node1.getLocation().dimension);
            });
        });

        for (Iterator<Map.Entry<class_5321<class_1937>, DimensionalCarriageEntity>> iterator = entities.entrySet().iterator(); iterator.hasNext(); ) {
            Map.Entry<class_5321<class_1937>, DimensionalCarriageEntity> entry = iterator.next();

            boolean discard = !currentlyTraversedDimensions.isEmpty() && !currentlyTraversedDimensions.contains(entry.getKey());

            MinecraftServer server = level.method_8503();
            if (server == null)
                continue;
            class_3218 currentLevel = server.method_3847(entry.getKey());
            if (currentLevel == null)
                continue;

            DimensionalCarriageEntity dimensionalCarriageEntity = entry.getValue();
            CarriageContraptionEntity entity = dimensionalCarriageEntity.entity.get();

            if (entity == null) {
                if (discard)
                    iterator.remove();
                else if (dimensionalCarriageEntity.positionAnchor != null && CarriageEntityHandler.isActiveChunk(
                    currentLevel,
                    class_2338.method_49638(dimensionalCarriageEntity.positionAnchor)
                ))
                    dimensionalCarriageEntity.createEntity(currentLevel, anyAvailableEntity() == null);

            } else {
                if (discard) {
                    discard = dimensionalCarriageEntity.discardTicks > 3;
                    dimensionalCarriageEntity.discardTicks++;
                } else
                    dimensionalCarriageEntity.discardTicks = 0;

                CarriageEntityHandler.validateCarriageEntity(entity);
                if (!entity.method_5805() || entity.leftTickingChunks || discard) {
                    dimensionalCarriageEntity.removeAndSaveEntity(entity, discard);
                    if (discard)
                        iterator.remove();
                    continue;
                }
            }

            entity = dimensionalCarriageEntity.entity.get();
            if (entity != null && dimensionalCarriageEntity.positionAnchor != null) {
                dimensionalCarriageEntity.alignEntity(entity);
                entity.syncCarriage();
            }
        }

    }

    public void updateContraptionAnchors() {
        CarriageBogey leadingBogey = leadingBogey();
        if (leadingBogey.points.either(t -> t.edge == null))
            return;
        CarriageBogey trailingBogey = trailingBogey();
        if (trailingBogey.points.either(t -> t.edge == null))
            return;

        class_5321<class_1937> leadingBogeyDim = leadingBogey.getDimension();
        class_5321<class_1937> trailingBogeyDim = trailingBogey.getDimension();
        double leadingWheelSpacing = leadingBogey.type.getWheelPointSpacing();
        double trailingWheelSpacing = trailingBogey.type.getWheelPointSpacing();

        boolean leadingUpsideDown = leadingBogey.isUpsideDown();
        boolean trailingUpsideDown = trailingBogey.isUpsideDown();

        for (boolean leading : Iterate.trueAndFalse) {
            TravellingPoint point = leading ? getLeadingPoint() : getTrailingPoint();
            TravellingPoint otherPoint = !leading ? getLeadingPoint() : getTrailingPoint();
            class_5321<class_1937> dimension = point.node1.getLocation().dimension;
            class_5321<class_1937> otherDimension = otherPoint.node1.getLocation().dimension;

            if (dimension.equals(otherDimension) && leading) {
                getDimensional(dimension).discardPivot();
                continue;
            }

            DimensionalCarriageEntity dce = getDimensional(dimension);

            dce.positionAnchor = dimension.equals(leadingBogeyDim) ? leadingBogey.getAnchorPosition() : pivoted(
                dce,
                dimension,
                point,
                leading ? leadingWheelSpacing / 2 : bogeySpacing + trailingWheelSpacing / 2,
                leadingUpsideDown,
                trailingUpsideDown
            );

            boolean backAnchorFlip = trailingBogey.isUpsideDown() ^ leadingBogey.isUpsideDown();

            if (isOnTwoBogeys()) {
                dce.rotationAnchors.setFirst(dimension.equals(leadingBogeyDim) ? leadingBogey.getAnchorPosition() : pivoted(
                    dce,
                    dimension,
                    point,
                    leading ? leadingWheelSpacing / 2 : bogeySpacing + trailingWheelSpacing / 2,
                    leadingUpsideDown,
                    trailingUpsideDown
                ));
                dce.rotationAnchors.setSecond(dimension.equals(trailingBogeyDim) ? trailingBogey.getAnchorPosition(backAnchorFlip) : pivoted(
                    dce,
                    dimension,
                    point,
                    leading ? leadingWheelSpacing / 2 + bogeySpacing : trailingWheelSpacing / 2,
                    leadingUpsideDown,
                    trailingUpsideDown
                ));

            } else {
                if (dimension.equals(otherDimension)) {
                    dce.rotationAnchors = leadingBogey.points.map(tp -> tp.getPosition(train.graph));
                } else {
                    dce.rotationAnchors.setFirst(leadingBogey.points.getFirst() == point ? point.getPosition(train.graph) : pivoted(
                        dce,
                        dimension,
                        point,
                        leadingWheelSpacing,
                        leadingUpsideDown,
                        trailingUpsideDown
                    ));
                    dce.rotationAnchors.setSecond(leadingBogey.points.getSecond() == point ? point.getPosition(train.graph) : pivoted(
                        dce,
                        dimension,
                        point,
                        leadingWheelSpacing,
                        leadingUpsideDown,
                        trailingUpsideDown
                    ));
                }
            }

            int prevmin = dce.minAllowedLocalCoord();
            int prevmax = dce.maxAllowedLocalCoord();

            dce.updateCutoff(leading);

            if (prevmin != dce.minAllowedLocalCoord() || prevmax != dce.maxAllowedLocalCoord()) {
                dce.updateRenderedCutoff();
                dce.updatePassengerLoadout();
            }
        }

    }

    private class_243 pivoted(
        DimensionalCarriageEntity dce,
        class_5321<class_1937> dimension,
        TravellingPoint start,
        double offset,
        boolean leadingUpsideDown,
        boolean trailingUpsideDown
    ) {
        if (train.graph == null)
            return dce.pivot == null ? null : dce.pivot.getLocation();
        TrackNodeLocation pivot = dce.findPivot(dimension, start == getLeadingPoint());
        if (pivot == null)
            return null;
        boolean flipped = start != getLeadingPoint() && (leadingUpsideDown != trailingUpsideDown);
        class_243 startVec = start.getPosition(train.graph, flipped);
        class_243 portalVec = pivot.getLocation().method_1031(0, leadingUpsideDown ? -1.0 : 1.0, 0);
        return VecHelper.lerp((float) (offset / startVec.method_1022(portalVec)), startVec, portalVec);
    }

    public void alignEntity(class_1937 level) {
        DimensionalCarriageEntity dimensionalCarriageEntity = entities.get(level.method_27983());
        if (dimensionalCarriageEntity != null) {
            CarriageContraptionEntity entity = dimensionalCarriageEntity.entity.get();
            if (entity != null)
                dimensionalCarriageEntity.alignEntity(entity);
        }
    }

    public TravellingPoint getLeadingPoint() {
        return leadingBogey().leading();
    }

    public TravellingPoint getTrailingPoint() {
        return trailingBogey().trailing();
    }

    public CarriageBogey leadingBogey() {
        return bogeys.getFirst();
    }

    public CarriageBogey trailingBogey() {
        return isOnTwoBogeys() ? bogeys.getSecond() : leadingBogey();
    }

    public boolean isOnTwoBogeys() {
        return bogeys.getSecond() != null;
    }

    public CarriageContraptionEntity anyAvailableEntity() {
        for (DimensionalCarriageEntity dimensionalCarriageEntity : entities.values()) {
            CarriageContraptionEntity entity = dimensionalCarriageEntity.entity.get();
            if (entity != null)
                return entity;
        }
        return null;
    }

    public Pair<class_5321<class_1937>, DimensionalCarriageEntity> anyAvailableDimensionalCarriage() {
        for (Map.Entry<class_5321<class_1937>, DimensionalCarriageEntity> entry : entities.entrySet())
            if (entry.getValue().entity.get() != null)
                return Pair.of(entry.getKey(), entry.getValue());
        return null;
    }

    public void forEachPresentEntity(Consumer<CarriageContraptionEntity> callback) {
        for (DimensionalCarriageEntity dimensionalCarriageEntity : entities.values()) {
            CarriageContraptionEntity entity = dimensionalCarriageEntity.entity.get();
            if (entity != null)
                callback.accept(entity);
        }
    }

    public void write(class_11372 view, DimensionPalette dimensions) {
        bogeys.getFirst().write(view.method_71461("FirstBogey"), dimensions);
        if (isOnTwoBogeys())
            bogeys.getSecond().write(view.method_71461("SecondBogey"), dimensions);
        view.method_71465("Spacing", bogeySpacing);
        view.method_71472("FrontConductor", presentConductors.getFirst());
        view.method_71472("BackConductor", presentConductors.getSecond());
        view.method_71472("Stalled", stalled);

        Map<Integer, class_2487> passengerMap = new HashMap<>();

        for (DimensionalCarriageEntity dimensionalCarriageEntity : entities.values()) {
            CarriageContraptionEntity entity = dimensionalCarriageEntity.entity.get();
            if (entity == null)
                continue;
            serialize(entity);
            Contraption contraption = entity.getContraption();
            if (contraption == null)
                continue;
            Map<UUID, Integer> mapping = contraption.getSeatMapping();
            for (class_1297 passenger : entity.method_5685())
                if (mapping.containsKey(passenger.method_5667())) {
                    try (class_8942.class_11340 logging = new class_8942.class_11340(passenger.method_71370(), Create.LOGGER)) {
                        class_11362 data = class_11362.method_71459(logging, entity.method_56673());
                        if (passenger.method_5786(data))
                            passengerMap.put(mapping.get(passenger.method_5667()), data.method_71475());
                    }
                }
        }

        view.method_71468("Entity", class_2487.field_25128, serialisedEntity.method_10553());

        class_2487 passengerTag = new class_2487();
        passengerMap.putAll(serialisedPassengers);
        passengerMap.forEach((seat, nbt) -> passengerTag.method_10566("Seat" + seat, nbt.method_10553()));
        view.method_71468("Passengers", class_2487.field_25128, passengerTag);

        class_11372.class_11374 list = view.method_71476("EntityPositioning");
        entities.forEach((key, entity) -> {
            class_11372 item = list.method_71480();
            entity.write(item);
            item.method_71468("Dim", dimensions, key);
        });
    }

    public static <T> DataResult<T> encode(final Carriage input, final DynamicOps<T> ops, final T empty, DimensionPalette dimensions) {
        RecordBuilder<T> map = ops.mapBuilder();
        map.add("FirstBogey", CarriageBogey.encode(input.bogeys.getFirst(), ops, empty, dimensions));
        if (input.isOnTwoBogeys())
            map.add("SecondBogey", CarriageBogey.encode(input.bogeys.getSecond(), ops, empty, dimensions));
        map.add("Spacing", ops.createInt(input.bogeySpacing));
        map.add("FrontConductor", ops.createBoolean(input.presentConductors.getFirst()));
        map.add("BackConductor", ops.createBoolean(input.presentConductors.getSecond()));
        map.add("Stalled", ops.createBoolean(input.stalled));

        Map<Integer, class_2487> passengerMap = new HashMap<>();

        for (DimensionalCarriageEntity dimensionalCarriageEntity : input.entities.values()) {
            CarriageContraptionEntity entity = dimensionalCarriageEntity.entity.get();
            if (entity == null)
                continue;
            input.serialize(entity);
            Contraption contraption = entity.getContraption();
            if (contraption == null)
                continue;
            Map<UUID, Integer> mapping = contraption.getSeatMapping();
            for (class_1297 passenger : entity.method_5685())
                if (mapping.containsKey(passenger.method_5667())) {
                    try (class_8942.class_11340 logging = new class_8942.class_11340(passenger.method_71370(), Create.LOGGER)) {
                        class_11362 data = class_11362.method_71459(logging, entity.method_56673());
                        if (passenger.method_5786(data))
                            passengerMap.put(mapping.get(passenger.method_5667()), data.method_71475());
                    }
                }
        }

        map.add("Entity", input.serialisedEntity.method_10553(), class_2487.field_25128);

        class_2487 passengerTag = new class_2487();
        passengerMap.putAll(input.serialisedPassengers);
        passengerMap.forEach((seat, nbt) -> passengerTag.method_10566("Seat" + seat, nbt.method_10553()));
        map.add("Passengers", passengerTag, class_2487.field_25128);

        ListBuilder<T> list = ops.listBuilder();
        input.entities.forEach((key, entity) -> {
            RecordBuilder<T> item = ops.mapBuilder();
            entity.write(ops, empty, item);
            item.add("Dim", key, dimensions);
            list.add(item.build(empty));
        });
        map.add("EntityPositioning", list.build(empty));
        return map.build(empty);
    }

    private void serialize(class_1297 entity) {
        try (class_8942.class_11340 logging = new class_8942.class_11340(entity.method_71370(), Create.LOGGER)) {
            class_11362 view = class_11362.method_71459(logging, entity.method_56673());
            entity.method_5786(view);
            serialisedEntity = view.method_71475();
            serialisedEntity.method_10551("Passengers");
            serialisedEntity.method_10562("Contraption").ifPresent(nbt -> nbt.method_10551("Passengers"));
        }
    }

    public static Carriage read(class_11368 view, TrackGraph graph, DimensionPalette dimensions) {
        CarriageBogey bogey1 = CarriageBogey.read(view.method_71434("FirstBogey"), graph, dimensions);
        CarriageBogey bogey2 = view.method_71420("SecondBogey").map(bogey -> CarriageBogey.read(bogey, graph, dimensions)).orElse(null);

        Carriage carriage = new Carriage(bogey1, bogey2, view.method_71424("Spacing", 0));

        carriage.stalled = view.method_71433("Stalled", false);
        carriage.presentConductors = Couple.create(view.method_71433("FrontConductor", false), view.method_71433("BackConductor", false));
        carriage.serialisedEntity = view.method_71426("Entity", class_2487.field_25128).orElseGet(class_2487::new);

        view.method_71438("EntityPositioning").forEach(item -> {
            carriage.getDimensional(item.method_71426("Dim", dimensions).orElseThrow()).read(item);
        });

        view.method_71426("Passengers", class_2487.field_25128)
            .ifPresent(nbt -> nbt.method_68561((key, value) -> carriage.serialisedPassengers.put(Integer.valueOf(key.substring(4)), (class_2487) value)));

        return carriage;
    }

    public static <T> Carriage decode(DynamicOps<T> ops, T input, TrackGraph graph, DimensionPalette dimensions) {
        MapLike<T> map = ops.getMap(input).getOrThrow();
        CarriageBogey bogey1 = CarriageBogey.decode(ops, map.get("FirstBogey"), graph, dimensions);
        CarriageBogey bogey2 = Optional.ofNullable(map.get("SecondBogey")).map(item -> CarriageBogey.decode(ops, item, graph, dimensions))
            .orElse(null);

        Carriage carriage = new Carriage(bogey1, bogey2, ops.getNumberValue(map.get("Spacing"), 0).intValue());

        carriage.stalled = ops.getBooleanValue(map.get("Stalled")).getOrThrow();
        carriage.presentConductors = Couple.create(
            ops.getBooleanValue(map.get("FrontConductor")).getOrThrow(),
            ops.getBooleanValue(map.get("BackConductor")).getOrThrow()
        );
        carriage.serialisedEntity = class_2487.field_25128.parse(ops, map.get("Entity")).result().orElseGet(class_2487::new);

        ops.getList(map.get("EntityPositioning")).getOrThrow().accept(item -> {
            MapLike<T> entity = ops.getMap(item).getOrThrow();
            carriage.getDimensional(dimensions.parse(ops, entity.get("Dim")).getOrThrow()).read(ops, entity);
        });

        class_2487.field_25128.parse(ops, map.get("Passengers"))
            .ifSuccess(nbt -> nbt.method_68561((key, value) -> carriage.serialisedPassengers.put(Integer.valueOf(key.substring(4)), (class_2487) value)));

        return carriage;
    }

    private TravellingPoint portalScout = new TravellingPoint();

    public class DimensionalCarriageEntity {
        public class_243 positionAnchor;
        public Couple<class_243> rotationAnchors;
        public WeakReference<CarriageContraptionEntity> entity;

        public TrackNodeLocation pivot;
        int discardTicks;

        // 0 == whole, 0..1 = fading out, -1..0 = fading in
        public float cutoff;

        // client
        public boolean pointsInitialised;

        public DimensionalCarriageEntity() {
            this.entity = new WeakReference<>(null);
            this.rotationAnchors = Couple.create(null, null);
            this.pointsInitialised = false;
        }

        public void discardPivot() {
            int prevmin = minAllowedLocalCoord();
            int prevmax = maxAllowedLocalCoord();

            cutoff = 0;
            pivot = null;

            if ((!serialisedPassengers.isEmpty() && entity.get() != null) || prevmin != minAllowedLocalCoord() || prevmax != maxAllowedLocalCoord()) {
                updatePassengerLoadout();
                updateRenderedCutoff();
            }
        }

        public void updateCutoff(boolean leadingIsCurrent) {
            class_243 leadingAnchor = rotationAnchors.getFirst();
            class_243 trailingAnchor = rotationAnchors.getSecond();

            if (leadingAnchor == null || trailingAnchor == null)
                return;
            if (pivot == null) {
                cutoff = 0;
                return;
            }

            class_243 pivotLoc = pivot.getLocation().method_1031(0, 1, 0);

            double leadingSpacing = leadingBogey().type.getWheelPointSpacing() / 2;
            double trailingSpacing = trailingBogey().type.getWheelPointSpacing() / 2;
            double anchorSpacing = leadingSpacing + bogeySpacing + trailingSpacing;

            if (isOnTwoBogeys()) {
                class_243 diff = trailingAnchor.method_1020(leadingAnchor).method_1029();
                trailingAnchor = trailingAnchor.method_1019(diff.method_1021(trailingSpacing));
                leadingAnchor = leadingAnchor.method_1019(diff.method_1021(-leadingSpacing));
            }

            double leadingDiff = leadingAnchor.method_1022(pivotLoc);
            double trailingDiff = trailingAnchor.method_1022(pivotLoc);

            leadingDiff /= anchorSpacing;
            trailingDiff /= anchorSpacing;

            if (leadingIsCurrent && leadingDiff > trailingDiff && leadingDiff > 1)
                cutoff = 0;
            else if (leadingIsCurrent && leadingDiff < trailingDiff && trailingDiff > 1)
                cutoff = 1;
            else if (!leadingIsCurrent && leadingDiff > trailingDiff && leadingDiff > 1)
                cutoff = -1;
            else if (!leadingIsCurrent && leadingDiff < trailingDiff && trailingDiff > 1)
                cutoff = 0;
            else
                cutoff = (float) class_3532.method_15350(1 - (leadingIsCurrent ? leadingDiff : trailingDiff), 0, 1) * (leadingIsCurrent ? 1 : -1);
        }

        public TrackNodeLocation findPivot(class_5321<class_1937> dimension, boolean leading) {
            if (pivot != null)
                return pivot;

            TravellingPoint start = leading ? getLeadingPoint() : getTrailingPoint();
            TravellingPoint end = !leading ? getLeadingPoint() : getTrailingPoint();

            portalScout.node1 = start.node1;
            portalScout.node2 = start.node2;
            portalScout.edge = start.edge;
            portalScout.position = start.position;

            ITrackSelector trackSelector = portalScout.follow(end);
            int distance = bogeySpacing + 10;
            int direction = leading ? -1 : 1;

            portalScout.travel(
                train.graph, direction * distance, trackSelector, portalScout.ignoreEdgePoints(), portalScout.ignoreTurns(), nodes -> {
                    for (boolean b : Iterate.trueAndFalse)
                        if (nodes.get(b).dimension.equals(dimension))
                            pivot = nodes.get(b);
                    return true;
                }
            );

            return pivot;
        }

        public void write(class_11372 view) {
            view.method_71464("Cutoff", cutoff);
            view.method_71465("DiscardTicks", discardTicks);
            storage.write(view, false);
            if (pivot != null)
                pivot.write(view.method_71461("Pivot"), null);
            if (positionAnchor != null)
                view.method_71468("PositionAnchor", class_243.field_38277, positionAnchor);
            if (rotationAnchors.both(Objects::nonNull)) {
                class_11372.class_11373<class_243> list = view.method_71467("RotationAnchors", class_243.field_38277);
                list.method_71484(rotationAnchors.getFirst());
                list.method_71484(rotationAnchors.getSecond());
            }
        }

        public <T> void write(final DynamicOps<T> ops, final T empty, RecordBuilder<T> map) {
            map.add("Cutoff", ops.createFloat(cutoff));
            map.add("DiscardTicks", ops.createInt(discardTicks));
            storage.write(ops, empty, map, false);
            if (pivot != null)
                map.add("Pivot", TrackNodeLocation.encode(pivot, ops, empty, null));
            if (positionAnchor != null)
                map.add("PositionAnchor", positionAnchor, class_243.field_38277);
            if (rotationAnchors.both(Objects::nonNull)) {
                ListBuilder<T> list = ops.listBuilder();
                list.add(rotationAnchors.getFirst(), class_243.field_38277);
                list.add(rotationAnchors.getSecond(), class_243.field_38277);
                map.add("RotationAnchors", list.build(empty));
            }
        }

        public void read(class_11368 view) {
            cutoff = view.method_71423("Cutoff", 0);
            discardTicks = view.method_71424("DiscardTicks", 0);
            storage.read(view, false, null);
            view.method_71420("Pivot").ifPresent(pivot -> this.pivot = TrackNodeLocation.read(pivot, null));
            if (positionAnchor != null)
                return;
            positionAnchor = view.method_71426("PositionAnchor", class_243.field_38277).orElse(null);
            view.method_71435("RotationAnchors", class_243.field_38277).ifPresent(list -> {
                Iterator<class_243> iterator = list.iterator();
                rotationAnchors = Couple.create(iterator.next(), iterator.next());
            });
        }

        public <T> void read(DynamicOps<T> ops, MapLike<T> map) {
            cutoff = ops.getNumberValue(map.get("Cutoff"), 0).floatValue();
            discardTicks = ops.getNumberValue(map.get("DiscardTicks"), 0).intValue();
            storage.read(ops, map, false, null);
            Optional.ofNullable(map.get("Pivot")).ifPresent(pivot -> this.pivot = TrackNodeLocation.decode(ops, pivot, null));
            if (positionAnchor != null)
                return;
            positionAnchor = class_243.field_38277.parse(ops, map.get("PositionAnchor")).result().orElse(null);
            ops.getStream(map.get("RotationAnchors")).ifSuccess(list -> {
                Iterator<T> iterator = list.iterator();
                rotationAnchors = Couple.create(
                    class_243.field_38277.parse(ops, iterator.next()).getOrThrow(),
                    class_243.field_38277.parse(ops, iterator.next()).getOrThrow()
                );
            });
        }

        public class_243 leadingAnchor() {
            return isOnTwoBogeys() ? rotationAnchors.getFirst() : positionAnchor;
        }

        public class_243 trailingAnchor() {
            return isOnTwoBogeys() ? rotationAnchors.getSecond() : positionAnchor;
        }

        public int minAllowedLocalCoord() {
            if (cutoff <= 0)
                return Integer.MIN_VALUE;
            if (cutoff >= 1)
                return Integer.MAX_VALUE;
            return class_3532.method_15375(-bogeySpacing + -1 + (2 + bogeySpacing) * cutoff);
        }

        public int maxAllowedLocalCoord() {
            if (cutoff >= 0)
                return Integer.MAX_VALUE;
            if (cutoff <= -1)
                return Integer.MIN_VALUE;
            return class_3532.method_15386(-bogeySpacing + -1 + (2 + bogeySpacing) * (cutoff + 1));
        }

        public void updatePassengerLoadout() {
            class_1297 entity = this.entity.get();
            if (!(entity instanceof CarriageContraptionEntity cce))
                return;
            if (!(entity.method_73183() instanceof class_3218 sLevel))
                return;

            Set<Integer> loadedPassengers = new HashSet<>();
            int min = minAllowedLocalCoord();
            int max = maxAllowedLocalCoord();

            for (Map.Entry<Integer, class_2487> entry : serialisedPassengers.entrySet()) {
                Integer seatId = entry.getKey();
                List<class_2338> seats = cce.getContraption().getSeats();
                if (seatId >= seats.size())
                    continue;

                class_2338 localPos = seats.get(seatId);
                if (!cce.isLocalCoordWithin(localPos, min, max))
                    continue;

                class_2487 tag = entry.getValue();
                class_1297 passenger = null;

                if (tag.method_10545("PlayerPassenger")) {
                    passenger = sLevel.method_8503().method_3760().method_14602(tag.method_67491("PlayerPassenger", class_4844.field_25122).orElse(null));

                } else {
                    passenger = class_1299.method_71371(
                        tag, entity.method_73183(), class_3730.field_52444, e -> {
                            e.method_29495(positionAnchor);
                            return e;
                        }
                    );
                    if (passenger != null)
                        sLevel.method_30736(passenger);
                }

                if (passenger != null) {
                    class_5321<class_1937> passengerDimension = passenger.method_73183().method_27983();
                    if (!passengerDimension.equals(sLevel.method_27983()) && passenger instanceof class_3222 sp)
                        continue;
                    cce.addSittingPassenger(passenger, seatId);
                }

                loadedPassengers.add(seatId);
            }

            loadedPassengers.forEach(serialisedPassengers::remove);

            Map<UUID, Integer> mapping = cce.getContraption().getSeatMapping();
            for (class_1297 passenger : entity.method_5685()) {
                class_2338 localPos = cce.getContraption().getSeatOf(passenger.method_5667());
                if (cce.isLocalCoordWithin(localPos, min, max))
                    continue;
                if (!mapping.containsKey(passenger.method_5667()))
                    continue;

                Integer seat = mapping.get(passenger.method_5667());
                if ((passenger instanceof class_3222 sp)) {
                    dismountPlayer(sLevel, sp, seat, true);
                    continue;
                }

                try (class_8942.class_11340 logging = new class_8942.class_11340(passenger.method_71370(), Create.LOGGER)) {
                    class_11362 view = class_11362.method_71459(logging, entity.method_56673());
                    passenger.method_5786(view);
                    serialisedPassengers.put(seat, view.method_71475());
                    passenger.method_31472();
                }
            }

        }

        private void dismountPlayer(class_3218 sLevel, class_3222 sp, Integer seat, boolean capture) {
            if (!capture) {
                sp.method_5848();
                return;
            }

            class_2487 tag = new class_2487();
            tag.method_67494("PlayerPassenger", class_4844.field_25122, sp.method_5667());
            serialisedPassengers.put(seat, tag);
            sp.method_5848();
            AllSynchedDatas.CONTRAPTION_DISMOUNT_LOCATION.set(sp, Optional.empty());

            for (Map.Entry<class_5321<class_1937>, DimensionalCarriageEntity> other : entities.entrySet()) {
                DimensionalCarriageEntity otherDce = other.getValue();
                if (otherDce == this)
                    continue;
                if (sp.method_51469().method_27983().equals(other.getKey()))
                    continue;
                class_243 loc = otherDce.pivot == null ? otherDce.positionAnchor : otherDce.pivot.getLocation();
                if (loc == null)
                    continue;
                class_3218 level = sLevel.method_8503().method_3847(other.getKey());
                sp.method_48105(level, loc.field_1352, loc.field_1351, loc.field_1350, Set.of(), sp.method_36454(), sp.method_36455(), true);
                sp.method_30229();
                AllAdvancements.TRAIN_PORTAL.trigger(sp);
            }
        }

        public void updateRenderedCutoff() {
            class_1297 entity = this.entity.get();
            if (!(entity instanceof CarriageContraptionEntity cce))
                return;
            Contraption contraption = cce.getContraption();
            if (!(contraption instanceof CarriageContraption cc))
                return;
            cc.portalCutoffMin = minAllowedLocalCoord();
            cc.portalCutoffMax = maxAllowedLocalCoord();
            if (!entity.method_73183().method_8608())
                return;
            AllClientHandle.INSTANCE.invalidateCarriage(cce);
        }

        private void createEntity(class_1937 level, boolean loadPassengers) {
            if (positionAnchor != null)
                serialisedEntity.method_10566("Pos", VecHelper.writeNBT(positionAnchor));
            try (class_8942.class_11340 logging = new class_8942.class_11340(() -> "Carriage", Create.LOGGER)) {
                class_11368 view = class_11352.method_71417(logging, level.method_30349(), serialisedEntity);
                class_1297 entity = class_1299.method_5892(view, level, class_3730.field_52444).orElse(null);

                if (!(entity instanceof CarriageContraptionEntity cce)) {
                    train.invalid = true;
                    return;
                }

                entity.method_29495(positionAnchor);
                this.entity = new WeakReference<>(cce);

                cce.setCarriage(Carriage.this);
                cce.syncCarriage();

                if (level instanceof class_3218 sl)
                    sl.method_8649(entity);

                updatePassengerLoadout();
            }
        }

        private void removeAndSaveEntity(CarriageContraptionEntity entity, boolean portal) {
            Contraption contraption = entity.getContraption();
            if (contraption != null) {
                Map<UUID, Integer> mapping = contraption.getSeatMapping();
                for (class_1297 passenger : entity.method_5685()) {
                    if (!mapping.containsKey(passenger.method_5667()))
                        continue;

                    Integer seat = mapping.get(passenger.method_5667());

                    if (passenger instanceof class_3222 sp) {
                        dismountPlayer(sp.method_51469(), sp, seat, portal);
                        continue;
                    }

                    try (class_8942.class_11340 logging = new class_8942.class_11340(passenger.method_71370(), Create.LOGGER)) {
                        class_11362 view = class_11362.method_71459(logging, entity.method_56673());
                        passenger.method_5786(view);
                        serialisedPassengers.put(seat, view.method_71475());
                    }
                }
            }

            for (class_1297 passenger : entity.method_5685())
                if (!(passenger instanceof class_1657))
                    passenger.method_31472();

            serialize(entity);
            entity.method_31472();
            this.entity.clear();
        }

        public void alignEntity(CarriageContraptionEntity entity) {
            if (rotationAnchors.either(Objects::isNull))
                return;

            class_243 positionVec = rotationAnchors.getFirst();
            class_243 coupledVec = rotationAnchors.getSecond();

            double diffX = positionVec.field_1352 - coupledVec.field_1352;
            double diffY = positionVec.field_1351 - coupledVec.field_1351;
            double diffZ = positionVec.field_1350 - coupledVec.field_1350;

            entity.prevYaw = entity.yaw;
            entity.prevPitch = entity.pitch;

            if (!entity.method_73183().method_8608()) {
                class_243 lookahead = positionAnchor.method_1019(positionAnchor.method_1020(entity.method_73189()).method_1029().method_1021(16));

                for (class_1297 e : entity.method_5685()) {
                    if (!(e instanceof class_1657))
                        continue;
                    if (e.method_5858(entity) > 32 * 32)
                        continue;
                    if (CarriageEntityHandler.isActiveChunk(entity.method_73183(), class_2338.method_49638(lookahead)))
                        break;
                    train.carriageWaitingForChunks = id;
                    return;
                }

                if (train.carriageWaitingForChunks == id)
                    train.carriageWaitingForChunks = -1;

                entity.setServerSidePrevPosition();
            }

            entity.method_33574(positionAnchor);
            entity.yaw = (float) (class_3532.method_15349(diffZ, diffX) * 180 / Math.PI) + 180;
            entity.pitch = (float) (Math.atan2(diffY, Math.sqrt(diffX * diffX + diffZ * diffZ)) * 180 / Math.PI) * -1;

            if (!entity.firstPositionUpdate)
                return;

            entity.field_6014 = entity.method_23317();
            entity.field_6036 = entity.method_23318();
            entity.field_5969 = entity.method_23321();
            entity.prevYaw = entity.yaw;
            entity.prevPitch = entity.pitch;
        }
    }

}
