package com.zurrtum.create.content.trains.entity;

import com.mojang.serialization.*;
import com.zurrtum.create.AllBogeyStyles;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.trains.bogey.AbstractBogeyBlock;
import com.zurrtum.create.content.trains.bogey.BogeySize;
import com.zurrtum.create.content.trains.bogey.BogeyStyle;
import com.zurrtum.create.content.trains.graph.DimensionPalette;
import com.zurrtum.create.content.trains.graph.TrackGraph;
import com.zurrtum.create.foundation.codec.CreateCodecs;
import org.jetbrains.annotations.Nullable;

import java.util.Iterator;
import java.util.Optional;
import java.util.Random;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1937;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

import static com.zurrtum.create.content.trains.bogey.AbstractBogeyBlockEntity.BOGEY_DATA_KEY;
import static com.zurrtum.create.content.trains.bogey.AbstractBogeyBlockEntity.BOGEY_STYLE_KEY;

public class CarriageBogey {
    public static final class_9139<class_9129, CarriageBogey> STREAM_CODEC = class_9139.method_56436(
        AbstractBogeyBlock.STREAM_CODEC,
        bogey -> bogey.type,
        class_9135.field_48547,
        bogey -> bogey.upsideDown,
        class_9135.field_48556,
        bogey -> bogey.bogeyData,
        CarriageBogey::new
    );

    public static final Random RANDOM = new Random();
    public static final String UPSIDE_DOWN_KEY = "UpsideDown";

    public Carriage carriage;
    public boolean isLeading;

    public class_2487 bogeyData;

    public AbstractBogeyBlock<?> type;
    boolean upsideDown;
    Couple<TravellingPoint> points;

    public LerpedFloat wheelAngle;
    public LerpedFloat yaw;
    public LerpedFloat pitch;

    public Couple<class_243> couplingAnchors;

    int derailAngle;

    public CarriageBogey(AbstractBogeyBlock<?> type, boolean upsideDown, class_2487 bogeyData) {
        this(type, upsideDown, bogeyData, new TravellingPoint(), new TravellingPoint());
    }

    public CarriageBogey(AbstractBogeyBlock<?> type, boolean upsideDown, class_2487 bogeyData, TravellingPoint point, TravellingPoint point2) {
        this.type = type;
        this.upsideDown = type.canBeUpsideDown() && upsideDown;
        point.upsideDown = this.upsideDown;
        point2.upsideDown = this.upsideDown;
        if (bogeyData == null || bogeyData.method_33133())
            bogeyData = this.createBogeyData(); // Prevent Crash When Updating
        bogeyData.method_10556(UPSIDE_DOWN_KEY, upsideDown);
        this.bogeyData = bogeyData;
        points = Couple.create(point, point2);
        wheelAngle = LerpedFloat.angular();
        yaw = LerpedFloat.angular();
        pitch = LerpedFloat.angular();
        derailAngle = RANDOM.nextInt(60) - 30;
        couplingAnchors = Couple.create(null, null);
    }

    public class_5321<class_1937> getDimension() {
        TravellingPoint leading = leading();
        TravellingPoint trailing = trailing();
        if (leading.edge == null || trailing.edge == null)
            return null;
        if (leading.edge.isInterDimensional() || trailing.edge.isInterDimensional())
            return null;
        class_5321<class_1937> dimension1 = leading.node1.getLocation().dimension;
        class_5321<class_1937> dimension2 = trailing.node1.getLocation().dimension;
        if (dimension1.equals(dimension2))
            return dimension1;
        return null;
    }

    public void updateAngles(CarriageContraptionEntity entity, double distanceMoved) {
        double angleDiff = 360 * distanceMoved / (Math.PI * 2 * type.getWheelRadius());

        float xRot = 0;
        float yRot = 0;

        if (leading().edge == null || carriage.train.derailed) {
            yRot = -90 + entity.yaw - derailAngle;
        } else if (!entity.method_73183().method_27983().equals(getDimension())) {
            yRot = -90 + entity.yaw;
            xRot = 0;
        } else {
            class_243 positionVec = leading().getPosition(carriage.train.graph);
            class_243 coupledVec = trailing().getPosition(carriage.train.graph);
            double diffX = positionVec.field_1352 - coupledVec.field_1352;
            double diffY = positionVec.field_1351 - coupledVec.field_1351;
            double diffZ = positionVec.field_1350 - coupledVec.field_1350;
            yRot = AngleHelper.deg(class_3532.method_15349(diffZ, diffX)) + 90;
            xRot = AngleHelper.deg(Math.atan2(diffY, Math.sqrt(diffX * diffX + diffZ * diffZ)));
        }

        double newWheelAngle = (wheelAngle.getValue() - angleDiff) % 360;

        for (boolean twice : Iterate.trueAndFalse) {
            if (twice && !entity.firstPositionUpdate)
                continue;
            wheelAngle.setValue(newWheelAngle);
            pitch.setValue(xRot);
            yaw.setValue(-yRot);
        }
    }

    public TravellingPoint leading() {
        TravellingPoint point = points.getFirst();
        point.upsideDown = isUpsideDown();
        return point;
    }

    public TravellingPoint trailing() {
        TravellingPoint point = points.getSecond();
        point.upsideDown = isUpsideDown();
        return point;
    }

    public double getStress() {
        if (getDimension() == null)
            return 0;
        if (carriage.train.derailed)
            return 0;
        return type.getWheelPointSpacing() - leading().getPosition(carriage.train.graph).method_1022(trailing().getPosition(carriage.train.graph));
    }

    @Nullable
    public class_243 getAnchorPosition() {
        return getAnchorPosition(false);
    }

    @Nullable
    public class_243 getAnchorPosition(boolean flipUpsideDown) {
        if (leading().edge == null)
            return null;
        return points.getFirst().getPosition(carriage.train.graph, flipUpsideDown)
            .method_1019(points.getSecond().getPosition(carriage.train.graph, flipUpsideDown)).method_1021(.5);
    }

    public void updateCouplingAnchor(class_243 entityPos, float entityXRot, float entityYRot, int bogeySpacing, float yaw, float pitch, boolean leading) {
        boolean selfUpsideDown = isUpsideDown();
        boolean leadingUpsideDown = carriage.leadingBogey().isUpsideDown();
        class_243 thisOffset = type.getConnectorAnchorOffset(selfUpsideDown);
        thisOffset = thisOffset.method_18805(1, 1, leading ? -1 : 1);

        thisOffset = VecHelper.rotate(thisOffset, pitch, class_2351.field_11048);
        thisOffset = VecHelper.rotate(thisOffset, yaw, class_2351.field_11052);
        thisOffset = VecHelper.rotate(thisOffset, -entityYRot - 90, class_2351.field_11052);
        thisOffset = VecHelper.rotate(thisOffset, entityXRot, class_2351.field_11048);
        thisOffset = VecHelper.rotate(thisOffset, -180, class_2351.field_11052);
        thisOffset = thisOffset.method_1031(0, 0, leading ? 0 : -bogeySpacing);
        thisOffset = VecHelper.rotate(thisOffset, 180, class_2351.field_11052);
        thisOffset = VecHelper.rotate(thisOffset, -entityXRot, class_2351.field_11048);
        thisOffset = VecHelper.rotate(thisOffset, entityYRot + 90, class_2351.field_11052);
        if (selfUpsideDown != leadingUpsideDown)
            thisOffset = thisOffset.method_1031(0, selfUpsideDown ? -2 : 2, 0);

        couplingAnchors.set(leading, entityPos.method_1019(thisOffset));
    }

    public void write(class_11372 view, DimensionPalette dimensions) {
        view.method_71468("Type", CreateCodecs.BLOCK_CODEC, type);
        class_11372.class_11374 list = view.method_71476("Points");
        points.getFirst().write(list.method_71480(), dimensions);
        points.getSecond().write(list.method_71480(), dimensions);
        view.method_71472("UpsideDown", upsideDown);
        bogeyData.method_10556(UPSIDE_DOWN_KEY, upsideDown);
        bogeyData.method_67494(BOGEY_STYLE_KEY, class_2960.field_25139, getStyle().id);
        view.method_71468(BOGEY_DATA_KEY, class_2487.field_25128, bogeyData);
    }

    public static <T> DataResult<T> encode(final CarriageBogey input, final DynamicOps<T> ops, final T empty, DimensionPalette dimensions) {
        RecordBuilder<T> map = ops.mapBuilder();
        map.add("Type", input.type, CreateCodecs.BLOCK_CODEC);
        ListBuilder<T> list = ops.listBuilder();
        list.add(TravellingPoint.encode(input.points.getFirst(), ops, empty, dimensions));
        list.add(TravellingPoint.encode(input.points.getSecond(), ops, empty, dimensions));
        map.add("Points", list.build(empty));
        map.add("UpsideDown", ops.createBoolean(input.upsideDown));
        input.bogeyData.method_10556(UPSIDE_DOWN_KEY, input.upsideDown);
        input.bogeyData.method_67494(BOGEY_STYLE_KEY, class_2960.field_25139, input.getStyle().id);
        map.add(BOGEY_DATA_KEY, input.bogeyData, class_2487.field_25128);
        return map.build(empty);
    }

    public static CarriageBogey read(class_11368 view, TrackGraph graph, DimensionPalette dimensions) {
        AbstractBogeyBlock<?> type = (AbstractBogeyBlock<?>) view.method_71426("Type", CreateCodecs.BLOCK_CODEC).orElseThrow();
        boolean upsideDown = view.method_71433("UpsideDown", false);
        Iterator<class_11368> iterator = view.method_71438("Points").iterator();
        TravellingPoint point1 = TravellingPoint.read(iterator.next(), graph, dimensions);
        TravellingPoint point2 = TravellingPoint.read(iterator.next(), graph, dimensions);
        class_2487 data = view.method_71426(BOGEY_DATA_KEY, class_2487.field_25128).orElseThrow();
        return new CarriageBogey(type, upsideDown, data, point1, point2);
    }

    public static <T> CarriageBogey decode(DynamicOps<T> ops, T input, TrackGraph graph, DimensionPalette dimensions) {
        MapLike<T> map = ops.getMap(input).getOrThrow();
        AbstractBogeyBlock<?> type = (AbstractBogeyBlock<?>) CreateCodecs.BLOCK_CODEC.parse(ops, map.get("Type")).getOrThrow();
        boolean upsideDown = ops.getBooleanValue(map.get("UpsideDown")).getOrThrow();
        Iterator<T> iterator = ops.getStream(map.get("Points")).getOrThrow().iterator();
        TravellingPoint point1 = TravellingPoint.decode(ops, iterator.next(), graph, dimensions);
        TravellingPoint point2 = TravellingPoint.decode(ops, iterator.next(), graph, dimensions);
        class_2487 data = class_2487.field_25128.parse(ops, map.get(BOGEY_DATA_KEY)).getOrThrow();
        return new CarriageBogey(type, upsideDown, data, point1, point2);
    }

    public BogeyStyle getStyle() {
        Optional<class_2960> location = bogeyData.method_67491(BOGEY_STYLE_KEY, class_2960.field_25139);
        if (location.isEmpty()) {
            return AllBogeyStyles.STANDARD;
        }
        BogeyStyle style = AllBogeyStyles.BOGEY_STYLES.get(location.get());
        return style != null ? style : AllBogeyStyles.STANDARD; // just for safety
    }

    public BogeySize getSize() {
        return type.getSize();
    }

    private class_2487 createBogeyData() {
        BogeyStyle style = type != null ? type.getDefaultStyle() : AllBogeyStyles.STANDARD;
        class_2487 nbt = style.defaultData != null ? style.defaultData : new class_2487();
        nbt.method_67494(BOGEY_STYLE_KEY, class_2960.field_25139, style.id);
        nbt.method_10556(UPSIDE_DOWN_KEY, isUpsideDown());
        return nbt;
    }

    void setLeading() {
        isLeading = true;
    }

    public boolean isUpsideDown() {
        return type.canBeUpsideDown() && upsideDown;
    }
}
