package com.zurrtum.create.content.trains.schedule.condition;

import com.zurrtum.create.content.trains.entity.Train;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;

public abstract class TimedWaitCondition extends ScheduleWaitCondition {

    public enum TimeUnit {
        TICKS(1, "t"),
        SECONDS(20, "s"),
        MINUTES(20 * 60, "min");

        public final int ticksPer;
        public final String suffix;

        TimeUnit(int ticksPer, String suffix) {
            this.ticksPer = ticksPer;
            this.suffix = suffix;
        }
    }

    protected void requestDisplayIfNecessary(class_2487 context, int time) {
        int ticksUntilDeparture = totalWaitTicks() - time;
        if (ticksUntilDeparture < 20 * 60 && ticksUntilDeparture % 100 == 0)
            requestStatusToUpdate(context);
        if (ticksUntilDeparture >= 20 * 60 && ticksUntilDeparture % (20 * 60) == 0)
            requestStatusToUpdate(context);
    }

    public int totalWaitTicks() {
        return getValue() * getUnit().ticksPer;
    }

    public TimedWaitCondition(class_2960 id) {
        super(id);
        data.method_10569("Value", 5);
        data.method_10569("TimeUnit", TimeUnit.SECONDS.ordinal());
    }

    public int getValue() {
        return intData("Value");
    }

    public TimeUnit getUnit() {
        return enumData("TimeUnit", TimeUnit.class);
    }

    @Override
    public class_5250 getWaitingStatus(class_1937 level, Train train, class_2487 tag) {
        int time = tag.method_68083("Time", 0);
        int ticksUntilDeparture = totalWaitTicks() - time;
        boolean showInMinutes = ticksUntilDeparture >= 20 * 60;
        int num = (int) (showInMinutes ? Math.floor(ticksUntilDeparture / (20 * 60f)) : Math.ceil(ticksUntilDeparture / 100f) * 5);
        String key = "generic." + (showInMinutes ? num == 1 ? "daytime.minute" : "unit.minutes" : num == 1 ? "daytime.second" : "unit.seconds");
        return class_2561.method_43469(
            "create.schedule.condition." + id.method_12832() + ".status",
            class_2561.method_43470(num + " ").method_10852(class_2561.method_43471("create." + key))
        );
    }

}
