package com.zurrtum.create.foundation.item;

import com.zurrtum.create.AllTransfer;
import com.zurrtum.create.content.logistics.box.PackageEntity;
import com.zurrtum.create.foundation.block.IBE;
import com.zurrtum.create.infrastructure.items.ItemInventoryProvider;
import com.zurrtum.create.infrastructure.items.ItemStackHandler;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3954;
import net.minecraft.class_6885;
import net.minecraft.class_9288;
import net.minecraft.class_9334;

public class ItemHelper {
    private static final Map<class_2338, InventoryCache> INV_CACHE = new Object2ReferenceOpenHashMap<>();

    public static boolean sameItem(class_1799 stack, class_1799 otherStack) {
        return !otherStack.method_7960() && stack.method_31574(otherStack.method_7909());
    }

    public static Predicate<class_1799> sameItemPredicate(class_1799 stack) {
        return s -> sameItem(stack, s);
    }

    public static List<class_1799> multipliedOutput(class_1799 out, int count) {
        if (out.method_7960()) {
            return new ArrayList<>(0);
        }
        int total = count * out.method_7947();
        int max = out.method_7914();
        int size = total / max;
        int remaining = total % max;
        boolean hasRemaining = remaining != 0;
        List<class_1799> stacks = new ArrayList<>(hasRemaining ? size + 1 : size);
        stacks.add(out);
        if (size != 0) {
            out.method_7939(max);
            for (int i = 1; i < size; i++) {
                stacks.add(out.method_7972());
            }
            if (hasRemaining) {
                stacks.add(out.method_46651(remaining));
            }
        } else {
            out.method_7939(total);
        }
        return stacks;
    }

    public static List<class_1799> multipliedOutput(List<class_1799> out, int count) {
        if (out.isEmpty()) {
            return new ArrayList<>(0);
        }
        List<class_1799> stacks = new ArrayList<>();
        for (class_1799 stack : out) {
            int total = count * stack.method_7947();
            int max = stack.method_58695(class_9334.field_50071, 64);
            int size = total / max;
            stacks.add(stack);
            if (size != 0) {
                stack.method_7939(max);
                for (int i = 1; i < size; i++) {
                    stacks.add(stack.method_7972());
                }
                int remaining = total % max;
                if (remaining != 0) {
                    stacks.add(stack.method_46651(remaining));
                }
            } else {
                stack.method_7939(total);
            }
        }
        return stacks;
    }

    public static void addToList(class_1799 stack, List<class_1799> stacks) {
        for (class_1799 s : stacks) {
            if (!class_1799.method_31577(stack, s))
                continue;
            int transferred = Math.min(s.method_7914() - s.method_7947(), stack.method_7947());
            s.method_7933(transferred);
            stack.method_7934(transferred);
        }
        if (stack.method_7947() > 0)
            stacks.add(stack);
    }

    public static <T extends IBE<? extends class_2586>> int calcRedstoneFromBlockEntity(T ibe, class_1937 level, class_2338 pos) {
        return ibe.getBlockEntityOptional(level, pos).map(be -> getInventory(level, pos, null)).map(ItemHelper::calcRedstoneFromInventory).orElse(0);
    }

    public static int calcRedstoneFromInventory(@Nullable class_1263 inv) {
        if (inv == null)
            return 0;
        int i = 0;
        float f = 0.0F;
        int totalSlots = inv.method_5439();

        for (int j = 0, size = totalSlots; j < size; ++j) {
            int slotLimit = inv.method_5444();
            if (slotLimit == 0) {
                totalSlots--;
                continue;
            }
            class_1799 itemstack = inv.method_5438(j);
            if (!itemstack.method_7960()) {
                f += (float) itemstack.method_7947() / (float) Math.min(slotLimit, itemstack.method_7914());
                ++i;
            }
        }

        if (totalSlots == 0)
            return 0;

        f = f / totalSlots;
        return class_3532.method_15375(f * 14.0F) + (i > 0 ? 1 : 0);
    }

    //TODO
    //    public static List<Pair<Ingredient, MutableInt>> condenseIngredients(DefaultedList<Ingredient> recipeIngredients) {
    //        List<Pair<Ingredient, MutableInt>> actualIngredients = new ArrayList<>();
    //        Ingredients:
    //        for (Ingredient igd : recipeIngredients) {
    //            for (Pair<Ingredient, MutableInt> pair : actualIngredients) {
    //                ItemStack[] stacks1 = pair.getFirst().getItems();
    //                ItemStack[] stacks2 = igd.getItems();
    //                if (stacks1.length != stacks2.length)
    //                    continue;
    //                for (int i = 0; i <= stacks1.length; i++) {
    //                    if (i == stacks1.length) {
    //                        pair.getSecond().increment();
    //                        continue Ingredients;
    //                    }
    //                    if (!ItemStack.areEqual(stacks1[i], stacks2[i]))
    //                        break;
    //                }
    //            }
    //            actualIngredients.add(Pair.of(igd, new MutableInt(1)));
    //        }
    //        return actualIngredients;
    //    }

    public static boolean matchIngredients(class_1856 i1, class_1856 i2) {
        if (i1 == i2)
            return true;
        class_6885<class_1792> entries1 = i1.field_9019;
        class_6885<class_1792> entries2 = i2.field_9019;
        int size = entries1.method_40247();
        if (size == entries2.method_40247()) {
            for (int i = 0; i < size; i++)
                if (!entries1.method_40241(entries2.method_40240(i)))
                    return false;
            return true;
        }
        return false;
    }

    public static boolean matchAllIngredients(List<class_1856> ingredients) {
        if (ingredients.size() <= 1)
            return true;
        class_1856 firstIngredient = ingredients.getFirst();
        for (int i = 1; i < ingredients.size(); i++)
            if (!matchIngredients(firstIngredient, ingredients.get(i)))
                return false;
        return true;
    }

    public static enum ExtractionCountMode {
        EXACTLY,
        UPTO
    }

    public static class_1799 extractItem(class_1263 inventory, int slot, int amount, boolean simulate) {
        class_1799 stack = inventory.method_5438(slot);
        if (stack.method_7960() || (inventory instanceof class_1278 sidedInventory && !sidedInventory.method_5493(slot, stack, null))) {
            return class_1799.field_8037;
        }
        int extract = Math.min(amount, stack.method_7947());
        if (simulate) {
            return stack.method_46651(extract);
        } else if (extract == amount) {
            inventory.method_5447(slot, class_1799.field_8037);
            inventory.method_5431();
            return stack;
        } else {
            class_1799 result = stack.method_7972();
            result.method_7939(extract);
            stack.method_7934(extract);
            inventory.method_5431();
            return result;
        }
    }
    //TODO
    //    public static ItemStack extract(IItemHandler inv, Predicate<ItemStack> test, boolean simulate) {
    //        return extract(inv, test, ExtractionCountMode.UPTO, 64, simulate);
    //    }
    //
    //    public static ItemStack extract(IItemHandler inv, Predicate<ItemStack> test, int exactAmount, boolean simulate) {
    //        return extract(inv, test, ExtractionCountMode.EXACTLY, exactAmount, simulate);
    //    }
    //
    //    public static ItemStack extract(IItemHandler inv, Predicate<ItemStack> test, ExtractionCountMode mode, int amount, boolean simulate) {
    //        ItemStack extracting = ItemStack.EMPTY;
    //        boolean amountRequired = mode == ExtractionCountMode.EXACTLY;
    //        boolean checkHasEnoughItems = amountRequired;
    //        boolean hasEnoughItems = !checkHasEnoughItems;
    //        boolean potentialOtherMatch = false;
    //        int maxExtractionCount = amount;
    //
    //        Extraction:
    //        do {
    //            extracting = ItemStack.EMPTY;
    //
    //            for (int slot = 0; slot < inv.getSlots(); slot++) {
    //                int amountToExtractFromThisSlot = Math.min(
    //                    maxExtractionCount - extracting.getCount(),
    //                    inv.getStackInSlot(slot).getOrDefault(DataComponents.MAX_STACK_SIZE, 64)
    //                );
    //                ItemStack stack = inv.extractItem(slot, amountToExtractFromThisSlot, true);
    //
    //                if (stack.isEmpty())
    //                    continue;
    //                if (!test.test(stack))
    //                    continue;
    //                if (!extracting.isEmpty() && !canItemStackAmountsStack(stack, extracting)) {
    //                    potentialOtherMatch = true;
    //                    continue;
    //                }
    //
    //                if (extracting.isEmpty())
    //                    extracting = stack.copy();
    //                else
    //                    extracting.grow(stack.getCount());
    //
    //                if (!simulate && hasEnoughItems)
    //                    inv.extractItem(slot, stack.getCount(), false);
    //
    //                if (extracting.getCount() >= maxExtractionCount) {
    //                    if (checkHasEnoughItems) {
    //                        hasEnoughItems = true;
    //                        checkHasEnoughItems = false;
    //                        continue Extraction;
    //                    } else {
    //                        break Extraction;
    //                    }
    //                }
    //            }
    //
    //            if (!extracting.isEmpty() && !hasEnoughItems && potentialOtherMatch) {
    //                ItemStack blackListed = extracting.copy();
    //                test = test.and(i -> !ItemStack.isSameItemSameComponents(i, blackListed));
    //                continue;
    //            }
    //
    //            if (checkHasEnoughItems)
    //                checkHasEnoughItems = false;
    //            else
    //                break Extraction;
    //
    //        } while (true);
    //
    //        if (amountRequired && extracting.getCount() < amount)
    //            return ItemStack.EMPTY;
    //
    //        return extracting;
    //    }
    //
    //    public static ItemStack extract(IItemHandler inv, Predicate<ItemStack> test, Function<ItemStack, Integer> amountFunction, boolean simulate) {
    //        ItemStack extracting = ItemStack.EMPTY;
    //        int maxExtractionCount = 64;
    //
    //        for (int slot = 0; slot < inv.getSlots(); slot++) {
    //            if (extracting.isEmpty()) {
    //                ItemStack stackInSlot = inv.getStackInSlot(slot);
    //                if (stackInSlot.isEmpty() || !test.test(stackInSlot))
    //                    continue;
    //                int maxExtractionCountForItem = amountFunction.apply(stackInSlot);
    //                if (maxExtractionCountForItem == 0)
    //                    continue;
    //                maxExtractionCount = Math.min(maxExtractionCount, maxExtractionCountForItem);
    //            }
    //
    //            ItemStack stack = inv.extractItem(slot, maxExtractionCount - extracting.getCount(), true);
    //
    //            if (!test.test(stack))
    //                continue;
    //            if (!extracting.isEmpty() && !canItemStackAmountsStack(stack, extracting))
    //                continue;
    //
    //            if (extracting.isEmpty())
    //                extracting = stack.copy();
    //            else
    //                extracting.grow(stack.getCount());
    //
    //            if (!simulate)
    //                inv.extractItem(slot, stack.getCount(), false);
    //            if (extracting.getCount() >= maxExtractionCount)
    //                break;
    //        }
    //
    //        return extracting;
    //    }

    public static boolean canItemStackAmountsStack(class_1799 a, class_1799 b) {
        return class_1799.method_31577(a, b) && a.method_7947() + b.method_7947() <= a.method_7914();
    }

    public static class_1799 fromItemEntity(class_1297 entityIn) {
        if (!entityIn.method_5805())
            return class_1799.field_8037;
        if (entityIn instanceof PackageEntity packageEntity) {
            return packageEntity.getBox();
        }
        return entityIn instanceof class_1542 itemEntity ? itemEntity.method_6983() : class_1799.field_8037;
    }

    public static void fillItemStackHandler(class_9288 contents, ItemStackHandler inv) {
        List<class_1799> itemStacks = contents.method_57489().toList();

        for (int i = 0; i < itemStacks.size(); i++) {
            inv.method_5447(i, itemStacks.get(i));
        }
    }

    public static class_9288 containerContentsFromHandler(ItemStackHandler handler) {
        return class_9288.method_57493(handler.getStacks());
    }

    public static class_1799 limitCountToMaxStackSize(class_1799 stack, boolean simulate) {
        int count = stack.method_7947();
        int max = stack.method_7914();
        if (count <= max)
            return class_1799.field_8037;
        class_1799 remainder = stack.method_46651(count - max);
        if (!simulate)
            stack.method_7939(max);
        return remainder;
    }

    public static void copyContents(class_1263 from, class_1263 to) {
        if (from.method_5439() != to.method_5439()) {
            throw new IllegalArgumentException("Slot count mismatch");
        }

        for (int slot = to.method_5439() - 1; slot >= 0; slot--) {
            to.method_5447(slot, class_1799.field_8037);
        }

        for (int i = 0; i < from.method_5439(); i++) {
            to.method_5447(i, from.method_5438(i).method_7972());
        }
    }

    public static List<class_1799> getNonEmptyStacks(ItemStackHandler handler) {
        List<class_1799> stacks = new ArrayList<>();
        for (int i = 0, size = handler.method_5439(); i < size; i++) {
            class_1799 stack = handler.method_5438(i);
            if (!stack.method_7960()) {
                stacks.add(stack);
            }
        }
        return stacks;
    }

    public static class_1263 getInventory(class_1937 world, class_2338 pos, class_2350 direction) {
        return getInventory(world, pos, null, null, direction);
    }

    public static class_1263 getInventory(class_1937 world, class_2338 pos, class_2680 state, class_2586 blockEntity, class_2350 direction) {
        if (state == null) {
            state = blockEntity != null ? blockEntity.method_11010() : world.method_8320(pos);
        }
        class_2248 block = state.method_26204();
        if (block instanceof ItemInventoryProvider<?> provider) {
            return provider.getInventory(state, world, pos, blockEntity, direction);
        }
        if (block instanceof class_3954 provider) {
            return provider.method_17680(state, world, pos);
        }
        if (blockEntity == null && state.method_31709()) {
            blockEntity = world.method_8321(pos);
        }
        if (blockEntity instanceof class_1263 inventory) {
            if (inventory instanceof class_2595 && block instanceof class_2281 chestBlock) {
                inventory = class_2281.method_17458(chestBlock, state, world, pos, true);
            }
            return inventory;
        }
        return AllTransfer.getInventory(world, pos, state, blockEntity, direction);
    }

    public static Supplier<class_1263> getInventoryCache(
        class_3218 world,
        class_2338 pos,
        class_2350 direction,
        BiPredicate<class_2586, class_2350> filter
    ) {
        InventoryCache cache = new InventoryCache(world, pos, direction, filter);
        INV_CACHE.put(pos, cache);
        return cache;
    }

    public static void invalidateInventoryCache(class_2338 pos) {
        InventoryCache cache = ItemHelper.INV_CACHE.get(pos);
        if (cache != null) {
            cache.invalidate();
        }
    }
}