package com.zurrtum.create.infrastructure.component;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.catnip.codecs.stream.CatnipStreamCodecBuilders;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.data.IntAttached;
import com.zurrtum.create.content.logistics.BigItemStack;
import com.zurrtum.create.content.logistics.packager.InventorySummary;
import com.zurrtum.create.content.logistics.tableCloth.TableClothBlockEntity;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_4844;
import net.minecraft.class_9139;

public record ShoppingList(@Unmodifiable List<IntAttached<class_2338>> purchases, UUID shopOwner, UUID shopNetwork) {
    public static final Codec<ShoppingList> CODEC = RecordCodecBuilder.create(instance -> instance.group(
        IntAttached.codec(class_2338.field_25064).listOf().fieldOf("purchases").forGetter(ShoppingList::purchases),
        class_4844.field_25122.fieldOf("shop_owner").forGetter(ShoppingList::shopOwner),
        class_4844.field_25122.fieldOf("shop_network").forGetter(ShoppingList::shopNetwork)
    ).apply(instance, ShoppingList::new));

    public static final class_9139<class_2540, ShoppingList> STREAM_CODEC = class_9139.method_56436(
        CatnipStreamCodecBuilders.list(IntAttached.streamCodec(class_2338.field_48404)),
        ShoppingList::purchases,
        class_4844.field_48453,
        ShoppingList::shopOwner,
        class_4844.field_48453,
        ShoppingList::shopNetwork,
        ShoppingList::new
    );

    public ShoppingList duplicate() {
        return new ShoppingList(
            new ArrayList<>(purchases.stream().map(ia -> IntAttached.with(ia.getFirst(), ia.getSecond())).toList()),
            shopOwner,
            shopNetwork
        );
    }

    public int getPurchases(class_2338 clothPos) {
        for (IntAttached<class_2338> entry : purchases)
            if (clothPos.equals(entry.getValue()))
                return entry.getFirst();
        return 0;
    }

    public Couple<InventorySummary> bakeEntries(class_1936 level, @Nullable class_2338 clothPosToIgnore) {
        InventorySummary input = new InventorySummary();
        InventorySummary output = new InventorySummary();

        for (IntAttached<class_2338> entry : purchases) {
            if (clothPosToIgnore != null && clothPosToIgnore.equals(entry.getValue()))
                continue;
            if (!(level.method_8321(entry.getValue()) instanceof TableClothBlockEntity dcbe))
                continue;
            input.add(dcbe.getPaymentItem(), dcbe.getPaymentAmount() * entry.getFirst());
            for (BigItemStack stackEntry : dcbe.requestData.encodedRequest().stacks())
                output.add(stackEntry.stack, stackEntry.count * entry.getFirst());
        }

        return Couple.create(output, input);
    }

    public static class Mutable {
        private final List<IntAttached<class_2338>> purchases = new ArrayList<>();
        private final UUID shopOwner;
        private final UUID shopNetwork;

        public Mutable(ShoppingList list) {
            this.purchases.addAll(list.purchases);
            this.shopOwner = list.shopOwner;
            this.shopNetwork = list.shopNetwork;
        }

        // Y value of clothPos is pixel perfect (x16)
        public void addPurchases(class_2338 clothPos, int amount) {
            for (IntAttached<class_2338> entry : purchases) {
                if (clothPos.equals(entry.getValue())) {
                    entry.setFirst(entry.getFirst() + amount);
                    return;
                }
            }
            purchases.add(IntAttached.with(amount, clothPos));
        }

        public ShoppingList toImmutable() {
            return new ShoppingList(purchases, shopOwner, shopNetwork);
        }
    }
}
