package com.zurrtum.create.infrastructure.config;

import com.zurrtum.create.catnip.config.Builder;
import com.zurrtum.create.catnip.config.ConfigBase;
import com.zurrtum.create.catnip.config.DoubleRawValue;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import org.jetbrains.annotations.Nullable;

import java.util.HashMap;
import java.util.Map;
import java.util.function.DoubleSupplier;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class CStress extends ConfigBase {
    // bump this version to reset configured values.
    private static final int VERSION = 2;

    // IDs need to be used since configs load before registration

    private static final Object2DoubleMap<class_2960> DEFAULT_IMPACTS = new Object2DoubleOpenHashMap<>();
    private static final Object2DoubleMap<class_2960> DEFAULT_CAPACITIES = new Object2DoubleOpenHashMap<>();

    protected final Map<class_2960, DoubleRawValue> capacities = new HashMap<>();
    protected final Map<class_2960, DoubleRawValue> impacts = new HashMap<>();

    public static void setNoImpact(class_2248 block) {
        setImpact(block, 0);
    }

    public static void setImpact(class_2248 block, double value) {
        DEFAULT_IMPACTS.put(class_7923.field_41175.method_10221(block), value);
    }

    public static void setCapacity(class_2248 block, double value) {
        DEFAULT_CAPACITIES.put(class_7923.field_41175.method_10221(block), value);
    }

    @Override
    public void registerAll(Builder builder) {
        builder.comment(Comments.su, Comments.impact).push("impact");
        DEFAULT_IMPACTS.forEach((id, value) -> this.impacts.put(id, builder.define(id.method_12832(), value)));
        builder.pop();

        builder.comment(Comments.su, Comments.capacity).push("capacity");
        DEFAULT_CAPACITIES.forEach((id, value) -> this.capacities.put(id, builder.define(id.method_12832(), value)));
        builder.pop();
    }

    @Override
    public String getName() {
        return "stressValues.v" + VERSION;
    }

    @Nullable
    public DoubleSupplier getImpact(class_2248 block) {
        class_2960 id = class_7923.field_41175.method_10221(block);
        DoubleRawValue value = this.impacts.get(id);
        return value == null ? null : value::get;
    }

    @Nullable
    public DoubleSupplier getCapacity(class_2248 block) {
        class_2960 id = class_7923.field_41175.method_10221(block);
        DoubleRawValue value = this.capacities.get(id);
        return value == null ? null : value::get;
    }

    private static class Comments {
        static String su = "[in Stress Units]";
        static String impact = "Configure the individual stress impact of mechanical blocks. Note that this cost is doubled for every speed increase it receives.";
        static String capacity = "Configure how much stress a source can accommodate for.";
    }

}
