package com.zurrtum.create.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import com.llamalad7.mixinextras.sugar.ref.LocalIntRef;
import com.zurrtum.create.AllDamageTypes;
import com.zurrtum.create.AllSynchedDatas;
import com.zurrtum.create.content.equipment.armor.CardboardArmorHandler;
import com.zurrtum.create.content.equipment.armor.DivingBootsItem;
import com.zurrtum.create.content.equipment.armor.DivingHelmetItem;
import com.zurrtum.create.content.equipment.armor.NetheriteDivingHandler;
import com.zurrtum.create.content.kinetics.deployer.DeployerPlayer;
import com.zurrtum.create.foundation.block.LandingEffectControlBlock;
import com.zurrtum.create.foundation.block.ScaffoldingControlBlock;
import com.zurrtum.create.foundation.block.SlipperinessControlBlock;
import com.zurrtum.create.foundation.block.SoundControlBlock;
import com.zurrtum.create.foundation.item.SwingControlItem;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3611;
import net.minecraft.class_6862;
import net.minecraft.entity.*;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@Mixin(class_1309.class)
public abstract class LivingEntityMixin extends class_1297 {
    @Shadow
    public abstract @Nullable class_1657 getAttackingPlayer();

    @Shadow
    public abstract class_1799 getStackInHand(class_1268 hand);

    public LivingEntityMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @WrapOperation(method = "travelMidAir(Lnet/minecraft/util/math/Vec3d;)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/block/Block;getSlipperiness()F"))
    private float getSlipperiness(class_2248 block, Operation<Float> original, @Local class_2338 pos) {
        if (block instanceof SlipperinessControlBlock controlBlock) {
            return controlBlock.getSlipperiness(method_73183(), pos);
        }
        return original.call(block);
    }

    @WrapOperation(method = "baseTick()V", at = @At(value = "INVOKE", target = "Lnet/minecraft/entity/LivingEntity;isSubmergedIn(Lnet/minecraft/registry/tag/TagKey;)Z"))
    private boolean breatheInLava(class_1309 entity, class_6862<class_3611> tagKey, Operation<Boolean> original, @Local class_3218 serverWorld) {
        if (original.call(entity, tagKey)) {
            return true;
        }
        if (entity instanceof class_3222 serverPlayer && !serverPlayer.method_31549().field_7480 && entity.method_5771()) {
            DivingHelmetItem.breatheInLava(serverPlayer, serverWorld);
        }
        return false;
    }

    @WrapOperation(method = "baseTick()V", at = @At(value = "INVOKE", target = "Lnet/minecraft/entity/effect/StatusEffectUtil;hasWaterBreathing(Lnet/minecraft/entity/LivingEntity;)Z"))
    private boolean canBreatheInWater(class_1309 entity, Operation<Boolean> original, @Local class_3218 serverWorld) {
        if (original.call(entity)) {
            return true;
        }
        if (entity instanceof class_3222 serverPlayer && !serverPlayer.method_31549().field_7480) {
            return DivingHelmetItem.breatheUnderwater(serverPlayer, serverWorld);
        }
        return false;
    }

    @Inject(method = "getEquipmentChanges()Ljava/util/Map;", at = @At(value = "INVOKE", target = "Ljava/util/Map;entrySet()Ljava/util/Set;"))
    private void onLivingEquipmentChange(CallbackInfoReturnable<Map<class_1304, class_1799>> cir) {
        if (((Object) this) instanceof class_1657 player) {
            CardboardArmorHandler.playerChangesEquipment(player);
            NetheriteDivingHandler.onEquipmentChange(player);
        }
    }

    @Inject(method = "travelInFluid(Lnet/minecraft/util/math/Vec3d;)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/entity/LivingEntity;move(Lnet/minecraft/entity/MovementType;Lnet/minecraft/util/math/Vec3d;)V", ordinal = 1))
    private void setOnGround(class_243 movementInput, CallbackInfo ci, @Share("onGround") LocalBooleanRef onGround) {
        if (((Object) this) instanceof class_1657 player) {
            onGround.set(player.method_24828());
        }
    }

    @Inject(method = "travelInFluid(Lnet/minecraft/util/math/Vec3d;)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/entity/LivingEntity;move(Lnet/minecraft/entity/MovementType;Lnet/minecraft/util/math/Vec3d;)V", shift = At.Shift.AFTER, ordinal = 1))
    private void onTravelInFluid(class_243 movementInput, CallbackInfo ci, @Share("onGround") LocalBooleanRef onGround) {
        if (((Object) this) instanceof class_1657 player) {
            DivingBootsItem.onLavaTravel(player, onGround.get());
        }
    }

    @WrapOperation(method = "dropItem(Lnet/minecraft/item/ItemStack;ZZ)Lnet/minecraft/entity/ItemEntity;", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/World;spawnEntity(Lnet/minecraft/entity/Entity;)Z"))
    private boolean captureDrops(class_1937 world, class_1297 entity, Operation<Boolean> original) {
        if (AllSynchedDatas.CRUSH_DROP.get(this)) {
            entity.method_18799(class_243.field_1353);
        } else if (world instanceof class_3218) {
            Optional<List<class_1799>> value = AllSynchedDatas.CAPTURE_DROPS.get(this);
            if (value.isPresent()) {
                value.get().add(((class_1542) entity).method_6983());
                return true;
            }
        }
        return original.call(world, entity);
    }

    @Inject(method = "dropExperience(Lnet/minecraft/server/world/ServerWorld;Lnet/minecraft/entity/Entity;)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/entity/ExperienceOrbEntity;spawn(Lnet/minecraft/server/world/ServerWorld;Lnet/minecraft/util/math/Vec3d;I)V"), cancellable = true)
    private void onDropExperience(class_3218 world, class_1297 attacker, CallbackInfo ci) {
        if (getAttackingPlayer() instanceof DeployerPlayer) {
            ci.cancel();
        }
    }

    @Inject(method = "drop(Lnet/minecraft/server/world/ServerWorld;Lnet/minecraft/entity/damage/DamageSource;)V", at = @At(value = "HEAD"))
    private void onDropPre(class_3218 world, class_1282 damageSource, CallbackInfo ci, @Share("handler") LocalIntRef handler) {
        if (damageSource.method_49708(AllDamageTypes.CRUSH)) {
            AllSynchedDatas.CRUSH_DROP.set(this, true);
            handler.set(1);
        } else if (damageSource.method_5529() instanceof DeployerPlayer) {
            AllSynchedDatas.CAPTURE_DROPS.set(this, Optional.of(new ArrayList<>()));
            handler.set(2);
        }
    }

    @Inject(method = "drop(Lnet/minecraft/server/world/ServerWorld;Lnet/minecraft/entity/damage/DamageSource;)V", at = @At(value = "TAIL"))
    private void onDropPost(class_3218 world, class_1282 damageSource, CallbackInfo ci, @Share("handler") LocalIntRef handler) {
        switch (handler.get()) {
            case 1 -> AllSynchedDatas.CRUSH_DROP.set(this, false);
            case 2 -> AllSynchedDatas.CAPTURE_DROPS.get(this).ifPresent(drops -> {
                class_1661 inventory = ((DeployerPlayer) damageSource.method_5529()).cast().method_31548();
                drops.forEach(inventory::method_7398);
                AllSynchedDatas.CAPTURE_DROPS.set(this, Optional.empty());
            });
        }
    }

    @WrapOperation(method = "fall(DZLnet/minecraft/block/BlockState;Lnet/minecraft/util/math/BlockPos;)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/block/BlockState;isAir()Z"))
    private boolean onLandingEffect(
        class_2680 state,
        Operation<Boolean> original,
        @Local(argsOnly = true) class_2338 pos,
        @Local class_3218 world,
        @Local(ordinal = 1) double distance
    ) {
        if (original.call(state)) {
            return true;
        }
        if (state.method_26204() instanceof LandingEffectControlBlock block) {
            return block.addLandingEffects(state, world, pos, (class_1309) (Object) this, distance);
        }
        return false;
    }

    @Inject(method = "swingHand(Lnet/minecraft/util/Hand;Z)V", at = @At("HEAD"), cancellable = true)
    private void swingHand(class_1268 hand, boolean fromServerPlayer, CallbackInfo ci) {
        class_1799 stack = getStackInHand(hand);
        if (stack.method_7909() instanceof SwingControlItem item) {
            if (item.onEntitySwing(stack, (class_1309) (Object) this, hand)) {
                ci.cancel();
            }
        }
    }

    @Inject(method = "getAttackDistanceScalingFactor(Lnet/minecraft/entity/Entity;)D", at = @At("HEAD"), cancellable = true)
    private void getAttackDistanceScalingFactor(class_1297 entity, CallbackInfoReturnable<Double> cir) {
        if (CardboardArmorHandler.testForStealth(entity)) {
            cir.setReturnValue(0d);
        }
    }

    @WrapOperation(method = "applyClimbingSpeed(Lnet/minecraft/util/math/Vec3d;)Lnet/minecraft/util/math/Vec3d;", at = @At(value = "INVOKE", target = "Lnet/minecraft/block/BlockState;isOf(Lnet/minecraft/block/Block;)Z"))
    private boolean isScaffolding(class_2680 state, class_2248 block, Operation<Boolean> original) {
        return original.call(state, block) || state.method_26204() instanceof ScaffoldingControlBlock;
    }

    @WrapOperation(method = "playBlockFallSound()V", at = @At(value = "INVOKE", target = "Lnet/minecraft/block/BlockState;getSoundGroup()Lnet/minecraft/sound/BlockSoundGroup;"))
    private class_2498 getBlockFallSound(
        class_2680 state,
        Operation<class_2498> original,
        @Local(ordinal = 0) int x,
        @Local(ordinal = 1) int y,
        @Local(ordinal = 2) int z
    ) {
        if (state.method_26204() instanceof SoundControlBlock block) {
            return block.getSoundGroup(method_73183(), new class_2338(x, y, z));
        }
        return original.call(state);
    }
}
