/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.contraptions.pulley;

import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SpriteShiftEntry;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5614;
import net.minecraft.class_761;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public abstract class AbstractPulleyRenderer<T extends KineticBlockEntity>
extends KineticBlockEntityRenderer<T, PulleyRenderState> {
    private final PartialModel halfRope;
    private final PartialModel halfMagnet;

    public AbstractPulleyRenderer(class_5614.class_5615 context, PartialModel halfRope, PartialModel halfMagnet) {
        super(context);
        this.halfRope = halfRope;
        this.halfMagnet = halfMagnet;
    }

    public boolean method_3563() {
        return true;
    }

    @Override
    public PulleyRenderState createRenderState() {
        return new PulleyRenderState();
    }

    @Override
    public void updateRenderState(T be, PulleyRenderState state, float tickProgress, class_243 cameraPos, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable class_11683.class_11792 crumblingOverlay) {
        float f;
        super.updateRenderState(be, state, tickProgress, cameraPos, crumblingOverlay);
        if (state.support) {
            return;
        }
        float offset = this.getOffset(be, tickProgress);
        boolean running = this.isRunning(be);
        state.coil = this.getRotatedCoil(be);
        state.coilShift = this.getCoilShift();
        state.coilScroll = AbstractPulleyRenderer.getCoilVScroll(state.coilShift, offset, 1.0f);
        class_1937 world = be.method_10997();
        class_2680 blockState = be.method_11010();
        if (running || offset == 0.0f) {
            state.magnet = offset > 0.25f ? this.renderMagnet(be) : CachedBuffers.partial(this.halfMagnet, blockState);
            state.magnetOffset = -offset;
            state.magnetLight = class_761.method_23794((class_1920)world, (class_2338)state.field_62673.method_10087((int)offset));
        }
        if (offset > 0.75f && ((f = offset % 1.0f) < 0.25f || f > 0.75f)) {
            state.halfRope = CachedBuffers.partial(this.halfRope, blockState);
            float down = f > 0.75f ? f - 1.0f : f;
            state.halfRopeOffset = -down;
            state.halfRopeLight = class_761.method_23794((class_1920)world, (class_2338)state.field_62673.method_10087((int)down));
        }
        if (!running || offset <= 1.25f) {
            return;
        }
        state.rope = this.renderRope(be);
        int size = (int)Math.ceil(offset - 1.25f);
        float[] offsets = new float[size];
        int[] lights = new int[size];
        for (int i = 0; i < size; ++i) {
            float down = offset - (float)i - 1.0f;
            int light = class_761.method_23794((class_1920)world, (class_2338)state.field_62673.method_10087((int)down));
            offsets[i] = -down;
            lights[i] = light;
        }
        state.offsets = offsets;
        state.lights = lights;
    }

    @Override
    protected class_1921 getRenderType(T be, class_2680 state) {
        return class_1921.method_23577();
    }

    protected abstract class_2350.class_2351 getShaftAxis(T var1);

    protected abstract PartialModel getCoil();

    protected abstract SpriteShiftEntry getCoilShift();

    protected abstract SuperByteBuffer renderRope(T var1);

    protected abstract SuperByteBuffer renderMagnet(T var1);

    protected abstract float getOffset(T var1, float var2);

    protected abstract boolean isRunning(T var1);

    @Override
    protected class_2680 getRenderedBlockState(T be) {
        return AbstractPulleyRenderer.shaft(this.getShaftAxis(be));
    }

    protected SuperByteBuffer getRotatedCoil(T be) {
        class_2680 blockState = be.method_11010();
        return CachedBuffers.partialFacing(this.getCoil(), blockState, class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11056, (class_2350.class_2351)this.getShaftAxis(be)));
    }

    public static float getCoilVScroll(SpriteShiftEntry coilShift, float offset, float speedModifier) {
        if (offset == 0.0f) {
            return 0.0f;
        }
        float spriteSize = coilShift.getTarget().method_4575() - coilShift.getTarget().method_4593();
        double coilScroll = (double)(-((offset *= speedModifier / 2.0f) + 0.1875f)) - Math.floor((offset + 0.1875f) * -2.0f) / 2.0;
        return (float)coilScroll * spriteSize;
    }

    public int method_33893() {
        return (Integer)AllConfigs.server().kinetics.maxRopeLength.get();
    }

    @Environment(value=EnvType.CLIENT)
    public static class PulleyRenderState
    extends KineticBlockEntityRenderer.KineticRenderState {
        public SuperByteBuffer coil;
        public SpriteShiftEntry coilShift;
        public float coilScroll;
        public SuperByteBuffer magnet;
        public float magnetOffset;
        public int magnetLight;
        public SuperByteBuffer halfRope;
        public float halfRopeOffset;
        public int halfRopeLight;
        public SuperByteBuffer rope;
        public float[] offsets;
        public int[] lights;

        @Override
        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            super.render(matricesEntry, vertexConsumer);
            if (this.coilScroll != 0.0f) {
                this.coil.shiftUVScrolling(this.coilShift, this.coilScroll);
            }
            this.coil.light(this.field_62676).renderInto(matricesEntry, vertexConsumer);
            if (this.magnet != null) {
                ((SuperByteBuffer)this.magnet.translate(0.0f, this.magnetOffset, 0.0f)).light(this.magnetLight).renderInto(matricesEntry, vertexConsumer);
            }
            if (this.halfRope != null) {
                ((SuperByteBuffer)this.halfRope.translate(0.0f, this.halfRopeOffset, 0.0f)).light(this.halfRopeLight).renderInto(matricesEntry, vertexConsumer);
            }
            if (this.rope != null) {
                int size = this.offsets.length;
                for (int i = 0; i < size; ++i) {
                    ((SuperByteBuffer)this.rope.translate(0.0f, this.offsets[i], 0.0f)).light(this.lights[i]).renderInto(matricesEntry, vertexConsumer);
                }
            }
        }
    }
}

