/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.equipment.zapper.terrainzapper;

import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.client.content.equipment.zapper.ZapperScreen;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.AllIcons;
import com.zurrtum.create.client.foundation.gui.widget.IconButton;
import com.zurrtum.create.client.foundation.gui.widget.Indicator;
import com.zurrtum.create.client.foundation.gui.widget.Label;
import com.zurrtum.create.client.foundation.gui.widget.ScrollInput;
import com.zurrtum.create.client.foundation.gui.widget.SelectionScrollInput;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.equipment.zapper.ConfigureZapperPacket;
import com.zurrtum.create.content.equipment.zapper.terrainzapper.Brush;
import com.zurrtum.create.content.equipment.zapper.terrainzapper.CylinderBrush;
import com.zurrtum.create.content.equipment.zapper.terrainzapper.DynamicBrush;
import com.zurrtum.create.content.equipment.zapper.terrainzapper.SphereBrush;
import com.zurrtum.create.infrastructure.component.PlacementOptions;
import com.zurrtum.create.infrastructure.component.TerrainBrushes;
import com.zurrtum.create.infrastructure.component.TerrainTools;
import com.zurrtum.create.infrastructure.packet.c2s.ConfigureWorldshaperPacket;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_5244;
import net.minecraft.class_5348;

@Environment(value=EnvType.CLIENT)
public class WorldshaperScreen
extends ZapperScreen {
    protected final class_2561 placementSection = CreateLang.translateDirect("gui.terrainzapper.placement", new Object[0]);
    protected final class_2561 toolSection = CreateLang.translateDirect("gui.terrainzapper.tool", new Object[0]);
    protected final List<class_2561> brushOptions = CreateLang.translatedOptions("gui.terrainzapper.brush", "cuboid", "sphere", "cylinder", "surface", "cluster");
    protected List<IconButton> toolButtons;
    protected List<IconButton> placementButtons;
    protected ScrollInput brushInput;
    protected Label brushLabel;
    protected List<ScrollInput> brushParams = new ArrayList<ScrollInput>(3);
    protected List<Label> brushParamLabels = new ArrayList<Label>(3);
    protected IconButton followDiagonals;
    protected IconButton acrossMaterials;
    protected Indicator followDiagonalsIndicator;
    protected Indicator acrossMaterialsIndicator;
    protected TerrainBrushes currentBrush;
    protected int[] currentBrushParams = new int[]{1, 1, 1};
    protected boolean currentFollowDiagonals;
    protected boolean currentAcrossMaterials;
    protected TerrainTools currentTool;
    protected PlacementOptions currentPlacement;

    public WorldshaperScreen(class_1799 zapper, class_1268 hand) {
        super(AllGuiTextures.TERRAINZAPPER, zapper, hand);
        this.fontColor = -9013642;
        this.title = zapper.method_7964();
        this.currentBrush = (TerrainBrushes)((Object)zapper.method_58695(AllDataComponents.SHAPER_BRUSH, (Object)TerrainBrushes.Cuboid));
        if (zapper.method_57826(AllDataComponents.SHAPER_BRUSH_PARAMS)) {
            class_2338 paramsData = (class_2338)zapper.method_58694(AllDataComponents.SHAPER_BRUSH_PARAMS);
            this.currentBrushParams[0] = paramsData.method_10263();
            this.currentBrushParams[1] = paramsData.method_10264();
            this.currentBrushParams[2] = paramsData.method_10260();
            if (this.currentBrushParams[1] == 0) {
                this.currentFollowDiagonals = true;
            }
            if (this.currentBrushParams[2] == 0) {
                this.currentAcrossMaterials = true;
            }
        }
        this.currentTool = (TerrainTools)((Object)zapper.method_58695(AllDataComponents.SHAPER_TOOL, (Object)TerrainTools.Fill));
        this.currentPlacement = (PlacementOptions)((Object)zapper.method_58695(AllDataComponents.SHAPER_PLACEMENT_OPTIONS, (Object)PlacementOptions.Merged));
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        int x = this.guiLeft;
        int y = this.guiTop;
        this.brushLabel = new Label(x + 61, y + 25, class_5244.field_39003).withShadow();
        this.brushInput = new SelectionScrollInput(x + 56, y + 20, 77, 18).forOptions(this.brushOptions).titled(CreateLang.translateDirect("gui.terrainzapper.brush", new Object[0])).writingTo(this.brushLabel).calling(brushIndex -> {
            this.currentBrush = TerrainBrushes.values()[brushIndex];
            this.initBrushParams(x, y);
        });
        this.brushInput.setState(this.currentBrush.ordinal());
        this.method_37063(this.brushLabel);
        this.method_37063(this.brushInput);
        this.initBrushParams(x, y);
    }

    public AllIcons getIcon(TerrainTools tool) {
        return switch (tool) {
            default -> throw new MatchException(null, null);
            case TerrainTools.Fill -> AllIcons.I_FILL;
            case TerrainTools.Place -> AllIcons.I_PLACE;
            case TerrainTools.Replace -> AllIcons.I_REPLACE;
            case TerrainTools.Clear -> AllIcons.I_CLEAR;
            case TerrainTools.Overlay -> AllIcons.I_OVERLAY;
            case TerrainTools.Flatten -> AllIcons.I_FLATTEN;
        };
    }

    public AllIcons getIcon(PlacementOptions option) {
        return switch (option) {
            default -> throw new MatchException(null, null);
            case PlacementOptions.Merged -> AllIcons.I_CENTERED;
            case PlacementOptions.Attached -> AllIcons.I_ATTACHED;
            case PlacementOptions.Inserted -> AllIcons.I_INSERTED;
        };
    }

    public static class_2561 getParamLabel(Brush brush, int paramIndex) {
        Brush brush2 = brush;
        Objects.requireNonNull(brush2);
        Brush brush3 = brush2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DynamicBrush.class, SphereBrush.class, CylinderBrush.class}, (Object)brush3, n)) {
            case 0 -> {
                DynamicBrush b = (DynamicBrush)brush3;
                yield CreateLang.translateDirect("generic.range", new Object[0]);
            }
            case 1 -> {
                SphereBrush b = (SphereBrush)brush3;
                yield CreateLang.translateDirect("generic.radius", new Object[0]);
            }
            case 2 -> {
                CylinderBrush b = (CylinderBrush)brush3;
                if (paramIndex == 0) {
                    yield CreateLang.translateDirect("generic.radius", new Object[0]);
                }
                yield CreateLang.translateDirect(paramIndex == 1 ? "generic.height" : "generic.length", new Object[0]);
            }
            default -> CreateLang.translateDirect(paramIndex == 0 ? "generic.width" : (paramIndex == 1 ? "generic.height" : "generic.length"), new Object[0]);
        };
    }

    protected void initBrushParams(int x, int y) {
        Brush currentBrush = this.currentBrush.get();
        this.removeWidgets(this.brushParamLabels);
        this.removeWidgets(this.brushParams);
        this.brushParamLabels.clear();
        this.brushParams.clear();
        for (int index = 0; index < 3; ++index) {
            Label label = new Label(x + 65 + 20 * index, y + 45, class_5244.field_39003).withShadow();
            int finalIndex = index;
            ScrollInput input = new ScrollInput(x + 56 + 20 * index, y + 40, 18, 18).withRange(currentBrush.getMin(index), currentBrush.getMax(index) + 1).writingTo(label).titled(WorldshaperScreen.getParamLabel(currentBrush, index).method_27662()).calling(state -> {
                this.currentBrushParams[finalIndex] = state;
                label.method_46421(x + 65 + 20 * finalIndex - this.field_22793.method_27525((class_5348)label.text) / 2);
            });
            input.setState(this.currentBrushParams[index]);
            input.onChanged();
            if (index >= currentBrush.amtParams) {
                input.field_22764 = false;
                label.field_22764 = false;
                input.field_22763 = false;
            }
            this.brushParamLabels.add(label);
            this.brushParams.add(input);
        }
        this.addRenderableWidgets(this.brushParamLabels);
        this.addRenderableWidgets(this.brushParams);
        if (this.followDiagonals != null) {
            this.method_37066(this.followDiagonals);
            this.method_37066(this.followDiagonalsIndicator);
            this.method_37066(this.acrossMaterials);
            this.method_37066(this.acrossMaterialsIndicator);
            this.followDiagonals = null;
            this.followDiagonalsIndicator = null;
            this.acrossMaterials = null;
            this.acrossMaterialsIndicator = null;
        }
        if (currentBrush.hasConnectivityOptions()) {
            int x1 = x + 7 + 72;
            int y1 = y + 79;
            this.followDiagonalsIndicator = new Indicator(x1, y1 - 6, class_5244.field_39003);
            this.followDiagonals = new IconButton(x1, y1, AllIcons.I_FOLLOW_DIAGONAL);
            this.acrossMaterialsIndicator = new Indicator(x1 += 18, y1 - 6, class_5244.field_39003);
            this.acrossMaterials = new IconButton(x1, y1, AllIcons.I_FOLLOW_MATERIAL);
            this.followDiagonals.withCallback(() -> {
                this.followDiagonalsIndicator.state = this.followDiagonalsIndicator.state == Indicator.State.OFF ? Indicator.State.ON : Indicator.State.OFF;
                this.currentFollowDiagonals = !this.currentFollowDiagonals;
            });
            this.followDiagonals.setToolTip((class_2561)CreateLang.translateDirect("gui.terrainzapper.searchDiagonal", new Object[0]));
            this.acrossMaterials.withCallback(() -> {
                this.acrossMaterialsIndicator.state = this.acrossMaterialsIndicator.state == Indicator.State.OFF ? Indicator.State.ON : Indicator.State.OFF;
                this.currentAcrossMaterials = !this.currentAcrossMaterials;
            });
            this.acrossMaterials.setToolTip((class_2561)CreateLang.translateDirect("gui.terrainzapper.searchFuzzy", new Object[0]));
            this.method_37063(this.followDiagonals);
            this.method_37063(this.followDiagonalsIndicator);
            this.method_37063(this.acrossMaterials);
            this.method_37063(this.acrossMaterialsIndicator);
            if (this.currentFollowDiagonals) {
                this.followDiagonalsIndicator.state = Indicator.State.ON;
            }
            if (this.currentAcrossMaterials) {
                this.acrossMaterialsIndicator.state = Indicator.State.ON;
            }
        }
        if (this.toolButtons != null) {
            this.removeWidgets(this.toolButtons);
        }
        TerrainTools[] toolValues = currentBrush.getSupportedTools();
        this.toolButtons = new ArrayList<IconButton>(toolValues.length);
        for (int id = 0; id < toolValues.length; ++id) {
            TerrainTools tool = toolValues[id];
            IconButton toolButton = new IconButton(x + 7 + id * 18, y + 79, this.getIcon(tool));
            toolButton.withCallback(() -> {
                this.toolButtons.forEach(b -> {
                    b.green = false;
                });
                toolButton.green = true;
                this.currentTool = tool;
            });
            toolButton.setToolTip((class_2561)CreateLang.translateDirect("gui.terrainzapper.tool." + tool.translationKey, new Object[0]));
            this.toolButtons.add(toolButton);
        }
        int toolIndex = -1;
        for (int i = 0; i < toolValues.length; ++i) {
            if (this.currentTool != toolValues[i]) continue;
            toolIndex = i;
        }
        if (toolIndex == -1) {
            this.currentTool = toolValues[0];
            toolIndex = 0;
        }
        this.toolButtons.get((int)toolIndex).green = true;
        this.addRenderableWidgets(this.toolButtons);
        if (this.placementButtons != null) {
            this.removeWidgets(this.placementButtons);
        }
        if (currentBrush.hasPlacementOptions()) {
            PlacementOptions[] placementValues = PlacementOptions.values();
            this.placementButtons = new ArrayList<IconButton>(placementValues.length);
            for (int id = 0; id < placementValues.length; ++id) {
                PlacementOptions option = placementValues[id];
                IconButton placementButton = new IconButton(x + 136 + id * 18, y + 79, this.getIcon(option));
                placementButton.withCallback(() -> {
                    this.placementButtons.forEach(b -> {
                        b.green = false;
                    });
                    placementButton.green = true;
                    this.currentPlacement = option;
                });
                placementButton.setToolTip((class_2561)CreateLang.translateDirect("gui.terrainzapper.placement." + option.translationKey, new Object[0]));
                this.placementButtons.add(placementButton);
            }
            this.placementButtons.get((int)this.currentPlacement.ordinal()).green = true;
            this.addRenderableWidgets(this.placementButtons);
        }
    }

    @Override
    protected void drawOnBackground(class_332 graphics, int x, int y) {
        super.drawOnBackground(graphics, x, y);
        Brush currentBrush = this.currentBrush.get();
        for (int index = 2; index >= currentBrush.amtParams; --index) {
            AllGuiTextures.TERRAINZAPPER_INACTIVE_PARAM.render(graphics, x + 56 + 20 * index, y + 40);
        }
        graphics.method_51439(this.field_22793, this.toolSection, x + 7, y + 69, this.fontColor, false);
        if (currentBrush.hasPlacementOptions()) {
            graphics.method_51439(this.field_22793, this.placementSection, x + 136, y + 69, this.fontColor, false);
        }
    }

    @Override
    protected ConfigureZapperPacket getConfigurationPacket() {
        int brushParamY;
        int brushParamX = this.currentBrushParams[0];
        int n = this.followDiagonalsIndicator != null ? (this.followDiagonalsIndicator.state == Indicator.State.ON ? 0 : 1) : (brushParamY = this.currentBrushParams[1]);
        int brushParamZ = this.acrossMaterialsIndicator != null ? (this.acrossMaterialsIndicator.state == Indicator.State.ON ? 0 : 1) : this.currentBrushParams[2];
        return new ConfigureWorldshaperPacket(this.hand, this.currentPattern, this.currentBrush, brushParamX, brushParamY, brushParamZ, this.currentTool, this.currentPlacement);
    }
}

