/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.fluids.pipes;

import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.client.AllFluidConfigs;
import com.zurrtum.create.client.content.fluids.FluidInstance;
import com.zurrtum.create.client.content.fluids.FluidMesh;
import com.zurrtum.create.client.flywheel.api.instance.Instance;
import com.zurrtum.create.client.flywheel.api.visual.DynamicVisual;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.instance.InstanceTypes;
import com.zurrtum.create.client.flywheel.lib.instance.TransformedInstance;
import com.zurrtum.create.client.flywheel.lib.visual.AbstractBlockEntityVisual;
import com.zurrtum.create.client.flywheel.lib.visual.SimpleDynamicVisual;
import com.zurrtum.create.client.flywheel.lib.visual.util.SmartRecycler;
import com.zurrtum.create.client.foundation.render.AllInstanceTypes;
import com.zurrtum.create.client.infrastructure.fluid.FluidConfig;
import com.zurrtum.create.content.fluids.FluidTransportBehaviour;
import com.zurrtum.create.content.fluids.PipeConnection;
import com.zurrtum.create.content.fluids.pipes.StraightPipeBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_1922;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class GlassPipeVisual
extends AbstractBlockEntityVisual<StraightPipeBlockEntity>
implements SimpleDynamicVisual {
    private int light;
    private final SmartRecycler<class_1058, FluidInstance> stream = new SmartRecycler<class_1058, FluidInstance>(sprite -> ctx.instancerProvider().instancer(AllInstanceTypes.FLUID, FluidMesh.stream(sprite)).createInstance());
    private final SmartRecycler<class_1058, TransformedInstance> surface = new SmartRecycler<class_1058, TransformedInstance>(sprite -> ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, FluidMesh.surface(sprite, 0.1875f)).createInstance());

    public GlassPipeVisual(VisualizationContext ctx, StraightPipeBlockEntity blockEntity, float partialTick) {
        super(ctx, blockEntity, partialTick);
    }

    @Override
    public void beginFrame(DynamicVisual.Context ctx) {
        this.stream.resetCount();
        this.surface.resetCount();
        FluidTransportBehaviour pipe = ((StraightPipeBlockEntity)this.blockEntity).getBehaviour(FluidTransportBehaviour.TYPE);
        if (pipe == null) {
            this.stream.discardExtra();
            this.surface.discardExtra();
            return;
        }
        for (class_2350 side : Iterate.directions) {
            class_3611 fluid;
            FluidConfig config;
            LerpedFloat progressLerp;
            FluidStack fluidStack;
            PipeConnection.Flow flow = pipe.getFlow(side);
            if (flow == null || (fluidStack = flow.fluid).isEmpty() || (progressLerp = flow.progress) == null) continue;
            float progress = progressLerp.getValue(ctx.partialTick());
            boolean inbound = flow.inbound;
            if (progress == 1.0f) {
                if (inbound) {
                    PipeConnection.Flow opposite = pipe.getFlow(side.method_10153());
                    if (opposite == null) {
                        progress -= 1.0E-6f;
                    }
                } else {
                    FluidTransportBehaviour adjacent = BlockEntityBehaviour.get((class_1922)this.level, this.pos.method_10093(side), FluidTransportBehaviour.TYPE);
                    if (adjacent == null) {
                        progress -= 1.0E-6f;
                    } else {
                        PipeConnection.Flow other = adjacent.getFlow(side.method_10153());
                        if (other == null || !other.inbound && !other.complete) {
                            progress -= 1.0E-6f;
                        }
                    }
                }
            }
            if ((config = AllFluidConfigs.get(fluid = fluidStack.getFluid())) == null) continue;
            class_1058 flowTexture = config.flowing().get();
            int color = config.tint().apply(fluidStack.getComponentChanges()) | 0xFF000000;
            int blockLightIn = this.light >> 4 & 0xF;
            int luminosity = Math.max(blockLightIn, fluid.method_15785().method_15759().method_26213());
            int light = this.light & 0xF00000 | luminosity << 4;
            if (inbound) {
                side = side.method_10153();
            }
            float yStart = inbound ? 0.0f : 0.5f;
            float progressOffset = class_3532.method_15363((float)(progress * 0.5f), (float)0.0f, (float)1.0f);
            FluidInstance fluidInstance = this.stream.get(flowTexture);
            ((TransformedInstance)((TransformedInstance)((TransformedInstance)fluidInstance.setIdentityTransform().translate((class_2382)this.getVisualPosition())).center()).rotateTo(class_2350.field_11036, side)).translate(0.0f, -0.5f + yStart, 0.0f);
            fluidInstance.light(light).colorArgb(color);
            fluidInstance.vScale = (flowTexture.method_4575() - flowTexture.method_4593()) * 0.5f;
            fluidInstance.v0 = flowTexture.method_4593() + yStart * fluidInstance.vScale;
            fluidInstance.progress = progressOffset;
            fluidInstance.setChanged();
            if (progress == 1.0f) continue;
            class_1058 stillTexture = config.still().get();
            ((TransformedInstance)((TransformedInstance)((TransformedInstance)this.surface.get(stillTexture).setIdentityTransform().translate((class_2382)this.getVisualPosition())).center()).rotateTo(class_2350.field_11036, side)).translate(0.0f, -0.5f + yStart + progressOffset, 0.0f).light(light).colorArgb(color).setChanged();
        }
        this.stream.discardExtra();
        this.surface.discardExtra();
    }

    @Override
    public void collectCrumblingInstances(Consumer<@Nullable Instance> consumer) {
    }

    @Override
    public void updateLight(float partialTick) {
        this.light = this.computePackedLight();
    }

    @Override
    protected void _delete() {
        this.stream.delete();
        this.surface.delete();
    }
}

