/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.lib.instance;

import com.zurrtum.create.client.flywheel.api.instance.InstanceType;
import com.zurrtum.create.client.flywheel.api.layout.FloatRepr;
import com.zurrtum.create.client.flywheel.api.layout.IntegerRepr;
import com.zurrtum.create.client.flywheel.api.layout.LayoutBuilder;
import com.zurrtum.create.client.flywheel.lib.instance.OrientedInstance;
import com.zurrtum.create.client.flywheel.lib.instance.PosedInstance;
import com.zurrtum.create.client.flywheel.lib.instance.ShadowInstance;
import com.zurrtum.create.client.flywheel.lib.instance.SimpleInstanceType;
import com.zurrtum.create.client.flywheel.lib.instance.TransformedInstance;
import com.zurrtum.create.client.flywheel.lib.util.ExtraMemoryOps;
import com.zurrtum.create.client.flywheel.lib.util.ResourceUtil;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.joml.Matrix3fc;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.lwjgl.system.MemoryUtil;

@Environment(value=EnvType.CLIENT)
public final class InstanceTypes {
    public static final InstanceType<TransformedInstance> TRANSFORMED = SimpleInstanceType.builder(TransformedInstance::new).layout(LayoutBuilder.create().vector("color", FloatRepr.NORMALIZED_UNSIGNED_BYTE, 4).vector("overlay", IntegerRepr.SHORT, 2).vector("light", FloatRepr.UNSIGNED_SHORT, 2).matrix("pose", FloatRepr.FLOAT, 4).build()).writer((ptr, instance) -> {
        MemoryUtil.memPutByte((long)ptr, (byte)instance.red);
        MemoryUtil.memPutByte((long)(ptr + 1L), (byte)instance.green);
        MemoryUtil.memPutByte((long)(ptr + 2L), (byte)instance.blue);
        MemoryUtil.memPutByte((long)(ptr + 3L), (byte)instance.alpha);
        ExtraMemoryOps.put2x16(ptr + 4L, instance.overlay);
        ExtraMemoryOps.put2x16(ptr + 8L, instance.light);
        ExtraMemoryOps.putMatrix4f(ptr + 12L, (Matrix4fc)instance.pose);
    }).vertexShader(ResourceUtil.rl("instance/transformed.vert")).cullShader(ResourceUtil.rl("instance/cull/transformed.glsl")).build();
    public static final InstanceType<PosedInstance> POSED = SimpleInstanceType.builder(PosedInstance::new).layout(LayoutBuilder.create().vector("color", FloatRepr.NORMALIZED_UNSIGNED_BYTE, 4).vector("overlay", IntegerRepr.SHORT, 2).vector("light", FloatRepr.UNSIGNED_SHORT, 2).matrix("pose", FloatRepr.FLOAT, 4).matrix("normal", FloatRepr.FLOAT, 3).build()).writer((ptr, instance) -> {
        MemoryUtil.memPutByte((long)ptr, (byte)instance.red);
        MemoryUtil.memPutByte((long)(ptr + 1L), (byte)instance.green);
        MemoryUtil.memPutByte((long)(ptr + 2L), (byte)instance.blue);
        MemoryUtil.memPutByte((long)(ptr + 3L), (byte)instance.alpha);
        ExtraMemoryOps.put2x16(ptr + 4L, instance.overlay);
        ExtraMemoryOps.put2x16(ptr + 8L, instance.light);
        ExtraMemoryOps.putMatrix4f(ptr + 12L, (Matrix4fc)instance.pose);
        ExtraMemoryOps.putMatrix3f(ptr + 76L, (Matrix3fc)instance.normal);
    }).vertexShader(ResourceUtil.rl("instance/posed.vert")).cullShader(ResourceUtil.rl("instance/cull/posed.glsl")).build();
    public static final InstanceType<OrientedInstance> ORIENTED = SimpleInstanceType.builder(OrientedInstance::new).layout(LayoutBuilder.create().vector("color", FloatRepr.NORMALIZED_UNSIGNED_BYTE, 4).vector("overlay", IntegerRepr.SHORT, 2).vector("light", FloatRepr.UNSIGNED_SHORT, 2).vector("position", FloatRepr.FLOAT, 3).vector("pivot", FloatRepr.FLOAT, 3).vector("rotation", FloatRepr.FLOAT, 4).build()).writer((ptr, instance) -> {
        MemoryUtil.memPutByte((long)ptr, (byte)instance.red);
        MemoryUtil.memPutByte((long)(ptr + 1L), (byte)instance.green);
        MemoryUtil.memPutByte((long)(ptr + 2L), (byte)instance.blue);
        MemoryUtil.memPutByte((long)(ptr + 3L), (byte)instance.alpha);
        ExtraMemoryOps.put2x16(ptr + 4L, instance.overlay);
        ExtraMemoryOps.put2x16(ptr + 8L, instance.light);
        MemoryUtil.memPutFloat((long)(ptr + 12L), (float)instance.posX);
        MemoryUtil.memPutFloat((long)(ptr + 16L), (float)instance.posY);
        MemoryUtil.memPutFloat((long)(ptr + 20L), (float)instance.posZ);
        MemoryUtil.memPutFloat((long)(ptr + 24L), (float)instance.pivotX);
        MemoryUtil.memPutFloat((long)(ptr + 28L), (float)instance.pivotY);
        MemoryUtil.memPutFloat((long)(ptr + 32L), (float)instance.pivotZ);
        ExtraMemoryOps.putQuaternionf(ptr + 36L, (Quaternionfc)instance.rotation);
    }).vertexShader(ResourceUtil.rl("instance/oriented.vert")).cullShader(ResourceUtil.rl("instance/cull/oriented.glsl")).build();
    public static final InstanceType<ShadowInstance> SHADOW = SimpleInstanceType.builder(ShadowInstance::new).layout(LayoutBuilder.create().vector("pos", FloatRepr.FLOAT, 3).vector("entityPosXZ", FloatRepr.FLOAT, 2).vector("size", FloatRepr.FLOAT, 2).scalar("alpha", FloatRepr.FLOAT).scalar("radius", FloatRepr.FLOAT).build()).writer((ptr, instance) -> {
        MemoryUtil.memPutFloat((long)ptr, (float)instance.x);
        MemoryUtil.memPutFloat((long)(ptr + 4L), (float)instance.y);
        MemoryUtil.memPutFloat((long)(ptr + 8L), (float)instance.z);
        MemoryUtil.memPutFloat((long)(ptr + 12L), (float)instance.entityX);
        MemoryUtil.memPutFloat((long)(ptr + 16L), (float)instance.entityZ);
        MemoryUtil.memPutFloat((long)(ptr + 20L), (float)instance.sizeX);
        MemoryUtil.memPutFloat((long)(ptr + 24L), (float)instance.sizeZ);
        MemoryUtil.memPutFloat((long)(ptr + 28L), (float)instance.alpha);
        MemoryUtil.memPutFloat((long)(ptr + 32L), (float)instance.radius);
    }).vertexShader(ResourceUtil.rl("instance/shadow.vert")).cullShader(ResourceUtil.rl("instance/cull/shadow.glsl")).build();

    private InstanceTypes() {
    }
}

