/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.infrastructure.ponder.scenes;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.catnip.math.Pointing;
import com.zurrtum.create.client.foundation.ponder.CreateSceneBuilder;
import com.zurrtum.create.client.ponder.api.PonderPalette;
import com.zurrtum.create.client.ponder.api.element.ElementLink;
import com.zurrtum.create.client.ponder.api.element.EntityElement;
import com.zurrtum.create.client.ponder.api.element.WorldSectionElement;
import com.zurrtum.create.client.ponder.api.scene.SceneBuilder;
import com.zurrtum.create.client.ponder.api.scene.SceneBuildingUtil;
import com.zurrtum.create.client.ponder.api.scene.Selection;
import com.zurrtum.create.content.logistics.chute.ChuteBlock;
import com.zurrtum.create.content.logistics.chute.SmartChuteBlockEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;

@Environment(value=EnvType.CLIENT)
public class ChuteScenes {
    public static void downward(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("chute", "Transporting Items downward via Chutes");
        scene.configureBasePlate(0, 0, 5);
        scene.scaleSceneView(0.9f);
        scene.world().showSection(util.select().layer(0), class_2350.field_11036);
        ElementLink<WorldSectionElement> top = scene.world().showIndependentSection(util.select().fromTo(3, 3, 3, 3, 4, 3), class_2350.field_11033);
        ElementLink<WorldSectionElement> bottom = scene.world().showIndependentSection(util.select().fromTo(3, 2, 3, 3, 1, 3), class_2350.field_11033);
        scene.world().moveSection(bottom, util.vector().of(-2.0, 0.0, -1.0), 0);
        scene.world().moveSection(top, util.vector().of(0.0, 0.0, -1.0), 0);
        scene.idle(20);
        class_1799 stack = new class_1799((class_1935)class_1802.field_27071);
        scene.world().createItemEntity(util.vector().centerOf(util.grid().at(3, 3, 2)), util.vector().of(0.0, -0.1, 0.0), stack);
        scene.idle(20);
        ElementLink<EntityElement> remove = scene.world().createItemEntity(util.vector().centerOf(util.grid().at(1, 5, 2)), util.vector().of(0.0, 0.1, 0.0), stack);
        scene.idle(15);
        scene.world().modifyEntity(remove, class_1297::method_31472);
        scene.overlay().showText(60).attachKeyFrame().pointAt(util.vector().topOf(util.grid().at(1, 2, 2))).placeNearTarget().text("Chutes can transport items vertically from and to inventories");
        scene.idle(70);
        scene.world().modifyEntities(class_1542.class, class_1297::method_31472);
        scene.world().moveSection(bottom, util.vector().of(1.0, 0.0, 0.0), 10);
        scene.world().moveSection(top, util.vector().of(-1.0, 0.0, 0.0), 10);
        scene.idle(20);
        scene.overlay().showControls(util.vector().blockSurface(util.grid().at(2, 3, 2), class_2350.field_11043), Pointing.RIGHT, 40).rightClick().withItem(AllItems.WRENCH.method_7854());
        scene.idle(7);
        scene.world().modifyBlock(util.grid().at(3, 3, 3), s -> (class_2680)s.method_11657(ChuteBlock.SHAPE, (Comparable)((Object)ChuteBlock.Shape.WINDOW)), false);
        scene.overlay().showText(50).attachKeyFrame().pointAt(util.vector().blockSurface(util.grid().at(2, 3, 2), class_2350.field_11039)).placeNearTarget().text("Using the Wrench, a window can be created");
        scene.idle(60);
        scene.overlay().showControls(util.vector().blockSurface(util.grid().at(2, 2, 2), class_2350.field_11043), Pointing.RIGHT, 40).rightClick().withItem(AllItems.INDUSTRIAL_IRON_BLOCK.method_7854());
        scene.idle(7);
        scene.world().modifyBlock(util.grid().at(3, 2, 3), s -> (class_2680)s.method_11657(ChuteBlock.SHAPE, (Comparable)((Object)ChuteBlock.Shape.ENCASED)), false);
        scene.overlay().showText(50).pointAt(util.vector().blockSurface(util.grid().at(2, 2, 2), class_2350.field_11039)).placeNearTarget().text("Using Industrial Iron Blocks, chutes can be encased");
        scene.idle(10);
        for (int i = 0; i < 8; ++i) {
            scene.idle(10);
            scene.world().createItemOnBeltLike(util.grid().at(3, 3, 3), class_2350.field_11036, stack);
        }
        scene.idle(20);
        scene.world().hideIndependentSection(bottom, class_2350.field_11034);
        scene.world().hideIndependentSection(top, class_2350.field_11034);
        scene.idle(15);
        scene.addKeyframe();
        scene.rotateCameraY(-90.0f);
        scene.world().modifyBlock(util.grid().at(2, 2, 1), s -> (class_2680)s.method_11657(ChuteBlock.SHAPE, (Comparable)((Object)ChuteBlock.Shape.NORMAL)), false);
        scene.world().modifyBlock(util.grid().at(2, 3, 2), s -> (class_2680)s.method_11657(ChuteBlock.SHAPE, (Comparable)((Object)ChuteBlock.Shape.INTERSECTION)), false);
        scene.world().showSection(util.select().fromTo(2, 1, 1, 2, 2, 1), class_2350.field_11033);
        scene.idle(30);
        class_1799 chuteItem = AllItems.CHUTE.method_7854();
        scene.overlay().showControls(util.vector().blockSurface(util.grid().at(2, 2, 1), class_2350.field_11035), Pointing.LEFT, 30).rightClick().withItem(chuteItem);
        scene.idle(7);
        scene.world().showSection(util.select().position(2, 3, 2), class_2350.field_11043);
        scene.world().restoreBlocks(util.select().position(2, 2, 1));
        scene.idle(15);
        scene.idle(20);
        scene.overlay().showControls(util.vector().blockSurface(util.grid().at(2, 3, 2), class_2350.field_11035), Pointing.LEFT, 30).rightClick().withItem(chuteItem);
        scene.idle(7);
        scene.world().showSection(util.select().position(2, 4, 3), class_2350.field_11043);
        scene.idle(10);
        scene.world().restoreBlocks(util.select().position(2, 3, 2));
        scene.idle(25);
        scene.overlay().showText(70).attachKeyFrame().pointAt(util.vector().blockSurface(util.grid().at(2, 4, 3), class_2350.field_11039)).placeNearTarget().text("Placing chutes targeting the side faces of another will make it diagonal");
        scene.idle(15);
        scene.rotateCameraY(90.0f);
        scene.idle(35);
        class_2350 offset = class_2350.field_11043;
        for (int i = 0; i < 3; ++i) {
            remove = scene.world().createItemEntity(util.vector().centerOf(util.grid().at(2, 6, 3).method_10093(offset)), util.vector().of(0.0, 0.1, 0.0).method_1019(class_243.method_24954((class_2382)offset.method_62675()).method_1021(-0.1)), stack);
            scene.idle(12);
            scene.world().createItemOnBeltLike(util.grid().at(2, 4, 3), class_2350.field_11036, stack);
            scene.world().modifyEntity(remove, class_1297::method_31472);
            scene.idle(3);
            offset = offset.method_10170();
        }
        scene.idle(10);
        scene.overlay().showControls(util.vector().blockSurface(util.grid().at(2, 1, 1), class_2350.field_11043), Pointing.RIGHT, 50).withItem(stack);
        scene.markAsFinished();
    }

    public static void upward(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("chute_upward", "Transporting Items upward via Chutes");
        scene.configureBasePlate(0, 0, 5);
        scene.scaleSceneView(0.9f);
        scene.showBasePlate();
        Selection chute = util.select().fromTo(1, 2, 2, 1, 4, 2);
        scene.world().setBlocks(chute, class_2246.field_10124.method_9564(), false);
        scene.world().showSection(util.select().position(1, 1, 2), class_2350.field_11036);
        scene.idle(20);
        scene.world().restoreBlocks(chute);
        scene.world().showSection(chute, class_2350.field_11033);
        scene.idle(20);
        scene.world().setKineticSpeed(util.select().position(1, 1, 2), 0.0f);
        class_243 surface = util.vector().blockSurface(util.grid().at(1, 2, 2), class_2350.field_11039);
        scene.overlay().showText(70).text("Using Encased Fans at the top or bottom, a Chute can move items upward").attachKeyFrame().pointAt(surface).placeNearTarget();
        scene.idle(80);
        scene.overlay().showControls(util.vector().blockSurface(util.grid().at(1, 2, 2), class_2350.field_11043), Pointing.RIGHT, 50).withItem(AllItems.GOGGLES.method_7854());
        scene.overlay().showText(70).text("Inspecting chutes with Engineers' Goggles reveals information about the movement direction").attachKeyFrame().pointAt(surface).placeNearTarget();
        scene.idle(80);
        scene.world().showSection(util.select().fromTo(2, 2, 2, 4, 1, 5).add(util.select().position(3, 0, 5)), class_2350.field_11033);
        class_1799 stack = new class_1799((class_1935)class_1802.field_27071);
        scene.world().createItemOnBelt(util.grid().at(4, 1, 2), class_2350.field_11034, stack);
        scene.idle(10);
        scene.rotateCameraY(60.0f);
        scene.overlay().showText(70).text("On the 'blocked' end, items will have to be inserted/taken from the sides").attachKeyFrame().pointAt(util.vector().centerOf(util.grid().at(3, 1, 2)).method_1031(0.0, 0.1875, 0.0)).placeNearTarget();
        scene.idle(32);
        scene.world().flapFunnel(util.grid().at(2, 2, 2), false);
        scene.world().removeItemsFromBelt(util.grid().at(2, 1, 2));
        scene.world().createItemOnBeltLike(util.grid().at(1, 2, 2), class_2350.field_11034, stack);
    }

    public static void smart(SceneBuilder builder, SceneBuildingUtil util) {
        int i;
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("smart_chute", "Filtering Items using Smart Chutes");
        scene.configureBasePlate(0, 0, 5);
        scene.scaleSceneView(0.9f);
        Selection lever = util.select().fromTo(0, 1, 2, 1, 3, 2);
        class_2338 smarty = util.grid().at(2, 3, 2);
        scene.world().showSection(util.select().layer(0), class_2350.field_11036);
        scene.idle(5);
        scene.world().showSection(util.select().fromTo(2, 1, 2, 2, 2, 2), class_2350.field_11033);
        scene.idle(10);
        scene.world().showSection(util.select().position(2, 3, 2), class_2350.field_11033);
        scene.overlay().showText(60).text("Smart Chutes are vertical chutes with additional control").attachKeyFrame().pointAt(util.vector().blockSurface(smarty, class_2350.field_11039)).placeNearTarget();
        scene.idle(70);
        class_243 filter = util.vector().blockSurface(smarty, class_2350.field_11043).method_1031(0.0, 0.1875, 0.0);
        scene.overlay().showFilterSlotInput(filter, class_2350.field_11043, 70);
        scene.idle(10);
        scene.rotateCameraY(20.0f);
        scene.overlay().showText(60).text("Items in the filter slot specify what to extract or transfer").attachKeyFrame().pointAt(filter.method_1031(0.0, 0.0, 0.125)).placeNearTarget();
        scene.idle(60);
        scene.world().showSection(util.select().position(2, 4, 2), class_2350.field_11033);
        scene.idle(15);
        class_1799 copper = new class_1799((class_1935)class_1802.field_8620);
        scene.overlay().showControls(filter.method_1031(0.0, 0.125, 0.0), Pointing.DOWN, 40).rightClick().withItem(copper);
        scene.idle(7);
        scene.world().setFilterData(util.select().position(smarty), SmartChuteBlockEntity.class, copper);
        for (i = 0; i < 18; ++i) {
            scene.idle(10);
            scene.world().createItemOnBeltLike(util.grid().at(2, 2, 2), class_2350.field_11036, copper);
            if (i == 8) {
                scene.rotateCameraY(-20.0f);
                scene.overlay().showControls(filter.method_1031(0.0, 0.125, 0.0), Pointing.DOWN, 40).rightClick();
                scene.overlay().showText(50).text("Use the value panel to specify the extracted stack size").attachKeyFrame().pointAt(filter.method_1031(0.0, 0.0, 0.125)).placeNearTarget();
            }
            if (i != 13) continue;
            scene.world().showSection(lever, class_2350.field_11043);
        }
        scene.world().toggleRedstonePower(lever.add(util.select().position(smarty)));
        scene.effects().indicateRedstone(util.grid().at(0, 3, 2));
        scene.overlay().showText(50).text("Redstone power will prevent Smart Chutes from acting.").attachKeyFrame().colored(PonderPalette.RED).pointAt(util.vector().blockSurface(util.grid().at(0, 2, 2), class_2350.field_11036)).placeNearTarget();
        scene.idle(70);
        scene.world().toggleRedstonePower(lever.add(util.select().position(smarty)));
        scene.markAsFinished();
        for (i = 0; i < 8; ++i) {
            scene.idle(10);
            scene.world().createItemOnBeltLike(util.grid().at(2, 2, 2), class_2350.field_11036, copper);
        }
    }
}

