/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.contraptions.bearing;

import com.mojang.serialization.Codec;
import com.zurrtum.create.AllContraptionTypes;
import com.zurrtum.create.api.contraption.ContraptionType;
import com.zurrtum.create.content.contraptions.AssemblyException;
import com.zurrtum.create.content.contraptions.Contraption;
import java.util.HashSet;
import java.util.Locale;
import java.util.Queue;
import java.util.Set;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_3542;
import org.apache.commons.lang3.tuple.Pair;

public class ClockworkContraption
extends Contraption {
    protected class_2350 facing;
    public HandType handType;
    public int offset;
    private final Set<class_2338> ignoreBlocks = new HashSet<class_2338>();

    @Override
    public ContraptionType getType() {
        return AllContraptionTypes.CLOCKWORK;
    }

    private void ignoreBlocks(Set<class_2338> blocks, class_2338 anchor) {
        for (class_2338 blockPos : blocks) {
            this.ignoreBlocks.add(anchor.method_10081((class_2382)blockPos));
        }
    }

    @Override
    protected boolean isAnchoringBlockAt(class_2338 pos) {
        return pos.equals((Object)this.anchor.method_10079(this.facing.method_10153(), this.offset + 1));
    }

    public static Pair<ClockworkContraption, ClockworkContraption> assembleClockworkAt(class_1937 world, class_2338 pos, class_2350 direction) throws AssemblyException {
        int hourArmBlocks = 0;
        ClockworkContraption hourArm = new ClockworkContraption();
        ClockworkContraption minuteArm = null;
        hourArm.facing = direction;
        hourArm.handType = HandType.HOUR;
        if (!hourArm.assemble(world, pos)) {
            return null;
        }
        for (int i = 0; i < 16; ++i) {
            class_2338 offsetPos = class_2338.field_10980.method_10079(direction, i);
            if (hourArm.getBlocks().containsKey(offsetPos)) continue;
            hourArmBlocks = i;
            break;
        }
        if (hourArmBlocks > 0) {
            minuteArm = new ClockworkContraption();
            minuteArm.facing = direction;
            minuteArm.handType = HandType.MINUTE;
            minuteArm.offset = hourArmBlocks;
            minuteArm.ignoreBlocks(hourArm.getBlocks().keySet(), hourArm.anchor);
            if (!minuteArm.assemble(world, pos)) {
                return null;
            }
            if (minuteArm.getBlocks().isEmpty()) {
                minuteArm = null;
            }
        }
        hourArm.startMoving(world);
        hourArm.expandBoundsAroundAxis(direction.method_10166());
        if (minuteArm != null) {
            minuteArm.startMoving(world);
            minuteArm.expandBoundsAroundAxis(direction.method_10166());
        }
        return Pair.of((Object)hourArm, (Object)minuteArm);
    }

    @Override
    public boolean assemble(class_1937 world, class_2338 pos) throws AssemblyException {
        return this.searchMovedStructure(world, pos, this.facing);
    }

    @Override
    public boolean searchMovedStructure(class_1937 world, class_2338 pos, class_2350 direction) throws AssemblyException {
        return super.searchMovedStructure(world, pos.method_10079(direction, this.offset + 1), null);
    }

    @Override
    protected boolean moveBlock(class_1937 world, class_2350 direction, Queue<class_2338> frontier, Set<class_2338> visited) throws AssemblyException {
        if (this.ignoreBlocks.contains(frontier.peek())) {
            frontier.poll();
            return true;
        }
        return super.moveBlock(world, direction, frontier, visited);
    }

    @Override
    public void write(class_11372 view, boolean spawnPacket) {
        super.write(view, spawnPacket);
        view.method_71468("facing", (Codec)class_2350.field_29502, (Object)this.facing);
        view.method_71468("handType", HandType.CODEC, (Object)this.handType);
        view.method_71465("offset", this.offset);
    }

    @Override
    public void read(class_1937 world, class_11368 view, boolean spawnData) {
        this.facing = view.method_71426("facing", (Codec)class_2350.field_29502).orElse(class_2350.field_11033);
        this.handType = view.method_71426("handType", HandType.CODEC).orElse(HandType.HOUR);
        this.offset = view.method_71424("offset", 0);
        super.read(world, view, spawnData);
    }

    @Override
    public boolean canBeStabilized(class_2350 facing, class_2338 localPos) {
        if (class_2338.field_11176.equals((Object)localPos) || class_2338.field_11176.equals((Object)localPos.method_10093(facing))) {
            return false;
        }
        return facing.method_10166() == this.facing.method_10166();
    }

    public static enum HandType implements class_3542
    {
        HOUR,
        MINUTE;

        public static final Codec<HandType> CODEC;

        public String method_15434() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = class_3542.method_28140(HandType::values);
        }
    }
}

