/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.equipment.clipboard;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.content.equipment.clipboard.ClipboardBlock;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.infrastructure.component.ClipboardContent;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1657;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_4844;
import net.minecraft.class_9323;

public class ClipboardBlockEntity
extends SmartBlockEntity {
    private UUID lastEdit;

    public ClipboardBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.CLIPBOARD, pos, state);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.updateWrittenState();
    }

    public void onEditedBy(class_1657 player) {
        this.lastEdit = player.method_5667();
        this.notifyUpdate();
        this.updateWrittenState();
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (this.field_11863.method_8608()) {
            AllClientHandle.INSTANCE.advertiseToAddressHelper(this);
        }
    }

    public void updateWrittenState() {
        boolean shouldBeWritten;
        class_2680 blockState = this.method_11010();
        if (!blockState.method_27852((class_2248)AllBlocks.CLIPBOARD)) {
            return;
        }
        if (this.field_11863.method_8608()) {
            return;
        }
        boolean isWritten = (Boolean)blockState.method_11654((class_2769)ClipboardBlock.WRITTEN);
        if (isWritten == (shouldBeWritten = this.method_58693().method_57832(AllDataComponents.CLIPBOARD_CONTENT))) {
            return;
        }
        this.field_11863.method_8501(this.field_11867, (class_2680)blockState.method_11657((class_2769)ClipboardBlock.WRITTEN, (Comparable)Boolean.valueOf(shouldBeWritten)));
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
    }

    @Override
    protected void write(class_11372 view, boolean clientPacket) {
        super.write(view, clientPacket);
        if (clientPacket) {
            view.method_71468("components", class_9323.field_50234, (Object)this.method_58693());
        }
        if (this.lastEdit != null) {
            view.method_71468("LastEdit", class_4844.field_25122, (Object)this.lastEdit);
        }
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);
        if (clientPacket) {
            view.method_71426("components", class_9323.field_50234).ifPresent(arg_0 -> ((ClipboardBlockEntity)this).method_58684(arg_0));
            UUID lastEdit = view.method_71426("LastEdit", class_4844.field_25122).orElse(null);
            AllClientHandle.INSTANCE.updateClipboardScreen(lastEdit, this.field_11867, (ClipboardContent)this.method_58693().method_58695(AllDataComponents.CLIPBOARD_CONTENT, (Object)ClipboardContent.EMPTY));
        }
    }
}

