/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.steamEngine;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.api.stress.BlockStressValues;
import com.zurrtum.create.content.kinetics.base.GeneratingKineticBlockEntity;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_7923;

public class PoweredShaftBlockEntity
extends GeneratingKineticBlockEntity {
    public class_2338 enginePos;
    public float engineEfficiency;
    public int movementDirection = 1;
    public int initialTicks = 3;
    public class_2248 capacityKey;

    public PoweredShaftBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.POWERED_SHAFT, pos, state);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.initialTicks > 0) {
            --this.initialTicks;
        }
    }

    public void update(class_2338 sourcePos, int direction, float efficiency) {
        class_2338 key;
        this.enginePos = key = this.field_11867.method_10059((class_2382)sourcePos);
        float prev = this.engineEfficiency;
        this.engineEfficiency = efficiency;
        int prevDirection = this.movementDirection;
        if (class_3532.method_15347((float)efficiency, (float)prev) && prevDirection == direction) {
            return;
        }
        this.capacityKey = this.field_11863.method_8320(sourcePos).method_26204();
        this.movementDirection = direction;
        this.updateGeneratedRotation();
    }

    public void remove(class_2338 sourcePos) {
        if (!this.isPoweredBy(sourcePos)) {
            return;
        }
        this.enginePos = null;
        this.engineEfficiency = 0.0f;
        this.movementDirection = 0;
        this.capacityKey = null;
        this.updateGeneratedRotation();
    }

    public boolean canBePoweredBy(class_2338 globalPos) {
        return this.initialTicks == 0 && (this.enginePos == null || this.isPoweredBy(globalPos));
    }

    public boolean isPoweredBy(class_2338 globalPos) {
        class_2338 key = this.field_11867.method_10059((class_2382)globalPos);
        return key.equals((Object)this.enginePos);
    }

    @Override
    protected void write(class_11372 view, boolean clientPacket) {
        view.method_71465("Direction", this.movementDirection);
        if (this.initialTicks > 0) {
            view.method_71465("Warmup", this.initialTicks);
        }
        if (this.enginePos != null && this.capacityKey != null) {
            view.method_71468("EnginePos", class_2338.field_25064, (Object)this.enginePos);
            view.method_71464("EnginePower", this.engineEfficiency);
            view.method_71468("EngineType", class_7923.field_41175.method_39673(), (Object)this.capacityKey);
        }
        super.write(view, clientPacket);
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);
        this.movementDirection = view.method_71424("Direction", 0);
        this.initialTicks = view.method_71424("Warmup", 0);
        view.method_71426("EnginePos", class_2338.field_25064).ifPresentOrElse(pos -> {
            this.enginePos = pos;
            this.engineEfficiency = view.method_71423("EnginePower", 0.0f);
            this.capacityKey = view.method_71426("EngineType", class_7923.field_41175.method_39673()).orElse(null);
        }, () -> {
            this.enginePos = null;
            this.engineEfficiency = 0.0f;
        });
    }

    @Override
    public float getGeneratedSpeed() {
        return this.getCombinedCapacity() > 0.0f ? (float)(this.movementDirection * 16 * this.getSpeedModifier()) : 0.0f;
    }

    private float getCombinedCapacity() {
        return this.capacityKey == null ? 0.0f : (float)((double)this.engineEfficiency * BlockStressValues.getCapacity(this.capacityKey));
    }

    private int getSpeedModifier() {
        return (int)(1.0 + (this.engineEfficiency >= 1.0f ? 3.0 : Math.min(2.0, Math.floor(this.engineEfficiency * 4.0f))));
    }

    @Override
    public float calculateAddedStressCapacity() {
        float capacity;
        this.lastCapacityProvided = capacity = this.getCombinedCapacity() / (float)this.getSpeedModifier();
        return capacity;
    }

    @Override
    public int getRotationAngleOffset(class_2350.class_2351 axis) {
        int combinedCoords = axis.method_10173(this.field_11867.method_10263(), this.field_11867.method_10264(), this.field_11867.method_10260());
        return super.getRotationAngleOffset(axis) + (combinedCoords % 2 == 0 ? 180 : 0);
    }
}

