/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.logistics.box;

import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllEntityTypes;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.catnip.data.Glob;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.logistics.box.PackageEntity;
import com.zurrtum.create.content.logistics.box.PackageStyles;
import com.zurrtum.create.foundation.item.EntityItem;
import com.zurrtum.create.foundation.item.ItemHelper;
import com.zurrtum.create.infrastructure.component.PackageOrderData;
import com.zurrtum.create.infrastructure.component.PackageOrderWithCrafts;
import com.zurrtum.create.infrastructure.items.ItemStackHandler;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_10712;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1826;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3730;
import net.minecraft.class_9288;
import org.jetbrains.annotations.Nullable;

public class PackageItem
extends class_1792
implements EntityItem {
    public static final int SLOTS = 9;
    public PackageStyles.PackageStyle style;

    public PackageItem(class_1792.class_1793 properties, PackageStyles.PackageStyle style) {
        super(properties);
        this.style = style;
        PackageStyles.ALL_BOXES.add(this);
        (style.rare() ? PackageStyles.RARE_BOXES : PackageStyles.STANDARD_BOXES).add(this);
    }

    public static Function<class_1792.class_1793, PackageItem> styled(PackageStyles.PackageStyle style) {
        return properties -> new PackageItem((class_1792.class_1793)properties, style);
    }

    public static boolean isPackage(class_1799 stack) {
        return stack.method_7909() instanceof PackageItem;
    }

    public boolean method_31568() {
        return false;
    }

    @Override
    public class_1297 createEntity(class_1937 world, class_1297 location, class_1799 itemstack) {
        return PackageEntity.fromDroppedItem(world, location, itemstack);
    }

    public static class_1799 containing(List<class_1799> stacks) {
        ItemStackHandler newInv = new ItemStackHandler(9);
        newInv.insert(stacks);
        return PackageItem.containing(newInv);
    }

    public static class_1799 containing(ItemStackHandler stacks) {
        class_1799 box = PackageStyles.getRandomBox();
        box.method_57379(AllDataComponents.PACKAGE_CONTENTS, (Object)ItemHelper.containerContentsFromHandler(stacks));
        return box;
    }

    public static void clearAddress(class_1799 box) {
        box.method_57381(AllDataComponents.PACKAGE_ADDRESS);
    }

    public static void addAddress(class_1799 box, String address) {
        box.method_57379(AllDataComponents.PACKAGE_ADDRESS, (Object)address);
    }

    public static void setOrder(class_1799 box, int orderId, int linkIndex, boolean isFinalLink, int fragmentIndex, boolean isFinal, @Nullable PackageOrderWithCrafts orderContext) {
        PackageOrderData order = new PackageOrderData(orderId, linkIndex, isFinalLink, fragmentIndex, isFinal, orderContext);
        box.method_57379(AllDataComponents.PACKAGE_ORDER_DATA, (Object)order);
    }

    public static int getOrderId(class_1799 box) {
        if (box.method_57826(AllDataComponents.PACKAGE_ORDER_DATA)) {
            return ((PackageOrderData)box.method_58694(AllDataComponents.PACKAGE_ORDER_DATA)).orderId();
        }
        return -1;
    }

    public static boolean hasOrderData(class_1799 box) {
        return box.method_57826(AllDataComponents.PACKAGE_ORDER_DATA);
    }

    public static int getIndex(class_1799 box) {
        if (box.method_57826(AllDataComponents.PACKAGE_ORDER_DATA)) {
            return ((PackageOrderData)box.method_58694(AllDataComponents.PACKAGE_ORDER_DATA)).fragmentIndex();
        }
        return -1;
    }

    public static boolean isFinal(class_1799 box) {
        return box.method_57826(AllDataComponents.PACKAGE_ORDER_DATA) && ((PackageOrderData)box.method_58694(AllDataComponents.PACKAGE_ORDER_DATA)).isFinal();
    }

    public static int getLinkIndex(class_1799 box) {
        if (box.method_57826(AllDataComponents.PACKAGE_ORDER_DATA)) {
            return ((PackageOrderData)box.method_58694(AllDataComponents.PACKAGE_ORDER_DATA)).linkIndex();
        }
        return -1;
    }

    public static boolean isFinalLink(class_1799 box) {
        return box.method_57826(AllDataComponents.PACKAGE_ORDER_DATA) && ((PackageOrderData)box.method_58694(AllDataComponents.PACKAGE_ORDER_DATA)).isFinalLink();
    }

    @Nullable
    public static PackageOrderWithCrafts getOrderContext(class_1799 box) {
        if (box.method_57826(AllDataComponents.PACKAGE_ORDER_DATA)) {
            PackageOrderData data = (PackageOrderData)box.method_58694(AllDataComponents.PACKAGE_ORDER_DATA);
            return data.orderContext();
        }
        if (box.method_57826(AllDataComponents.PACKAGE_ORDER_CONTEXT)) {
            return (PackageOrderWithCrafts)box.method_58694(AllDataComponents.PACKAGE_ORDER_CONTEXT);
        }
        return null;
    }

    public static void addOrderContext(class_1799 box, PackageOrderWithCrafts orderContext) {
        box.method_57379(AllDataComponents.PACKAGE_ORDER_CONTEXT, (Object)orderContext);
    }

    public static boolean matchAddress(class_1799 box, String address) {
        return PackageItem.matchAddress(PackageItem.getAddress(box), address);
    }

    public static boolean matchAddress(String boxAddress, String address) {
        if (address.isBlank()) {
            return boxAddress.isBlank();
        }
        if (address.equals("*") || boxAddress.equals("*")) {
            return true;
        }
        if (address.equals(boxAddress)) {
            return true;
        }
        return address.matches(Glob.toRegexPattern(boxAddress, "")) || boxAddress.matches(Glob.toRegexPattern(address, ""));
    }

    public static String getAddress(class_1799 box) {
        return (String)box.method_58695(AllDataComponents.PACKAGE_ADDRESS, (Object)"");
    }

    public static float getWidth(class_1799 box) {
        class_1792 class_17922 = box.method_7909();
        if (class_17922 instanceof PackageItem) {
            PackageItem pi = (PackageItem)class_17922;
            return (float)pi.style.width() / 16.0f;
        }
        return 1.0f;
    }

    public static float getHeight(class_1799 box) {
        class_1792 class_17922 = box.method_7909();
        if (class_17922 instanceof PackageItem) {
            PackageItem pi = (PackageItem)class_17922;
            return (float)pi.style.height() / 16.0f;
        }
        return 1.0f;
    }

    public static float getHookDistance(class_1799 box) {
        class_1792 class_17922 = box.method_7909();
        if (class_17922 instanceof PackageItem) {
            PackageItem pi = (PackageItem)class_17922;
            return pi.style.riggingOffset() / 16.0f;
        }
        return 1.0f;
    }

    public static ItemStackHandler getContents(class_1799 box) {
        ItemStackHandler newInv = new ItemStackHandler(9);
        class_9288 contents = (class_9288)box.method_58695(AllDataComponents.PACKAGE_CONTENTS, (Object)class_9288.field_49334);
        ItemHelper.fillItemStackHandler(contents, newInv);
        return newInv;
    }

    public void method_67187(class_1799 stack, class_1792.class_9635 tooltipContext, class_10712 displayComponent, Consumer<class_2561> textConsumer, class_1836 type) {
        super.method_67187(stack, tooltipContext, displayComponent, textConsumer, type);
        if (stack.method_57826(AllDataComponents.PACKAGE_ADDRESS)) {
            textConsumer.accept((class_2561)class_2561.method_43470((String)("\u2192 " + (String)stack.method_58694(AllDataComponents.PACKAGE_ADDRESS))).method_27692(class_124.field_1065));
        }
        if (!stack.method_57826(AllDataComponents.PACKAGE_CONTENTS)) {
            return;
        }
        int visibleNames = 0;
        int skippedNames = 0;
        ItemStackHandler contents = PackageItem.getContents(stack);
        int size = contents.method_5439();
        for (int i = 0; i < size; ++i) {
            class_1799 itemstack = contents.method_5438(i);
            if (itemstack.method_7960() || itemstack.method_7909() instanceof class_1826) continue;
            if (visibleNames > 2) {
                ++skippedNames;
                continue;
            }
            ++visibleNames;
            textConsumer.accept((class_2561)class_2561.method_43469((String)"item.container.item_count", (Object[])new Object[]{itemstack.method_7964(), itemstack.method_7947()}).method_27692(class_124.field_1080));
        }
        if (skippedNames > 0) {
            textConsumer.accept((class_2561)class_2561.method_43469((String)"item.container.more_items", (Object[])new Object[]{skippedNames}).method_27692(class_124.field_1056));
        }
    }

    public int method_7881(class_1799 stack, class_1309 entity) {
        return 72000;
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8953;
    }

    public class_1269 open(class_1937 worldIn, class_1657 playerIn, class_1268 handIn) {
        class_1799 box = playerIn.method_5998(handIn);
        ItemStackHandler contents = PackageItem.getContents(box);
        class_1799 particle = box.method_7972();
        playerIn.method_6122(handIn, box.method_7947() <= 1 ? class_1799.field_8037 : box.method_46651(box.method_7947() - 1));
        if (!worldIn.method_8608()) {
            int size = contents.method_5439();
            for (int i = 0; i < size; ++i) {
                class_1799 itemstack = contents.method_5438(i);
                if (itemstack.method_7960()) continue;
                class_1792 class_17922 = itemstack.method_7909();
                if (class_17922 instanceof class_1826) {
                    class_1826 sei = (class_1826)class_17922;
                    if (worldIn instanceof class_3218) {
                        class_3218 sl = (class_3218)worldIn;
                        class_1299 entitytype = sei.method_8015(itemstack);
                        class_1297 entity = entitytype.method_5894(sl, itemstack, null, class_2338.method_49638((class_2374)playerIn.method_73189().method_1019(playerIn.method_5720().method_18805(1.0, 0.0, 1.0).method_1029())), class_3730.field_16465, false, false);
                        if (entity != null) {
                            itemstack.method_7934(1);
                        }
                    }
                }
                playerIn.method_31548().method_7398(itemstack.method_7972());
            }
        }
        class_243 position = playerIn.method_73189();
        AllSoundEvents.PACKAGE_POP.playOnServer(worldIn, (class_2382)playerIn.method_24515());
        if (worldIn.method_8608()) {
            for (int i = 0; i < 10; ++i) {
                class_243 motion = VecHelper.offsetRandomly(class_243.field_1353, worldIn.method_8409(), 0.125f);
                class_243 pos = position.method_1031(0.0, 0.5, 0.0).method_1019(playerIn.method_5720().method_1021(0.5)).method_1019(motion.method_1021(4.0));
                worldIn.method_8406((class_2394)new class_2392(class_2398.field_11218, particle), pos.field_1352, pos.field_1351, pos.field_1350, motion.field_1352, motion.field_1351, motion.field_1350);
            }
        }
        return class_1269.field_5812.method_61393(box);
    }

    public class_1269 method_7884(class_1838 context) {
        if (context.method_8036().method_5715()) {
            return this.open(context.method_8045(), context.method_8036(), context.method_20287());
        }
        class_243 point = context.method_17698();
        float h = (float)this.style.height() / 16.0f;
        float r = (float)this.style.width() / 2.0f / 16.0f;
        if (context.method_8038() == class_2350.field_11033) {
            point = point.method_1023(0.0, (double)(h + 0.25f), 0.0);
        } else if (context.method_8038().method_10166().method_10179()) {
            point = point.method_1019(class_243.method_24954((class_2382)context.method_8038().method_62675()).method_1021((double)r));
        }
        class_238 scanBB = new class_238(point, point).method_1009((double)r, 0.0, (double)r).method_1012(0.0, (double)h, 0.0);
        class_1937 world = context.method_8045();
        if (!world.method_18023(AllEntityTypes.PACKAGE, scanBB, e -> true).isEmpty()) {
            return super.method_7884(context);
        }
        PackageEntity packageEntity = new PackageEntity(world, point.field_1352, point.field_1351, point.field_1350);
        class_1799 itemInHand = context.method_8041();
        packageEntity.setBox(itemInHand.method_7972());
        world.method_8649((class_1297)packageEntity);
        itemInHand.method_7934(1);
        return class_1269.field_5812;
    }

    public class_1269 method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        if (player.method_5715()) {
            return this.open(world, player, hand);
        }
        class_1799 itemstack = player.method_5998(hand);
        player.method_6019(hand);
        return class_1269.field_5812.method_61393(itemstack);
    }

    public boolean method_7840(class_1799 stack, class_1937 world, class_1309 entity, int ticks) {
        if (!(entity instanceof class_1657)) {
            return false;
        }
        class_1657 player = (class_1657)entity;
        int i = this.method_7881(stack, entity) - ticks;
        if (i < 0) {
            return false;
        }
        float f = PackageItem.getPackageVelocity(i);
        if ((double)f < 0.1) {
            return false;
        }
        if (world.method_8608()) {
            return false;
        }
        world.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14873, class_3419.field_15254, 0.5f, 0.5f);
        class_1799 copy = stack.method_7972();
        if (!player.method_31549().field_7477) {
            stack.method_7934(1);
        }
        class_243 vec = new class_243(entity.method_23317(), entity.method_23318() + entity.method_5829().method_17940() / 2.0, entity.method_23321());
        class_243 motion = entity.method_5720().method_1021((double)(f * 2.0f));
        vec = vec.method_1019(motion);
        PackageEntity packageEntity = new PackageEntity(world, vec.field_1352, vec.field_1351, vec.field_1350);
        packageEntity.setBox(copy);
        packageEntity.method_18799(motion);
        packageEntity.tossedBy = new WeakReference<class_1657>(player);
        world.method_8649((class_1297)packageEntity);
        return false;
    }

    public static float getPackageVelocity(int p_185059_0_) {
        float f = (float)p_185059_0_ / 20.0f;
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }
}

