/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.redstone.displayLink.source;

import com.zurrtum.create.api.behaviour.display.DisplaySource;
import com.zurrtum.create.content.fluids.tank.BoilerData;
import com.zurrtum.create.content.fluids.tank.FluidTankBlockEntity;
import com.zurrtum.create.content.redstone.displayLink.DisplayLinkContext;
import com.zurrtum.create.content.redstone.displayLink.target.DisplayTargetStats;
import com.zurrtum.create.content.trains.display.FlapDisplayBlockEntity;
import com.zurrtum.create.content.trains.display.FlapDisplayLayout;
import com.zurrtum.create.content.trains.display.FlapDisplaySection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import joptsimple.internal.Strings;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_3722;
import net.minecraft.class_5250;

public class BoilerDisplaySource
extends DisplaySource {
    public static final List<class_5250> notEnoughSpaceSingle = List.of(class_2561.method_43471((String)"create.display_source.boiler.not_enough_space").method_10852((class_2561)class_2561.method_43471((String)"create.display_source.boiler.for_boiler_status")));
    public static final List<class_5250> notEnoughSpaceDouble = List.of(class_2561.method_43471((String)"create.display_source.boiler.not_enough_space"), class_2561.method_43471((String)"create.display_source.boiler.for_boiler_status"));
    public static final List<List<class_5250>> notEnoughSpaceFlap = List.of(List.of(class_2561.method_43471((String)"create.display_source.boiler.not_enough_space")), List.of(class_2561.method_43471((String)"create.display_source.boiler.for_boiler_status")));

    @Override
    public List<class_5250> provideText(DisplayLinkContext context, DisplayTargetStats stats) {
        if (stats.maxRows() < 2) {
            return notEnoughSpaceSingle;
        }
        if (stats.maxRows() < 4) {
            return notEnoughSpaceDouble;
        }
        boolean isBook = context.getTargetBlockEntity() instanceof class_3722;
        if (isBook) {
            Stream<class_5250> componentList = this.getComponents(context, false).map(components -> {
                Optional reduce = components.stream().reduce(class_5250::method_10852);
                return reduce.orElse(EMPTY_LINE);
            });
            return List.of(componentList.reduce((comp1, comp2) -> comp1.method_10852((class_2561)class_2561.method_43470((String)"\n")).method_10852((class_2561)comp2)).orElse(EMPTY_LINE));
        }
        return this.getComponents(context, false).map(components -> {
            Optional reduce = components.stream().reduce(class_5250::method_10852);
            return reduce.orElse(EMPTY_LINE);
        }).toList();
    }

    @Override
    public List<List<class_5250>> provideFlapDisplayText(DisplayLinkContext context, DisplayTargetStats stats) {
        if (stats.maxRows() < 4) {
            context.flapDisplayContext = Boolean.FALSE;
            return notEnoughSpaceFlap;
        }
        List<List<class_5250>> components = this.getComponents(context, true).toList();
        if ((float)stats.maxColumns() * 7.0f < 42.0f + (float)components.get(1).get(1).getString().length() * 9.0f) {
            context.flapDisplayContext = Boolean.FALSE;
            return notEnoughSpaceFlap;
        }
        return components;
    }

    @Override
    public void loadFlapDisplayLayout(DisplayLinkContext context, FlapDisplayBlockEntity flapDisplay, FlapDisplayLayout layout, int lineIndex) {
        Boolean b;
        Object object;
        if (lineIndex == 0 || (object = context.flapDisplayContext) instanceof Boolean && !(b = (Boolean)object).booleanValue()) {
            if (layout.isLayout("Default")) {
                return;
            }
            layout.loadDefault(flapDisplay.getMaxCharCount());
            return;
        }
        String layoutKey = "Boiler";
        if (layout.isLayout(layoutKey)) {
            return;
        }
        int labelLength = (int)((float)this.labelWidth() * 7.0f);
        float maxSpace = (float)flapDisplay.getMaxCharCount(1) * 7.0f;
        FlapDisplaySection label = new FlapDisplaySection(labelLength, "alphabet", false, true);
        FlapDisplaySection symbols = new FlapDisplaySection(maxSpace - (float)labelLength, "pixel", false, false).wideFlaps();
        layout.configure(layoutKey, List.of(label, symbols));
    }

    private Stream<List<class_5250>> getComponents(DisplayLinkContext context, boolean forFlapDisplay) {
        class_2586 sourceBE = context.getSourceBlockEntity();
        if (!(sourceBE instanceof FluidTankBlockEntity)) {
            return Stream.of(EMPTY);
        }
        FluidTankBlockEntity tankBlockEntity = (FluidTankBlockEntity)sourceBE;
        tankBlockEntity = tankBlockEntity.getControllerBE();
        if (tankBlockEntity == null) {
            return Stream.of(EMPTY);
        }
        BoilerData boiler = tankBlockEntity.boiler;
        int totalTankSize = tankBlockEntity.getTotalTankSize();
        boiler.calcMinMaxForSize(totalTankSize);
        String label = forFlapDisplay ? "create.boiler.status" : "create.boiler.status_short";
        class_5250 size = this.labelOf(forFlapDisplay ? "size" : "");
        class_5250 water = this.labelOf(forFlapDisplay ? "water" : "");
        class_5250 heat = this.labelOf(forFlapDisplay ? "heat" : "");
        int lw = this.labelWidth();
        if (forFlapDisplay) {
            size = class_2561.method_43470((String)Strings.repeat((char)' ', (int)(lw - this.labelWidthOf("size")))).method_10852((class_2561)size);
            water = class_2561.method_43470((String)Strings.repeat((char)' ', (int)(lw - this.labelWidthOf("water")))).method_10852((class_2561)water);
            heat = class_2561.method_43470((String)Strings.repeat((char)' ', (int)(lw - this.labelWidthOf("heat")))).method_10852((class_2561)heat);
        }
        return Stream.of(List.of(class_2561.method_43469((String)label, (Object[])new Object[]{boiler.getHeatLevelTextComponent()})), List.of(size, boiler.getSizeComponent(!forFlapDisplay, forFlapDisplay, class_124.field_1070)), List.of(water, boiler.getWaterComponent(!forFlapDisplay, forFlapDisplay, class_124.field_1070)), List.of(heat, boiler.getHeatComponent(!forFlapDisplay, forFlapDisplay, class_124.field_1070)));
    }

    private int labelWidth() {
        return Math.max(this.labelWidthOf("water"), Math.max(this.labelWidthOf("size"), this.labelWidthOf("heat")));
    }

    private int labelWidthOf(String label) {
        return this.labelOf(label).getString().length();
    }

    private class_5250 labelOf(String label) {
        if (label.isBlank()) {
            return class_2561.method_43473();
        }
        return class_2561.method_43471((String)("create.boiler." + label));
    }

    @Override
    protected String getTranslationKey() {
        return "boiler_status";
    }
}

